/*
 * interrupt.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <i386/segment.h>
#include <i386/interrupt.h>

#include <kern/debug.h>


//=====================================  ===================================================

enum{
	IDT_ENTRY = 256,		// Interrupt descriptorȥ꡼
};

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * IDT
 */
DESCRIPTOR idt[IDT_ENTRY];

/*
 * IDT Reg
 */
DTR idtr = {IDT_ENTRY * 8 - 1, idt};

/*
 * IDTꤹ
 */
void set_idt(
	const int num,			// IDT number
	const void *func,		// Interrupt entry
	const int flag)			// IDT_INTR or IDT_TRAP
{
	idt[num].low = ((uint) func & 0xffff) | (KERNEL_CODE_DES << 16);
	idt[num].high = 0x8000 | ((uint) func & 0xffff0000) | flag;
}
