/*
 * i386/lib.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/proc.h>
#include <i386/segment.h>
#include <i386/lib.h>

#include <kern/debug.h>


//#define DEBUG_I386_LIB 1
#ifdef DEBUG_I386_LIB
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

extern void switchRealMode(void *);
extern void jumpToBios();

//================================== PRIVATE ============================================
/*
static const uchar indexTbl1[] = {
	0,1,1,2,2,3,3,3,3,4,4,4,4,4,4,4,
	4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
};

static const uchar indexTbl2[] = {
	0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
};

static const uchar existTbl[] = {
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
};
*/
/*
 * ꥢ⡼IDTơ֥륻ΰ
 */
static char realIdt[0x400];

//================================== PROTECT ============================================

//================================== PUBLIC =============================================

void saveRealIdt()
{
	memcpy(realIdt, (void*) 0, 0x400);
}

void storeRealIdt()
{
	memcpy((void*) 0, realIdt, 0x400);
}

void reboot()
{
	switchRealMode(jumpToBios);
}

/*
 * Хǥ르ꥺѡΤ٤ǣ饤ǥå򿶤롣
 * 00
 *       2ʲ1
 *       4ʲ2 ...
 * return : ǥå
 */
/*
int getBuddyIndex(
	const uint size)
{
	int byte1 = size & UCHAR_MAX;
	int byte2 = (size >> (CHAR_BIT * 1)) & UCHAR_MAX;
	int byte3 = (size >> (CHAR_BIT * 2)) & UCHAR_MAX;
	int byte4 = (size >> (CHAR_BIT * 3)) & UCHAR_MAX;
	int byteZero2 = 1 - existTbl[byte2];
	int byteZero3 = 1 - existTbl[byte3];
	int byteZero4 = 1 - existTbl[byte4];
	int index4 = indexTbl2[byte4] + (CHAR_BIT * 3 + (existTbl[byte1] | existTbl[byte2] | existTbl[byte3])) * existTbl[byte4];
	int index3 = indexTbl2[byte3] + (CHAR_BIT * 2 + (existTbl[byte1] | existTbl[byte2])) * existTbl[byte3];
	int index2 = indexTbl2[byte2] + (CHAR_BIT * 1 + existTbl[byte1]) * existTbl[byte2];
	int index1 = indexTbl1[byte1];
	
	return index4
		+ index3 * byteZero4
		+ index2 * byteZero4 * byteZero3
		+ index1 * byteZero4 * byteZero3 * byteZero2;
}
*/
/*
 * Хǥ르ꥺѡǥå飲Τ٤襵
 * return : Τ٤襵
 */
/*
uint getBuddySize(
	const int index)
{
	static const uint size[] = {
		0,          0x2,       0x4,       0x8,       
		0x10,       0x20,      0x40,      0x80,      
		0x100,      0x200,     0x400,     0x800,     
		0x1000,     0x2000,    0x4000,    0x8000,    
		0x10000,    0x20000,   0x40000,   0x80000,   
		0x100000,   0x200000,  0x400000,  0x800000,  
		0x1000000,  0x2000000, 0x4000000, 0x8000000, 
		0x10000000, 0x20000000,0x40000000,0x80000000,
		0xffffffff};
	
	ASSERT(index < sizeof(size) / sizeof(uint));
	
	return  size[index];
}
*/
