/*
 * pc.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסPC
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <dev/console/keyboard.h>

#include <kern/debug.h>


//#define DEBUG_PC 1
#ifdef DEBUG_PC
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * PCν
 * return : error number
 */
int initPc()
{
	volatile int *test1, *test2;

	/*
	 * ɥ쥹饤20ӥåܤBIOS̵ˤƤΤͭˤ롣
	 */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xad);		/* Disable keyboard. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xd1);		/* Write to output. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_OUTPUT_REG, 0xdf);		/* A20 enable. */
	while (inb(KEYBOARD_STAT_REG) & 2);
	outb(KEYBOARD_COMMAND_REG, 0xae);		/* Enable keyboard. */
	while (inb(KEYBOARD_STAT_REG) & 2);

	// A20ͭˤʤäå
	test1 = (int*) 0x00007c;
	test2 = (int*) 0x10007c;
	*test1 = 0xa5a5a5a5;
	if (*test2 != 0xa5a5a5a5) {
		return NOERR;
	}
	*test1 = 0x5a5a5a5a;
	if (*test2 != 0x5a5a5a5a) {
		return NOERR;
	}
	return ERR;
}
