/*
 * tss.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/segment.h>
#include <machine/lib.h>
#include <machine/tss.h>

#include <kern/debug.h>


//#define DEBUG_I386_TSS 1
#ifdef DEBUG_I386_TSS
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

/*
 * Intel 386 Context Data Type
 */
struct i386tss {
	int	tss_link;		/* actually 16 bits: top 16 bits must be zero */
	int	tss_esp0;		/* kernel stack pointer privilege level 0 */
#define	tss_ksp	tss_esp0
	int	tss_ss0;		/* actually 16 bits: top 16 bits must be zero */
	int	tss_esp1; 		/* kernel stack pointer privilege level 1 */
	int	tss_ss1;		/* actually 16 bits: top 16 bits must be zero */
	int	tss_esp2; 		/* kernel stack pointer privilege level 2 */
	int	tss_ss2;		/* actually 16 bits: top 16 bits must be zero */
	int	tss_cr3; 		/* page table directory */
#define	tss_ptd	tss_cr3
	int	tss_eip; 		/* program counter */
#define	tss_pc	tss_eip
	int	tss_eflags; 	/* program status longword */
#define	tss_psl	tss_eflags
	int	tss_eax;
	int	tss_ecx;
	int	tss_edx;
	int	tss_ebx;
	int	tss_esp;		/* user stack pointer */
#define	tss_usp	tss_esp
	int	tss_ebp;		/* user frame pointer */
#define	tss_fp	tss_ebp
	int	tss_esi;
	int	tss_edi;
	int	tss_es;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_cs;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_ss;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_ds;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_fs;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_gs;			/* actually 16 bits: top 16 bits must be zero */
	int	tss_ldt;		/* actually 16 bits: top 16 bits must be zero */
	int	tss_ioopt;		/* options & io offset bitmap: currently zero */
						/* XXX unimplemented .. i/o permission bitmap */
};

//================================== Х륤ݡ ===============================

extern void loadTss();

//================================== PRIVATE ============================================

/*
 * TSS󥰻Υååɬ
 */
static struct i386tss kernelTss[MAX_CPU];

//================================== PUBLIC =============================================

/*
 * TSSǥץ
 */
void initTss(
	const int cpu)		// CPUֹ
{
	kernelTss[cpu].tss_esp0 = KERNEL_ESP_BEG;
	kernelTss[cpu].tss_ss0 = KERNEL_DATA_DES;
	set_gdt(TSS_DES + cpu * sizeof(DESCRIPTOR), (uint) &kernelTss[cpu], 104, TYPE_TSS);
	loadTss(TSS_DES + cpu * sizeof(DESCRIPTOR));
}
