/*
 * vm.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסCPU¸ۥ꡼
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/Thread.h>
#include <kern/vm.h>
#include <i386/interrupt.h>
#include <i386/vm.h>

#include <kern/debug.h>

//#define DEBUG_I386_VM 1
#ifdef DEBUG_I386_VM
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * ڡե㳰
 *ճ߶ػߤǸƤӽФ
 */
void receivePageFault(
	TaskContext i_frame)
{
	uint fualtAddr = getFualtAddr();

	sti();
	pageFault(getVmTask(getCurrentTask()), getVmProc(getCurrentProc()), fualtAddr, &i_frame);
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

/*
 * ڡǥ쥯ȥ꤫鲾ۥɥ쥹Υǥ쥯ȥꥨȥ꡼ɥ쥹
 * return : ڡǥ쥯ȥꥨȥ꡼ɥ쥹
 */
uint *getPageDirEntryAddr(
	const uint i_addr,		// ۥɥ쥹
	uint *i_pageDir)		// ڡǥ쥯ȥꥢɥ쥹
{
	return &i_pageDir[i_addr >> 22];
}

/*
 * ڡơ֥뤫鲾ۥɥ쥹Υڡȥ꡼ɥ쥹
 * return : ڡȥ꡼ɥ쥹
 */
uint *getPageEntryAddrFromPageTbl(
	const uint i_addr,		// ۥɥ쥹
	uint *i_pageTbl)		// ڡơ֥륢ɥ쥹
{
	return &i_pageTbl[(i_addr >> 12) & 0x3ff];
}

/*
 * ȥ꡼ݻƤʪ꡼ɥ쥹롣
 * return : ʪɥ쥹 or NULL
 */
void *getPhysMemFromEntry(
	const uint i_entry)
{
	if (i_entry & PAGE_PRESEN) {
		return (void*) (i_entry & ~(PAGE_SIZE - 1));
	}
	else {
		return NULL;
	}
}

//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

/*
 * ڡȥ꡼򥳥ԡ饤Ȥꤹ
 */
void setCopyOnWrite(
	uint *m_pageEnt)
{
	*m_pageEnt |= PT_COPY_ON_WRITE;
	*m_pageEnt &= ~PAGE_RW;				// ߶ػߤˤ롣
}

/*
 * ȥ꡼饳ԡ饤Ȥ
 */
void resetCopyOnWrite(
	uint *m_entry)
{
	*m_entry &= ~PT_COPY_ON_WRITE;
	*m_entry |= PAGE_RW;			// ߲ġ
}

/*
 * ڡȥ꡼ʪ꡼ꤹ
 */
void setPhysMemEntry(
	uint *m_entry,		// ڡȥ꡼ɥ쥹
	void *const i_physMem)	// ʪ
{
	*m_entry = (*m_entry & (PAGE_SIZE - 1)) | (uint) i_physMem;
}

/*
 * KڡREAD/WRITEǥ쥯ȥꥨȥ꡼
 */
void setRwPageDirEntry(
	void *const i_pageTbl,		// ڡơ֥ʪɥ쥹
	uint *m_entry)
{
	*m_entry = ((uint) i_pageTbl & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_RW;
}

/*
 * KڡREAD/WRITEȥ꡼
 */
void setRwPageEntry(
	void *const i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = ((uint) i_physAddr & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_RW;
}

/*
 * Kڡ桼READ/WRITEǥ쥯ȥꥨȥ꡼
 */
void setUserRwPageDirEntry(
	void *const i_pageTbl,		// ڡơ֥ʪɥ쥹
	uint *m_entry)
{
	*m_entry = ((uint) i_pageTbl & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_RW | PAGE_USER;
}

/*
 * Kڡ桼READ/WRITEȥ꡼
 */
void setUserRwPageEntry(
	void *const i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = ((uint) i_physAddr & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_RW | PAGE_USER;
}

/*
 * Kڡ桼READ Onlyȥ꡼
 */
void setUserReadPageEntry(
	void *const i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = ((uint) i_physAddr & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_USER;
}

/*
 * Mڡȥ꡼
 */
void set4mPageEntry(
	const uint i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = (i_physAddr & ~(PAGE_DIR_SIZE - 1)) | PAGE_PRESEN | PAGE_RW | PAGE_4M;
}

/*
 * IOޥåѣMڡȥ꡼
 */
void setIomapPageEntry(
	const uint i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = (i_physAddr & ~(PAGE_DIR_SIZE - 1)) | PAGE_PRESEN | PAGE_RW | PAGE_4M | PAGE_CASH_DISABLE;
}

/*
 * IOޥåѣKڡ桼ȥ꡼
 */
void setUserIomapPageEntry(
	const uint i_physAddr,		// ڡʪɥ쥹
	uint *m_entry)
{
	*m_entry = (i_physAddr & ~(PAGE_SIZE - 1)) | PAGE_PRESEN | PAGE_RW | PAGE_USER | PAGE_CASH_DISABLE;
}

//--------------------------------------------------------------------------------------------------
// YES NO
//--------------------------------------------------------------------------------------------------
/*
 * ȥ꡼˥꡼ƤƤ뤫
 * parameters : YES or NO
 */
int isPagePresenEntry(
	const uint i_entry)
{
	return (i_entry & PAGE_PRESEN) ? YES : NO;
}

/*
 * ȥ꡼ԡ饤ȤꤵƤ뤫
 * return : YES or NO
 */
int isCopyOnWrite(
	const uint i_entry)
{
	return (i_entry & PT_COPY_ON_WRITE) ? YES : NO;
}

/*
 * ȥ꡼Mڡȥ꡼
 * return : YES or NO
 */
int is4mPageEntry(
	const uint i_entry)
{
	return (i_entry & PAGE_4M) ? YES : NO;
}
