/*
 * vm.h
 *
 * Copyright 2007 Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_vm_h
#define i386_vm_h


#include <sys/types.h>
#include <i386/tss.h>


#define PAGE_DIR_SIZE	0x400000	/* Page directory size */
#define PAGE_SIZE		0x1000		/* Page size */
#define	PAGE_MASK		(PAGE_SIZE - 1)

#ifdef KERNEL

/* Page entry flag */
#define PAGE_PRESEN			0x1		/* Is presence */
#define PAGE_RW				0x2		/* Is read and write,not read only */
#define PAGE_USER			0x4		/* Privilege is user,not supervisor */
#define PAGE_CASH_DISABLE	0x10	/* Disable cash,not able cash */
#define PAGE_4M				0x80	/* Page size is 4M,not 4K */

#endif	// KERNEL

#ifndef ASM_FILE

#ifdef KERNEL

enum{
	/* ڡȥ꡼ΰѥե饰 */
	PT_COPY_ON_WRITE = 0x200,		/* ԡ饤ȥե饰 */
};

extern void receivePageFault();
extern uint *getPageDirEntryAddr(const uint, uint *);
extern uint *getPageEntryAddrFromPageTbl(const uint, uint *);
extern void *getPhysMemFromEntry(const uint);
extern void setCopyOnWrite(uint *);
extern void setPhysMemEntry(uint*, void *const );
extern void setRwPageDirEntry(void *const, uint *);
extern void setRwPageEntry(void *const, uint *);
extern void setUserRwPageDirEntry(void *const, uint *);
extern void setUserRwPageEntry(void *const, uint *);
extern void setUserReadPageEntry(void *const, uint *);
extern void setUserIomapPageEntry(const uint, uint *);
extern void set4mPageEntry(const uint, uint *);
extern void setIomapPageEntry(const uint, uint *);
extern void resetCopyOnWrite(uint *);
extern void enablePaging(uint *);
extern void updatePageDir(uint *);
extern int isPagePresenEntry(const uint);
extern int isCopyOnWrite(const uint);
extern int is4mPageDir(const uint);

/*
 * ڡǥ쥯ȥ꤫鲾ۥɥ쥹Υڡȥ꡼ɥ쥹
 *ղۥɥ쥹Υڡǥ쥯ȥꥨȥ꡼ꤵƤ뤳
 * return : ڡȥ꡼ɥ쥹
 */
static inline uint *getPageEntryAddr(
	const uint i_addr,		// ۥɥ쥹
	uint *i_pageDir)		// ڡǥ쥯ȥꥢɥ쥹
{
	uint *pageTbl;

	pageTbl = getPhysMemFromEntry(*getPageDirEntryAddr(i_addr, i_pageDir));
	return getPageEntryAddrFromPageTbl(i_addr, pageTbl);
}

#endif	// KERNEL

#endif	// ASM_FILE


#endif
