/*
 * BufPool.c
 *
 * Copyright 2010, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Ū
 * mbufʤɤΥ꡼̤¤뤿
 *
 *Գס
 * ǽɬץƤơꥵڤФƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/limits.h>
#include <machine/lock.h>
#include <machine/interrupt.h>
#include <lib/AggregateList.h>
#include <kern/PhysMem.h>
#include <kern/BufPool.h>
#include <kern/debug.h>

//==================================  ===========================================

enum {
	POOL_MAX	= 0x100000,		// ס륵ޥå
};

typedef struct {
	uchar			*buf;			// Хåեס꡼ɥ쥹
	uint			poolSize;		// Хåեס륵
	uint			unitSize;		// ƥ
	uint			residSize;		// Ĥꥵ
	int				spinLock;		// ԥ󥲡
	AggregateList	aggregate;		// ꥹȽ
} BufPool;

typedef struct {
	List	list;			// ꥹ
} UnitList;

//================================== PRIVATE ============================================

//================================== PUBLIC =============================================

static AggregateListMethod	aggrMethod;

int BufPooInit()
{
#ifdef DEBUG
	if (sizeof(BufPool) != sizeof(BufPoolObj)) {
		printk("BufPooInit() object size error! BufPool=%d BufPoolObj=%d\n", sizeof(BufPool), sizeof(BufPoolObj));
		idle();
	}
#endif
	return NOERR;
}

int BufPoolConstruct(
	BufPoolObj *Obj,
	const uint poolSize,		// ס꡼
	const uint unitSize)		// ƥ꡼
{
	BufPool *this = (BufPool*) Obj;

	if (POOL_MAX < poolSize) {
		return -ENOMEM;
	}
	
	this->poolSize = ROUNDUP(poolSize, PAGE_SIZE);
	this->buf = allocMultiKernelPage(this->poolSize / PAGE_SIZE);
	if (this->buf == NULL) {
		return -ENOMEM;
	}
	this->residSize = this->poolSize;
	this->unitSize = unitSize;

	{
		uint offset;

		AggregateListConstructor(&this->aggregate, &aggrMethod);
		for (offset = 0; offset <= (this->poolSize - this->unitSize); offset += this->unitSize) {
			UnitList *unit = (UnitList*) (this->buf + offset);
			listConstructor(&unit->list, unit);
			aggrMethod.insertEnd(&this->aggregate, &unit->list);
		}
	}

	return NOERR;
}

void BufPoolDestruct(
	BufPoolObj *Obj)
{
	// ̤
}

/*
 * Хåե
 * return : Хåեɥ쥹 or NULL
 */
void *BufPoolalloc(
	BufPoolObj *Obj
#ifdef DEBUG
	,uint size
#endif
	)
{
	BufPool *this = (BufPool*) Obj;
	void *mem;

	ASSERT(size <= this->unitSize);

	int eflag = enterCli();
	enter_spinlock(&this->spinLock);
	{
		mem = aggrMethod.getHead(&this->aggregate);
		this->residSize -= this->unitSize;
	}
	exit_spinlock(&this->spinLock);
	exitCli(eflag);

	return mem;
}

/*
 * Хåե
 */
void BufPoolfree(
	BufPoolObj *Obj,
	void *addr)
{
	BufPool *this = (BufPool*) Obj;
	UnitList *unit = (UnitList*) addr;
	int eflag;
	
	ASSERT(((void*) this->buf <= addr) && (addr < (void*) (this->buf + this->poolSize)));
	ASSERT(((uint) addr - (uint) this->buf) % this->unitSize == 0);

	listConstructor(&unit->list, unit);
	eflag = enterCli();
	enter_spinlock(&this->spinLock);
	{
		aggrMethod.insertEnd(&this->aggregate, &unit->list);
		this->residSize += this->unitSize;
	}
	exit_spinlock(&this->spinLock);
	exitCli(eflag);
}

/*
 * ĤХåե뤫
 * return : YES or NO
 */
int BufPoolIsResid(
	BufPoolObj *Obj)
{
	BufPool *this = (BufPool*) Obj;
	return (this->unitSize <= this->residSize) ? YES : NO;
}
