/*
 * FsRegist.c
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <kern/FsRegist.h>

#include <kern/debug.h>

#define TEST_FSREGIST

//#define DEBUG_FSREGIST 1
#ifdef DEBUG_FSREGIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static FS fsInfoTop;			// ե륷ƥϿ󥯥ȥå

#ifdef TEST_FSREGIST
static void testFsRegist()
{
}
#endif

//===================================== PUBLIC =====================================================

/*
int FsRegistInit()
{
}
*/

/*
void FsRegistConstructor(
	FsRegist *this)
{
}
*/

/*
void FsRegistDestructor(
	FsRegist *this)
{
}
*/

/*
 * ե륷ƥϿ롣
 * return : error number
 */
int regist_fs(
	FS *info)
{
	FS *p;

	p = &fsInfoTop;
	for (; p->next != NULL; p = p->next) {
		switch (strcmp(info->name, p->next->name)) {
		case 0:
			return -EEXIST;
		case -1:
			goto EXIT;
		}
	}
EXIT:
	info->next = p->next;
	p->next = info;

	return 0;
}

/*
 * Ͽ줿ե륷ƥõ
 * return : FS or NULL
 */
FS *search_fs(
	const char *name)		// ե륷ƥ̾
{
	FS *p;

	for (p = fsInfoTop.next; p != NULL; p = p->next) {
		switch (strcmp(name, p->name)) {
		case 0:
			return p;
		case -1:
			return NULL;
		}
	}

	return NULL;
}
