/*
 * FsRegist.h
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef kern_FsRegist_h
#define kern_FsRegist_h

#ifndef ASM_FILE

/* ե륷ƥ।ե᡼¤ */
typedef struct FS{
	const char *name;
	// parameters : device descriptor, out root inode object
	// retern     : error number
	int (*mount)(void*, void**);
	// parameters : device descriptor, root inode object
	// retern     : error number
	int (*umount)(void*, void*);
	// ѥ˥ܥå󥯥ե뤬Фinode֤
	// parameters : path, device descriptor, directory inode object, out inode number, ܥå̾ݥ
	// retern     : error number or SYMLINK
	int (*lookup)(const char*, void*, void*, uint*, const char**);
	// parameters : path, device descriptor, directory inode object, file type + mode, out inode number
	// retern     : error number
	int (*creat)(const char*, void*, void*, const int, uint*);
	// parameters : device descriptor, inode number, open flag, out inode object, out file type
	// retern     : error number
	int (*open)(void*, const uint, int, void **, int *);
	// parameters : device descriptor, inode object
	// retern     : error number
	int (*close)(void*, void*);
	// parameters : device descriptor, inode object, resd buffer, read bytes, begin byte
	// retern     : read bytes or error number
	int (*read)(void*, void*, void*, size_t, size_t);
	// parameters : device descriptor, inode object, write buffer, write bytes, begin byte
	// retern     : write bytes or error number
	int (*write)(void*, void*, void*, size_t, size_t);
	// parameters : device descriptor, inode object, command, parameter, parameter2, 
	// retern     : error number
	int (*ioctl)(void*, void*, int, caddr_t, int);
	// parameters : inode object, events
	// retern     : poll condition
	int (*poll)(void*, int);
	// parameters : device descriptor, directory inode object, out block, out index 
	// retern     : error number
	int (*opendir)(void*, void*, uint*, int*);
	// parameters : device descriptor, inode object, modify block, modify index, out name 
	// retern     : error number
	int (*readdir)(void*, void*, uint*, int*,char*);
	// parameters : device descriptor, old dir inode object, old path, new dir inode object, new path
	// retern     : error number
	int (*rename)(void*, void*, const char*, void*, const char*);
	// parameters : path, device descriptor, directory inode object, file type + mode, dev number
	// retern     : error number
	int (*mknod)(const char*, void*, void*, const int, const uint);
	// parameters : device descriptor, inode object, modify struct stat
	// retern     : error number
	int (*mkdir)(const char*,void*, void*, int);
	// parameters : device descriptor, inode object, modify struct stat
	// retern     : error number
	int (*stat)(void*, void*, struct stat*);
	// ѥΥǥ쥯ȥꥨȥ꡼inode롣
	//աեѥϿƥǥ쥯ȥ꤬ɬ
	// parameters : path, device descriptor, directory inode object, file type
	// retern     : error number
	int (*delete)(const char*, void*, void*, int);
	// parameters : device descriptor, inode object, mode, uid, gid, access time, modified time
	// retern     : error number
	int (*chattr)(void*, void*, uint, uint, uint, uint, uint);
	// parameters : device descriptor, destination inode object, source inode object, source path
	// retern     : error number
	int (*link)(void*, void*, void*, const char*);
	// parameters : path, device descriptor, directory inode object, link path
	// retern     : error number
	int (*symlink)(const char*, void*, void*, char*);
	// parameters : device descriptor, modify struct statfs
	// retern     : NOERR
	int (*statfs)(void*, struct statfs*);
	struct FS *next;
} FS;

extern int regist_fs(FS*);
extern FS *search_fs(const char *name);

#endif // ASM_FILE

#endif // kern_FsRegist_h
