/*
 * Hierarchy.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեץ
 *
 *¾ϸƤӽФ¦ǹԤ
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <kern/ProcSignal.h>
#include <kern/Hierarchy.h>

#include <kern/debug.h>


//#define DEBUG_PROC_LIST 1
#ifdef DEBUG_PROC_LIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 * ץع¤
 *ԱƶեСѹHierarchyObjΥѹ뤳
 */
typedef struct {
	List				list;
	AggregateList		aggrChild;		// ҥץꥹȽ
	AggregateListMethod	aggrMethod;		// ꥹȥ᥽å
	void 				*proc;			// ץ
	void 				*parent;		// ƥץ
} Hierarchy;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

int HierarInit()
{
#ifdef DEBUG
	if (sizeof(Hierarchy) != sizeof(HierarchyObj)) {
		printk("HierarInit() object size error! Hierarchy=%d HierarchyObj=%d\n", sizeof(Hierarchy), sizeof(HierarchyObj));
		idle();
	}
#endif

	return NOERR;
}

void HierarConstructor(
	HierarchyObj *i_this,
	void *i_proc)
{
	Hierarchy *this = (Hierarchy*) i_this;

	listConstructor(&this->list, this);
	AggregateListConstructor(&this->aggrChild, &this->aggrMethod);
	this->proc = i_proc;
	this->parent = NULL;
}

void HierarDestructor(
	HierarchyObj *i_this)
{
	// ⤷ʤ
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

/*
 * ץ
 * return : ץ
 */
void *HierarGetProc(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;
	return this->proc;
}

/*
 * ץ
 * return : ץ
 */
void *HierarGetParent(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;
	return this->parent;
}

/*
 * ҥץ
 * return : ҥץ
 */
int HierarGetChildCount(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;
	return this->aggrMethod.getCount(&this->aggrChild);
}

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

/*
 * ǽλҥץ
 *HierarLock()ƤӽФƤ뤳
 * return : ҥץع¤ or NULL
 */
HierarchyObj *HierarGetFirstChild(
	HierarchyObj *i_this)
{
	Hierarchy *this = (Hierarchy*) i_this;

	return this->aggrMethod.refHead(&this->aggrChild);
}

/*
 * λҥץ
 *HierarLock()ƤӽФƤ뤳
 * return : ҥץع¤ or NULL
 */
HierarchyObj *HierarGetNextChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)		// ҥץع¤
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;

	return this->aggrMethod.refNext(&this->aggrChild, &child->list);
}

//--------------------------------------------------------------------------------------------------
// ꥹȥ᥽å
//--------------------------------------------------------------------------------------------------

/*
 * ҥץɲä
 */
void HierarAddChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;

	this->aggrMethod.insertHead(&this->aggrChild, &child->list);
	child->parent = this->proc;
}

/*
 * ҥץ
 *HierarLock()ƤӽФƤ뤳
 *Իպҥץ󥯤ν֤Ѥʤ
 */
void HierarRemoveChild(
	HierarchyObj *i_this,
	HierarchyObj *i_child)
{
	Hierarchy *this = (Hierarchy*) i_this;
	Hierarchy *child = (Hierarchy*) i_child;

	this->aggrMethod.removeEntry(&this->aggrChild, &child->list);
	child->parent = NULL;
}
