/*
 * PhysMem.h
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef kern_PhysMem_h
#define kern_PhysMem_h

#ifndef ASM_FILE

typedef struct {
	int dummy;
} PhysMemObj;

extern void PhysMemInit();
extern uint getPhysMemSize();
extern void *allocKernelPage();
extern void *allocUserPage();
extern void *allocMultiKernelPage(const int);
extern void linkPhysTable(const void*);
extern void unlinkPhysTable(const void*);
extern void setAllocNum(const void*, const int);
extern void enterPhysMemLock(const void*);
extern void exitPhysMemLock(const void*);
extern int getPhysPageLinkCount(const void*);
extern int getAllocNum(const void*);
extern int sys_sync();

#endif	// ASM_FILE

#endif	// kern_PhysMem_h
