/*
 * TaskSignal.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեʥ
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/limits.h>
#include <sys/signal.h>
#include <lib/bitmap.h>
#include <machine/Entry.h>
#include <kern/proc.h>
#include <kern/ProcSignal.h>
#include <sys/Thread.h>
#include <kern/TaskSignal.h>

#include <kern/debug.h>


//#define DEBUG_TASK_SIGNAL 1
#ifdef DEBUG_TASK_SIGNAL
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 *ԱƶեСѹTaskSignalObjΥѹ뤳
 */
typedef struct {
	sigset_t	signal;				// signal bitmap.
	sigset_t	mask;				// signal mask bitmap.
	sigset_t	pending;			// pending signal bitmap.
	int 		stopDoSignal;		// ϥɥ顼¹ǥե饰 YES or NO
	ThreadObj	*task;				// 
} TaskSignal;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * ʥ륻åȤ饷ʥֹ
 * return : number of signal or 0
 */
STATIC INLINE int getSigNumber(
	sigset_t *i_signal)
{
	return getBitmapPos(0, sizeof(*i_signal) * CHAR_BIT, (u_int8_t*) i_signal) + 1;
}

/*
 * ʥϥɥμ¹
 * return : task switch YES or NO
 */
STATIC int doSigHandler(
	TaskSignal *this,
	ProcSignalObj *procSignalObj,
	const int i_sigNum)
{
	SIG_HANDLER handler = ProcSignalGetHandler(procSignalObj, i_sigNum);

	if (handler == (SIG_HANDLER) SIG_IGN) {
		// ⤻
		return NO;
	}
	else if (handler == (SIG_HANDLER) SIG_DFL) {
		// ⤻
		return NO;
	}
	else {
		int ret = NO;

		// ʥޥ촹
		sigset_t beforeMask = this->mask;
		this->mask = *ProcSignalGetHandlerMask(procSignalObj, i_sigNum);

		if ((uint) handler < KERNEL_DATA_END) {
			// ͥϥɥ¹
			ret = handler(i_sigNum);
		}
		else if (USER_BEG <= (uint) handler) {
			// 桼ϥɥ¹
			callUserHandler(handler, ProcSignalGetReturnMethod(procSignalObj), i_sigNum);
		}
		else {
			ASSERT(0);
		}

		// ʥޥ᤹
		this->mask = beforeMask;
		
		return ret;
	}
}

//===================================== PUBLIC =====================================================

/*
 * 󥹥ȥ饯
 */
void TaskSignalConstructor(
	TaskSignalObj *i_this,
	void *i_task)
{
	TaskSignal *this = (TaskSignal*) i_this;
	clearSignal(&this->signal);
	clearSignal(&this->mask);
	clearSignal(&this->pending);
	this->stopDoSignal = NO;
	this->task = i_task;
}

/*
 * ǥȥ饯
 */
void TaskSignalDestructor(
	TaskSignalObj *i_this)
{
	// ⤷ʤ
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

sigset_t *TaskSignalGetMask(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	return &this->mask;
}

sigset_t *TaskSignalGetPending(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	return &this->pending;
}

//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

/*
 * ʥ򤹤٤ƥޥ롣
 */
void setSigAllMask(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	setFillMask(&this->mask);
}

/*
 * ʥϥɥ¹ԤǤ
 */
void TaskSignalStopHandler(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	this->stopDoSignal = YES;
}

/*
 * ʥϥɥ¹ԤƳ
 */
void TaskSignalRestartHandler(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	this->stopDoSignal = NO;
}

void TaskSignalSetMask(
	TaskSignalObj *i_this,
	const sigset_t *i_mask)
{
	TaskSignal *this = (TaskSignal*) i_this;
	this->mask = *i_mask;
}

void TaskSignalSetPending(
	TaskSignalObj *i_this,
	const sigset_t *i_pending)
{
	TaskSignal *this = (TaskSignal*) i_this;
	this->pending = *i_pending;
}

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

/*
 * ʥ뤬줿
 * return : YES or NO
 */
int isSigint(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	return isSetSignal(&this->signal);
}

/*
 * λʥ뤬줿
 * return : YES or NO
 */
int isEndSigint(
	TaskSignalObj *i_this)
{
	TaskSignal *this = (TaskSignal*) i_this;
	return isEndSignal(&this->signal);
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

/*
 * ʥϥɥ¹
 *ճߥͥȥȸ˸ƤӽФ
 * return : task switch YES or NO
 */
int doSignal()
{
	TaskSignal *this = (TaskSignal*) TaskGetTaskSignal(getCurrentTask());
	int isTaskSwitch;

	// ͥǥͥȤƤ뤫
	if (isNest() == YES) {
		return NO;
	}

	// ϥɥ¹椫
	if (this->stopDoSignal == YES) {
		return NO;
	}

	isTaskSwitch = NO;
	this->stopDoSignal = YES;
	while (isSetSignal(&this->signal) == YES) {
		ProcSignalObj *procSignalObj;

		// ʥֹμ
		int sigNum = getSigNumber(&this->signal);
		WARNING(sigNum != 0);

		// ʥϥɥμ¹
		procSignalObj = procGetProcSignal(ThreadGetProc(getCurrentTask()));
		isTaskSwitch = doSigHandler(this, procSignalObj, sigNum);

		// ʥ륯ꥢ
		delSignal(&this->signal, sigNum);
		
		if (isTaskSwitch == YES) {
			break;
		}
	}
	this->stopDoSignal = NO;

	return isTaskSwitch;
}

/*
 * ˥ʥ
 * ϵʤ
 */
void sendSignalOnly(
	TaskSignalObj *i_this,
	const int i_sigNum)
{
	TaskSignal *this = (TaskSignal*) i_this;

	if (isMaskSignal(&this->mask, i_sigNum) == YES) {
		// ޥ줿ʥα
		setSignal(&this->pending, i_sigNum);
	}
	else {
		// ʥ򥻥å
		setSignal(&this->signal, i_sigNum);
	}
}

/*
 * ˥ʥ
 * ǥեȥΡcontinue processפϡʥץư롣
 *Գ
 */
void sendSignal(
	TaskSignalObj *i_this,
	const int i_sigNum)
{
	TaskSignal *this = (TaskSignal*) i_this;

	if (isMaskSignal(&this->mask, i_sigNum) == YES) {
		// ޥ줿ʥα
		setSignal(&this->pending, i_sigNum);
	}
	else {
		// ʥ򥻥å
		setSignal(&this->signal, i_sigNum);
		TaskAwake(getTaskWait(this->task));
	}
}

/*
 * ʥ
 *Գ
 */
void forceSendSignal(
	TaskSignalObj *i_this,
	const int i_sigNum)
{
	TaskSignal *this = (TaskSignal*) i_this;

	// ʥ򥻥å
	setSignal(&this->signal, i_sigNum);
	TaskAwake(getTaskWait(this->task));
}
