/*
 * TaskWait.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef kern_TaskWait_h
#define kern_TaskWait_h

#ifndef ASM_FILE

/*
 * ȥ֥
 *԰¸TaskWaitAttrΥƱ
 */
typedef struct {
	char dummy[32];
} TaskWaitObj;

/*
 * ޥեȥ֥
 *԰¸WaitΥƱ
 */
typedef struct {
	char dummy[28];
} WaitAggrObj;

/*
 * ̥ȥ֥
 *԰¸TaskWaitAttrΥƱ
 */
typedef struct {
	char dummy[20];
} WaitIdentObj;

extern void WaitIdentConstruct(WaitIdentObj*);
extern void WaitIdentDestructor(WaitIdentObj*);
extern void TaskWait();
extern int TaskWaitTimer(const int);
extern int TaskAwake(TaskWaitObj*);
extern int TaskAwakeSoon(TaskWaitObj*);
extern void TaskWaitAtomic();
extern int TaskAwakeAtomicSoon(TaskWaitObj*);
extern void TaskWaitDaemon();
extern int TaskWaitDaemonActiveSoon(TaskWaitObj*);
extern void TaskWaitReset(TaskWaitObj*);
extern int exitSchedule();
extern int stopSchedule();
extern void WaitAggrConstructor(WaitAggrObj*);
extern void WaitSleep(WaitAggrObj*);
extern void WaitWake(WaitAggrObj*);
extern void WaitGetSemaphore(WaitAggrObj*);
extern void WaitReleaseSemaphore(WaitAggrObj*);
extern void WaitReference(WaitAggrObj*);
extern void WaitEndReference(WaitAggrObj*);

#endif // ASM_FILE

#endif // kern_Wait_h
