/*
 * TestDisplayTask.c
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסեΥ塼뤫ɲáξɽ롣
 *
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <sys/Thread.h>

#include <kern/debug.h>

#ifdef DEBUG

//=====================================  ===================================================

enum {
	TASK_STATE_MAX = 15,		// ɽ
	DISPLAY_START_LINE = 5,		// ǥץ쥤ȥ饤ֹ
	ERR_CHAR_NUM = 15,			// 顼ɽʸ
	
	// 顼ֹ
	ERR_OVER = 1,		// taskState[]˶ʤ
};

typedef struct {
	ThreadObj	*thread;
	int			state;
} TaskState;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static TaskState taskState[TASK_STATE_MAX];

/*
 * ɽɲá¹ԡΥϽ
 * NOERR or ERR_OVER
 */
static int add(
	ThreadObj *this,
	const int state)
{
	int i;
	
	for (i = 0; i < TASK_STATE_MAX; ++i) {
		if (taskState[i].thread == NULL) {
			taskState[i].thread = this;
			taskState[i].state = state;
			return NOERR;
		}
	}
	return ERR_OVER;
}

/*
 * 
 */
static void del(
	ThreadObj *this)
{
	int i;
	
	// ǤNULL
	for (i = 0; i < TASK_STATE_MAX; ++i) {
		if (taskState[i].thread == this) {
			taskState[i].thread = NULL;
			break;
		}
	}
}

/*
 * ֤ɽ
 */
static void display()
{
	int line;
	int i;

	// 1饤ꥯꥢ
	for (i = 1; i < DISPLAY_START_LINE + TASK_STATE_MAX; ++i) {
		displayTop(80 * i + 70, "          ", 10);
	}

	line = 0;
	for (i = 0; i < TASK_STATE_MAX; ++i) {
		if (taskState[i].thread != NULL) {
			printDebug(80 * (DISPLAY_START_LINE + line) + 70, "%x %d", taskState[i].thread, taskState[i].state);
			++line;
		}
	}
}

/*
 * 顼åERR_CHAR_NUMʬɽ
 */
static void errorDisplay(
	const char *str)
{
	char error[ERR_CHAR_NUM + 1];
	
	memset(error, ' ', ERR_CHAR_NUM);
	error[ERR_CHAR_NUM] = '\0';
	strncpy(error, str, ERR_CHAR_NUM);
	printDebug(80 * (DISPLAY_START_LINE + TASK_STATE_MAX) + 80 - ERR_CHAR_NUM, "%s", error);
}

//===================================== PUBLIC =====================================================

void displayTask(
	ThreadObj *this,
	const int state)
{
	switch (state) {
	case TASK_RUNNING:
		// Fall through.
	case TASK_EXIT:
		del(this);
		break;
	case TASK_WAIT:
		// Fall through.
	case TASK_INTR_WAIT:
		// Fall through.
	case TASK_SIGNAL_STOP:
		// Fall through.
	case TASK_TRACE:
		// Fall through.
	case TASK_CHILD_WAIT:
		if (add(this, state) == ERR_OVER) {
			errorDisplay("Task over!");
		}
		break;
	default:
		errorDisplay("Uknown state!");
	}
	
	display();
}
#endif
