/*
 * Thread.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեåɴ
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/AggregateList.h>
#include <sys/sched.h>
#include <sys/pthread.h>
#include <machine/Cpu.h>
#include <machine/fpu.h>
#include <machine/mp.h>
#include <machine/clock.h>
#include <machine/lock.h>
#include <machine/interrupt.h>
#include <kern/kmalloc.h>
#include <kern/itimer.h>
#include <kern/TaskWait.h>
#include <sys/Thread.h>

#include <kern/debug.h>


//#define DEBUG_THREAD 1
#ifdef DEBUG_THREAD
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

/*
 * åɥ塼¤
 */
typedef struct {
	int cpu;						// CPUֹ 0
	void *currentTask;				// ߼¹ΥåID
	uint taskCount;					// ưåɿ
	AggregateList aggregate;		// åɥ塼ꥹȽ
	AggregateListMethod aggrMethod;	// ꥹȥ᥽å
	int lock;						// 塼¾å
} SCHEDULE;

/*
 * 桼åɹ¤
 */
typedef struct Thread {
//================ Ϣ ===========================
	List			list;				// 塼ѥꥹ
	TaskWaitObj		taskWaitObj;		// ȥ֥
	VmTaskObj		vmTaskObj;			// ۥ꡼֥
	int				nestCount;			// ͥͥȥ
	int				cpu;				// running cpu number
	int				state;				// 
	int 			fpu;				// FPU֥ե饰᥻֤

	struct Thread	*callTask;			// ƤӽФ西
	struct Thread	*callDstTask;		// ƤӽФ
	int				irq;				// ɥ饤С⥸塼ѳֹ

	TaskSignalObj	taskSignalObj;		// ʥ¤
	EntryObj		entryObj;			// ȥ꡼¤

//================ åɴϢ ===========================
	pthread_t		id;					// ID
	List			procList;			// ץ˥
	void			*proc;				// °ץ

	// åɽλԤ
	void 			*valuePtr;			// λ꥿
	pthread_t		joinId;				// λԤåIDͣ

	// ¹Իַ¬
	uint64		 	sysClocks;			// ץƥвCPUå
	uint64		 	userClocks;			// ץ桼вCPUå
	uint64			beforeClocks;		// ץַ¬ѵCPUå

	// ޡ
	TIMER_OWNER		timer;				// ݻޡ
} Thread;

//===================================== Х륤ݡ =======================================

extern int registThread(void*, List*);
extern int procGetThread(const pthread_t, ThreadObj**);
extern int procGetWaitThread(const pthread_t, ThreadObj**);
extern void taskWaitConstruct(TaskWaitObj*, ThreadObj*);
#ifdef DEBUG
extern void displayTask(ThreadObj*, const int);
#endif

//===================================== PRIVATE ====================================================

//--------------------------------------------------------------------------------------------------
// 塼
//ե塼뤫κɬåɤΤ߹Ԥ
//--------------------------------------------------------------------------------------------------

/*
 * 塼¤
 */
static SCHEDULE schedule[MAX_CPU];

/*
 * ɥ륿¹ԥʤ˵ư
 */
static Thread *idleTask[MAX_CPU];

/*
 * ֥ξʤCPU
 * retuuns : CPUֹ
 */
STATIC int getAddTaskCpu()
{
	int cpu;
	uint num;
	int cpuNum;
	int i;

	cpu = 0;
	num = schedule[cpu].taskCount;
	cpuNum = getCpuNum();
	for (i = 1; i < cpuNum; ++i) {
		if (schedule[i].taskCount < num) {
			num = schedule[i].taskCount;
			cpu = i;
		}
	}

	return cpu;
}

/*
 * 򥹥塼³
 *ճ߶ػߤ¾åƸƤӽФ
 * return : YES = ³NO = ³Ƥʤ
 */
STATIC int addSchedule(
	Thread *m_task,
	const int cpu,
	const int state)
{
	/*
	 * ߤΥȥե饰ȰפƤɲä
	 */
	if (m_task->state & state) {
		AggregateList *aggregate = &schedule[cpu].aggregate;
		AggregateListMethod *aggrMethod = &schedule[cpu].aggrMethod;
		Thread *current = aggrMethod->refHead(aggregate);

		m_task->state = TASK_RUNNING;
		aggrMethod->insertNext(aggregate, &current->list, &m_task->list);

		// ɥ륹åɤϥȥåפ
		if(current == idleTask[cpu]) {
			sendSignalOnly(&current->taskSignalObj, SIGSTOP);
		}

		return YES;
	}
	else {
		return NO;
	}
}

/*
 * 򥹥塼뤫ڤΥ
 *ճ߶ػߤƸƤӽФ
 */
STATIC void delSchedule(
	const int state)
{
	int cpu = getCpu();

	AggregateList *aggregate = &schedule[cpu].aggregate;
	AggregateListMethod *aggrMethod = &schedule[cpu].aggrMethod;
	Thread *current = aggrMethod->refHead(aggregate);

	/*
	 * ¹ԥʤʤϥɥ륿³
	 */
	aggrMethod->removeEntry(aggregate, &current->list);
	current->state = state;
	if (aggrMethod->refHead(aggregate) == NULL) {
		aggrMethod->insertHead(aggregate, &idleTask[cpu]->list);
		idleTask[cpu]->state = TASK_RUNNING;
	}
}

STATIC INLINE Thread *currentTask()
{
	return (Thread*) schedule[getCpu()].currentTask;
}

//--------------------------------------------------------------------------------------------------
// å
//--------------------------------------------------------------------------------------------------

/*
 * 󥹥ȥ饯
 */
STATIC void threadConstructor(
	Thread *this,
	void *i_proc)			// °ץ
{
	static pthread_t id = 1;	// Thread ID鳫

	memset(this, 0, sizeof(*this));
	this->id = id++;
	listConstructor(&this->list, this);
	listConstructor(&this->procList, this);
	taskWaitConstruct(&this->taskWaitObj, (ThreadObj*) this);
	this->proc = i_proc;

	initProcessTimer(&this->timer);
	EntryConstructor(&this->entryObj);
}

/*
 * ǥȥ饯
 */
STATIC void threadDestructor(
	Thread *this)
{
	releaseProcessTimer(&this->timer);
	EntryDestructor(&this->entryObj);

	kfree(this);
}

/*
 * λԤåɤ򵯤
 */
STATIC void wakeExitWaitThread(
	Thread *this,
	void *i_valuePtr)			// λ
{
	Thread *waitThread;

	// λԤåɤ򵯤ˡåɽλͤϿ
	this->valuePtr = i_valuePtr;

	// λԤåɤ򵯤
	if (procGetWaitThread(this->id, (ThreadObj**) &waitThread) == NOERR) {
		TaskAwake(getTaskWait((ThreadObj*) waitThread));
	}
}
/*
 * λԤ
 * return : error number
 */
STATIC int waitJoinThread(
	Thread *this,
	const pthread_t i_joinId,		// λԤåID
	void **o_valuePtr)
{
	static int spinLock = 0;
	Thread *joinThread;
	Thread *dummy;
	int error;

	// JOINåɤ
	error = procGetThread(i_joinId, (ThreadObj**) &joinThread);
	if (error != NOERR) {
		return error;
	}

	// Ǥ¾ΥåɤλԤƤ뤫
	enter_spinlock(&spinLock);
	{
		error = procGetWaitThread(i_joinId, (ThreadObj**) &dummy);
		if (error == -ESRCH) {
			this->joinId = i_joinId;
		}
		else {
			exit_spinlock(&spinLock);
			return -EINVAL;
		}
	}
	exit_spinlock(&spinLock);

	// åɽλԤ
	while (joinThread->valuePtr == NULL) {
		TaskWait();
		
		// λʥʤ齪λ
		if (isEndSigint(TaskGetTaskSignal(getCurrentTask())) == YES) {
			break;
		}
	}

	*o_valuePtr = joinThread->valuePtr;

	return NOERR;
}

//===================================== PUBLIC =====================================================

//--------------------------------------------------------------------------------------------------
// 塼
//--------------------------------------------------------------------------------------------------

/*
 * 塼ν
 *CPU˥ꥢꤹɬפ
 * returns : NOERR
 */
void initSchedule(
	int cpu)
{
	schedule[cpu].cpu = cpu;
	AggregateCircleConstructor(&schedule[cpu].aggregate, &schedule[cpu].aggrMethod);
}

/*
 * ¹ԥ塼³롣
 *¾ץƤФ롣
 *Գ
 * return : YES = NO = Ǥ˼¹椫Ǥʤä
 */
int addToSchedule(
	ThreadObj *i_task,
	const int i_state)		// Task condition
{
	Thread *task = (Thread*) i_task;
	int cpu = task->cpu;
	int isWake;
	int eflags;

	eflags = enterCli();
	enter_spinlock(&schedule[cpu].lock);
	{
		isWake = addSchedule(task, cpu, i_state);
	}
	exit_spinlock(&schedule[cpu].lock);
	exitCli(eflags);
	
	return isWake;
}

/*
 * 򤹤¹Ԥ
 *¾ץƤФ롣夹˥å롣
 *Գ
 * return : YES = NO = Ǥ˼¹椫Ǥʤä
 */
int addScheduleSoon(
	ThreadObj *i_task,
	const int i_state)		// Task condition
{
	Thread *task = (Thread*) i_task;
	int cpu = task->cpu;
	int isWake;
	int eflags;

	eflags = enterCli();
	enter_spinlock(&schedule[cpu].lock);
	{
		isWake = addSchedule(task, cpu, i_state);
		if (isWake == YES) {
			if (cpu != getCpu()) {
				interruptCpu(cpu);
			}
		}
	}
	exit_spinlock(&schedule[cpu].lock);
	exitCli(eflags);
	
	return isWake;
}

/*
 * ¹ԥ塼뤫ڤΥ
 *ռץƤ֡
 *ԻڤΥ奿åޤǳߤʤ褦˳߶ػߤˤ롣
 */
void delFromSchedule(
	const int i_state)
{
	int cpu = getCpu();
	int eflag;

	eflag = enterCli();
	enter_spinlock(&schedule[cpu].lock);
	{
		delSchedule(i_state);
	}
	exit_spinlock(&schedule[cpu].lock);
	exitCli(eflag);
	
	if (i_state == TASK_EXIT) {
		--schedule[cpu].taskCount;
	}
}

/*
 * CPUȺǽΥ򥹥塼Ͽ
 */
void setFirstTask(
	const int i_cpu,
	ThreadObj *m_task)
{
	Thread *task = (Thread*) m_task;

	schedule[i_cpu].aggrMethod.insertHead(&schedule[i_cpu].aggregate, &task->list);
	schedule[i_cpu].currentTask = task;
	task->cpu = i_cpu;
	task->state = TASK_RUNNING;
}

/*
 * 󥿥¹ԥ塼³ȥ˥å
 *ճ߶ػߤǸƤФ
 */
void addScheduleDaemon(
	ThreadObj *i_task)
{
	Thread *task = (Thread*) i_task;
	int cpu = getCpu();

	task->cpu = cpu;
	enter_spinlock(&schedule[cpu].lock);
	{
		addSchedule(task, cpu, TASK_INTR_WAIT);
	}
	exit_spinlock(&schedule[cpu].lock);
}

/*
 * 塼륿Ѥ
 *ռƤӽФ
 *߶ػߤǸƤӽФ
 */
void changeTask(
	ThreadObj *m_task)		// ѹ
{
	Thread *task = (Thread*) m_task;
	int cpu = getCpu();
	AggregateList *aggregate = &schedule[cpu].aggregate;
	AggregateListMethod *aggrMethod = &schedule[cpu].aggrMethod;

	enter_spinlock(&schedule[cpu].lock);
	{
		Thread *current = aggrMethod->refHead(aggregate);

		aggrMethod->removeEntry(aggregate, &current->list);
		current->state = TASK_WAIT;
		aggrMethod->insertHead(aggregate, &task->list);
		task->cpu = cpu;
		task->state = TASK_RUNNING;
	}
	exit_spinlock(&schedule[cpu].lock);
}

/*
 * å
 *ճ߶ػߤǸƤФ뤳
 * return : ΥΥڡǥ쥯ȥ
 */
void *switchTask()
{
	int cpu = getCpu();
	AggregateList *aggregate = &schedule[cpu].aggregate;
	AggregateListMethod *aggrMethod = &schedule[cpu].aggrMethod;
	Thread *next;

	// Υ˥å
	aggrMethod->pointHeadNext(aggregate);
	next = aggrMethod->refHead(aggregate);
	schedule[cpu].currentTask = next;

	return getPageDir(&next->vmTaskObj);
}

/*
 * ¹Բǽˤ
 */
void addNewTask(
	ThreadObj *this)		// 
{
	Thread *newTask = (Thread*) this;

	newTask->cpu = getAddTaskCpu();
	newTask->state = TASK_WAIT;
	addToSchedule((ThreadObj*) newTask, TASK_WAIT);
	++schedule[newTask->cpu].taskCount;
}

/*
 * ߼¹Υμ
 * return : current task
 */
ThreadObj *getCurrentTask()
{
	return (ThreadObj*) currentTask();
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

/*
 * ץ󥯥ꥹȤ
 */
int getTaskState(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->state;
}

/*
 * ۥ꡼¤Τ
 */
VmTaskObj *getVmTask(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->vmTaskObj;
}

/*
 * ȥ꡼¤Τ
 */
EntryObj *getEntry(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->entryObj;
}

/*
 * ȥ֥Ȥ
 */
TaskWaitObj *getTaskWait(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->taskWaitObj;
}

/*
 * ɥ饤С⥸塼ֹ
 *ռƤӽФ
 */
int getIrqTask(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->irq;
}

/*
 * ƤӽФ西
 *եȥץо
 */
ThreadObj *getCallTask(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return (ThreadObj*) this->callTask;
}

/*
 * ƤӽФ
 *ոƤӽФǸƤӽФ˸ƤӽФꤵƤ뤳
 */
ThreadObj *getCallDstTask(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return (ThreadObj*) this->callDstTask;
}

/*
 * ɥ饤С⥸塼ֹ
 *ռƤӽФ
 */
void setIrqTask(
	ThreadObj *i_this,
	const int i_irq)
{
	Thread *this = (Thread*) i_this;
	this->irq = i_irq;
}

/*
 * ƤӽФ西
 */
void setCallTask(
	ThreadObj *i_this)		// ƤӽФ西
{
	Thread *this = (Thread*) i_this;
	currentTask()->callTask = this;
	this->callDstTask = currentTask();
}

/*
 * ͥͥȥȤ䤹
 */
void incrementNest()
{
	currentTask()->nestCount += 1;
}

/*
 * ͥͥȥȤ򸺤餹
 */
void decrementNest()
{
	currentTask()->nestCount -= 1;

	ASSERT(0 <= currentTask()->nestCount);
}

/*
 * ͥǥͥȤƤ뤫
 * return : YES or NO
 */
int isNest()
{
	return (1 < currentTask()->nestCount) ? YES : NO;
}

/*
 * ƤӽФ᥽åɤΥѤ
 *ճ߶ػߤǸƤӽФ
 * return : Page directory
 */
void *changeCallTask()
{
	changeTask((ThreadObj*) currentTask()->callTask);
	return getPageDir(&currentTask()->callTask->vmTaskObj);
}

/*
 * ƤӽФ᤹
 *ճ߶ػߤǸƤӽФ
 * return : Page directory
 */
void *restoreCallTask()
{
	changeTask((ThreadObj*) currentTask()->callDstTask);
	return getPageDir(&currentTask()->callDstTask->vmTaskObj);
}

/*
 * ޡ
 */
TIMER_OWNER *getTaskTimer(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->timer;
}

/*
 * ʥ륪֥Ȥ
 * return : TaskSignalObj
 */
TaskSignalObj *TaskGetTaskSignal(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->taskSignalObj;
}

/*
 *ճߥͥȥȲûޤϸ˸ƤӽФ
 * ץַ¬getCpuClock͡ˤꤹ
 */
void setTaskCurrentTime()
{
	if (currentTask()->nestCount == 1) {
		currentTask()->beforeClocks = getCpuClock();
	}
}

/*
 *ճߥͥȥȲû˸ƤӽФ
 * ץ桼֤¬
 */
void calcTaskUserTime()
{
	Thread *current = currentTask();

	if (current->nestCount == 1) {
		int64 userClocks = getCpuClock() - current->beforeClocks;

		current->userClocks += userClocks;
		doItimer(userClocks, SIGVTALRM, current->proc, getItimerVirtual());
	}
}

/*
 *ճߥͥȥȸ˸ƤӽФ
 * ץƥ֤¬
 */
void calcTaskSysTime()
{
	Thread *current = currentTask();

	if (current->nestCount == 1) {
		int64 sysClocks = getCpuClock() - current->beforeClocks;
		
		current->sysClocks += sysClocks;

		doItimer(sysClocks, SIGPROF, current->proc, getItimerProc());
		doItimer(sysClocks, SIGVTALRM, current->proc, getItimerVirtual());
	}
}

/*
 * λ
 */
void taskExit()
{
	// FPU֥ɥ쥹򥯥ꥢ
	clearFpuSaveAddr();

	exitSchedule();
	wait_task();
	// äƤʤ
}

//--------------------------------------------------------------------------------------------------
// å
//--------------------------------------------------------------------------------------------------

/*
 * åID
 */
pthread_t threadGetId(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->id;
}

/*
 * λԤåID
 * return : åID
 */
pthread_t threadGetJoinId(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->joinId;
}

/*
 * ץ󥯥ꥹȤ
 */
List *getProcList(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return &this->procList;
}

/*
 * ץμ
 */
void *ThreadGetProc(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->proc;
}

/*
 * 桼֤
 * return : CPUå
 */
uint64 getUserClocks(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->userClocks;
}

/*
 * ƥ֤
 * return : CPUå
 */
uint64 getSysClocks(
	ThreadObj *i_this)
{
	Thread *this = (Thread*) i_this;
	return this->sysClocks;
}

/*
 * ǽΥåɤ
 * return : error number
 */
int createIdleThread(
	const int i_cpu,
	void *i_proc,			// °ץ
	ThreadObj **o_thread)
{
	Thread *newThread;
	int error;

	newThread = kmalloc(sizeof(*newThread));
	if (newThread == NULL) {
		return -ENOMEM;
	}
	threadConstructor(newThread, i_proc);
	
	// ۥ꡼γ
	error = createVm(&newThread->vmTaskObj, getVmProc(i_proc));
	if (error != NOERR) {
		threadDestructor(newThread);
		return error;
	}

	/*
	 * FPU֤ν
	 * ʹߤλҥץˤ⥳ԡΤǡ
	 * ǽ˥ץFPUԲ㳰򵯤FPUȥ
	 * Ƥ۾򤪤ʤ
	 */
	fpuSave(KERNEL_SAVE_FPU);

	// ɥ륿Ͽ
	idleTask[i_cpu] = newThread;

	// init task signal.
	TaskSignalConstructor(&newThread->taskSignalObj, newThread);

	*o_thread = (ThreadObj*) newThread;

	return NOERR;
}

/*
 * åɤե
 *ԳԲġ
 * return : error number or 1 = 
 */
int forkThread(
	const int isKernelThread,
	void *i_proc,
	void *i_srcThread,			// եå
	void *dstVmProcObj,
	ThreadObj **o_thread)
{
	Thread *srcThread = i_srcThread;
	Thread *newThread;
	int error;

	newThread = kmalloc(sizeof(*newThread));
	if (newThread == NULL) {
		return -ENOMEM;
	}
	threadConstructor(newThread, i_proc);
	
	newThread->nestCount = srcThread->nestCount;

	/* Page tableƤ */
	error = vmFork(
		isKernelThread, 
		&srcThread->vmTaskObj, 
		&newThread->vmTaskObj, 
		dstVmProcObj);
	if (error == 1) {
		// åɼ¹Գ
		return 1;
	}
	else if (error != NOERR) {
		threadDestructor(newThread);
		return error;
	}

	// ʥꤹ
	TaskSignalConstructor(&newThread->taskSignalObj, newThread);

	*o_thread = (ThreadObj*) newThread;

	return NOERR;
}

/*
 * åɤ
 *ե塼뤫Ƥ뤳
 * return : error number
 */
void freeThread(
	ThreadObj *i_this,
	VmProcObj *i_vmProcObj)
{
	Thread *this = (Thread*) i_this;

	releaseVmTask(&this->vmTaskObj, i_vmProcObj);

	threadDestructor(this);
}

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 *Իպ줿åɤʤID0򥻥åȤ
 */
int sys_pthread_create(
	pthread_t *o_thread, 
	const pthread_attr_t *attr)
{
	Thread *newThread;
	void *proc;
	int error;

	if (vmIsReadArea(getVmProc(getCurrentProc()), o_thread, sizeof(*o_thread)) == ERR) {
		return -EFAULT;
	}
	if (attr != NULL) {
		if (vmIsReadArea(getVmProc(getCurrentProc()), attr, sizeof(*attr)) == ERR) {
			return -EFAULT;
		}
	}
	
	// åɤκ
	proc = getCurrentProc();
	error = forkThread(
		0,
		proc,
		getMainThread(proc),
		getVmProc(proc),
		(ThreadObj**) &newThread);
	if (error == 1) {
		// åɼ¹Գ
		*o_thread = 0;
		return 0;
	}
	else if (error != NOERR) {
		return error;
	}
	
	// åɤץϿ
	error = registThread(proc, &newThread->procList);
	if (error != NOERR) {
		freeThread((ThreadObj*) newThread, getVmProc(proc));
		return error;
	}

	// åɤ򥿥塼˲ä
	addNewTask((ThreadObj*) newThread);

	*o_thread = newThread->id;

	return 0;
}

void sys_pthread_exit(
	void *i_valuePtr)
{
	Thread *this = (Thread*) getCurrentTask();

	// λԤåɤ򵯤
	wakeExitWaitThread(this, i_valuePtr);

	// ᥤ󥹥åɤʤץ⽪λ
	if ((Thread*) getMainThread(this->proc) == this) {
		exit(0, 0);
	}

	taskExit();
	// äƤʤ
}

int sys_pthread_join(
	pthread_t i_joinId,
	void **o_valuePtr)
{
	Thread *this = currentTask();

	if (i_joinId == this->id) {
		return -EDEADLK;
	}
	
	return waitJoinThread(this, i_joinId, o_valuePtr);
}

int sys_pthread_self(
	pthread_t *o_thread)
{
	Thread *thread = (Thread*) getCurrentTask();
	*o_thread = thread->id;

	return 0;
}

/*
 * åɾμ
 */
int sysPthreadGetState(
	pthread_t id,
	struct pthreadState *m_state)
{
	Thread *thread;
	int error;
	
	error = procGetThread(id, (ThreadObj**) &thread);
	if (error != NOERR) {
		return error;
	}
	m_state->taskState = thread->state;

	return NOERR;
}

/*
 * åɾμ
 */
int sysGetTask(
	void **o_task)
{
	*o_task = getCurrentTask();

	return NOERR;
}

//**************************************************************************************************

#ifdef DEBUG
#include <lib/IteratorList.h>

enum {
	MONITOR_NUM		= 3,
	CPU_NUM			= 2,
	TASK_NUM		= 5,
};

static void *task[MONITOR_NUM][CPU_NUM][TASK_NUM];

void monitorSchedule(
	const int num)
{
	int cpu;
	IteratorList iterator;

	for (cpu = 0; cpu < CPU_NUM; ++cpu) {
		int i = 0;

		IteratorListConstruct(&iterator, &schedule[cpu].aggregate, &schedule[cpu].aggrMethod);
		while (iterator.hasNext(&iterator) == BOOL_TRUE) {
			task[num][cpu][i++] = iterator.next(&iterator);
			if (i == TASK_NUM) {
				break;
			}
			task[num][cpu][i] = NULL;
		}
	}
}

void displaySchedule()
{
	int num;
	int cpu;

	for (num = 0; num < MONITOR_NUM; ++num) {
		for (cpu = 0; cpu < CPU_NUM; ++cpu) {
			int i;
			
			printk("cpu%d", cpu);
			for (i = 0; i < TASK_NUM; ++i) {
				if (task[num][cpu][i] == NULL) {
					break;
				}
				printk(" %x", task[num][cpu][i]);
			}
			printk("\n");
		}
	}
}
#endif
