/*
 * debug.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/config.h>
#include <sys/types.h>
#include <dev/console/console.h>
#include <lib/lib.h>
#include <kern/proc.h>
#include <kern/kmalloc.h>
#include <kern/debug.h>


#ifdef DEBUG

int debugFlag;
int debugData;

void displaySyscallStart(
	uint entry)
{
	printDebug(60, "%x", entry);
}

void displaySyscallEnd()
{
	displayTop(60 , "syscallEnd", 10);
}

//--------------------------------------------------------------------------------------------------
// ʪ꡼ɽ
//--------------------------------------------------------------------------------------------------

static int freeMem;

void addFreeMemSize()
{
	freeMem += PAGE_SIZE;
	printDebug(70, "%x", freeMem);
}

void subtractFreeMemSize()
{
	freeMem -= PAGE_SIZE;
	printDebug(70, "%x", freeMem);
}

uint getFreeMemSize()
{
	return freeMem;
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

typedef struct {
	int num;		// 
	uint *buf;		// Хåե
} LOG_BUF;

static LOG_BUF *LogBuf;

/*
 * Хåե
 * return : error number
 */
int allocLogBuf(
	const int i_num)
{
	LOG_BUF *this = kmalloc(sizeof(*this));
	if (this == NULL) {
		return -ENOMEM;
	}
	this->buf = kmalloc(sizeof(uint) * i_num);
	if (this->buf == NULL) {
		kfree(this);
		return -ENOMEM;
	}
	memset(this->buf, 0, sizeof(uint) * i_num);
	this->num = i_num;
	
	LogBuf = this;
	
	return NOERR;
}

/*
 * ¸
 */
void saveLog(
	const uint i_log)
{
	LOG_BUF *this = LogBuf;

	// FILO
	memmove(this->buf + 1, this->buf, sizeof(uint) * (this->num - 1));
	*this->buf = i_log;
}

/*
 * 
 */
void removeLog(
	const uint i_log)
{
	LOG_BUF *this = LogBuf;
	int i;

	for (i = 0; i < this->num; ++i) {
		if (this->buf[i] == 0) {
			break;
		}
		if (this->buf[i] == i_log) {
			// ͤƺǸˣ
			memmove(&this->buf[i], &this->buf[i + 1], sizeof(uint) * (this->num - i - 1));
			this->buf[this->num - 1] = 0;
			break;
		}
	}
}

/*
 * ɽ
 */
void printLog()
{
	LOG_BUF *this = LogBuf;
	int i;

	printk("PrintLog ");
	for (i = 0; i < this->num; ++i) {
		if (this->buf[i] == 0) {
			break;
		}
		printk("%x ", this->buf[i]);
	}
	printk("\n");
}

void freeLogBuf()
{
	LOG_BUF *this = LogBuf;
	kfree(this->buf);
	kfree(this);
}

/*
 * ʸǸ夫Ӥ
 * return :  = 0 or ԰ = 1
 */
int compStrReverse(
	const char *strDst,
	const char *strSrc)
{
	const char *dst = strDst;
	const char *src = strSrc;
	
	while (*dst != '\0') {
		++dst;
	}
	while (*src != '\0') {
		++src;
	}
	while ((strDst <= dst) && (strSrc <= src)) {
		if (*dst-- != *src--) {
			return 1;
		}
	}
	
	return 0;
}
#endif
