/*
 * debug.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef debug_h
#define debug_h


#include <machine/debug.h>


#ifndef ASM_FILE


#ifdef DEBUG
 #define ASSERT(bool) if ((bool) == 0){							\
 	printk("Assertion! : %s line=%d \n",__FILE__, __LINE__);	\
 	idle();														\
 }
 #define WARNING(bool) if ((bool) == 0){						\
 	printk("Warning! : %s line=%d \n",__FILE__, __LINE__);		\
 }
#else
 #define ASSERT(bool)
 #define WARNING(bool)
#endif

#ifdef DEBUG
 #define DEBUG_CALL_DISPLAY(str) int _debug = displayTop(60 , str, 10)
#else
 #define DEBUG_CALL_DISPLAY(str)
#endif

extern int debugFlag;
extern int debugData;
extern int displayTop(int, const char*, int);

extern void addFreeMemSize();
extern void subtractFreeMemSize();
extern uint getFreeMemSize();

extern int allocLogBuf(const int);
extern void saveLog(const uint);
extern void removeLog(const uint);
extern void printLog();
extern void freeLogBuf();
extern int compStrReverse(const char*, const char*);

extern void test_console();
extern void test_fd();
extern void test_com();
extern void test_time(int);
extern void test_device();
extern void testFs();
extern void test_orig_fs();
extern void test_fatFs();
extern void test_elf(void*);
extern int test_ext2(int);
extern void test_pci();
extern int test_arp();
extern uint test_tcp();
extern void testMp(const int, void*);
extern void testSignal();
extern void test_freebsd();
extern void testPcibus(const int);
extern int testDisplay(int num);
extern void lockTest(void *i_proc, int cnt, void*);
extern void test_mbuf(uint, uint);
extern void test_ata();
extern int testIntr();
extern int testIntr();
extern void testSyscall();
extern void testLock();
extern void test_proc();
extern void test_vm(uint*, uint);
extern int testInterrupt();
extern int testBlock(void*);
extern void test_timer(int);
extern void testEntry(void*, const int);
extern void testDevInterrupt();
extern void testLock(const uint);
extern uint testThread(void *);
extern void testAta();
extern void testModule();
extern void testBlockCache();
extern void testDevfs();
extern void test_physmem(void*);
extern void testDevInterrupt(const int);

#endif


#endif
