/*
 * dev_method.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/bus.h>

#include <kern/debug.h>


//#define DEBUG_DEV_METHOD 1
#ifdef DEBUG_DEV_METHOD
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


/******************************************************************************************************
 *
 * ǥХ᥽å
 *
 *******************************************************************************************************/


//================================== PRIVATE ============================================


// Х᥽åɤ
// return : error number
STATIC int getBusMethod(const device_t i_dev, const int i_desc ,void **o_func)
{
	device_t dev;
	
	for (dev = i_dev; dev != NULL; dev = dev->parent){
		int i;

		if (dev->driver != NULL){
			device_method_t *methods = dev->driver->methods;
			for (i = 0; methods[i].func != NULL; i++){
				if (methods[i].index == i_desc){
					*o_func = methods[i].func;
					return NOERR;
				}
			}
		}
	}
	
	return -ENOENT;
}


//================================== PUBLIC =============================================


// ХϿؿƤӽФ
#define DEV_GET_METHOD1(name, desc)							\
int name(device_t dev){										\
	int (*func)(device_t);									\
															\
	if (getBusMethod(dev, desc, (void**)&func) == NOERR){	\
		return func(dev);									\
	}														\
	else{													\
		return 0;											\
	}														\
}
DEV_GET_METHOD1(DEVICE_PROBE, device_probe_desc)
DEV_GET_METHOD1(DEVICE_ATTACH, device_attach_desc)
DEV_GET_METHOD1(DEVICE_DETACH, device_detach_desc)
//DEV_GET_METHOD1(DEVICE_SHUTDOWN, device_shutdown_desc)
//DEV_GET_METHOD1(DEVICE_SUSPEND, device_suspend_desc)
//DEV_GET_METHOD1(DEVICE_RESUME, device_resume_desc)

#define DEV_GET_METHOD2(name, desc)							\
void name(device_t dev, device_t child){					\
	void (*func)(device_t, device_t);						\
															\
	if (getBusMethod(dev, desc, (void**)&func) == NOERR){	\
		func(dev, child);									\
	}														\
}
DEV_GET_METHOD2(BUS_PROBE_NOMATCH, bus_probe_nomatch_desc)
DEV_GET_METHOD2(BUS_CHILD_DETACHED, bus_child_detached_desc)

void DEVICE_IDENTIFY(driver_t *driver, device_t parent){
	int (*func)(driver_t *, device_t);

	if (getBusMethod(parent, device_identify_desc, (void**)&func) == NOERR){
		func(driver, parent);
	}
}

int BUS_PRINT_CHILD(device_t bus, device_t dev){
	int (*func)(device_t, device_t);

	if (getBusMethod(dev, bus_print_child_desc, (void**)&func) == NOERR){
		return func(bus, dev);
	}
	else{
		return 0;
	}
}

void BUS_DRIVER_ADDED(device_t dev, driver_t *driver){
	void (*func)(device_t, driver_t *);

	if (getBusMethod(dev, bus_driver_added_desc, (void**)&func) == NOERR){
		func(dev, driver);
	}
}

struct resource *BUS_ALLOC_RESOURCE(
	device_t dev, device_t child, 
	int type, 
	int *rid,
	u_long start, 
	u_long end, 
	u_long count, 
	u_int flags)
{
	struct resource *(*func)(device_t , device_t , int , int *, u_long , u_long , u_long , u_int);

	if (getBusMethod(dev, bus_alloc_resource_desc, (void**)&func) == NOERR){
		return func(dev, child, type, rid, start, end, count, flags);
	}
	else{
		return 0;
	}
}

int BUS_RELEASE_RESOURCE(device_t dev, device_t child, int type, int rid, struct resource *r)
{
	int (*func)(device_t, device_t, int, int, struct resource *);

	if (getBusMethod(dev, bus_release_resource_desc, (void**)&func) == NOERR){
		return func(dev, child, type, rid, r);
	}
	else{
		return 0;
	}
}

/*device_t BUS_ADD_CHILD(device_t dev, int order, const char *name, int unit){
	device_t (*func)(device_t, int, const char *, int);

	if (getBusMethod(dev, bus_add_child_desc, (void**)&func) == NOERR){
		return func(dev, order, name, unit);
	}
	else{
		return 0;
	}
}*/

int BUS_READ_IVAR(device_t bus, device_t dev, int index, uintptr_t * result){
	int (*func)(device_t, device_t, int, uintptr_t *);

	if (getBusMethod(dev, bus_read_ivar_desc, (void**)&func) == NOERR){
		return func(bus, dev, index, result);
	}
	else{
		return 0;
	}
}

int BUS_WRITE_IVAR(device_t bus, device_t dev, int index, uintptr_t value){
	int (*func)(device_t, device_t, int, uintptr_t);

	if (getBusMethod(dev, bus_write_ivar_desc, (void**)&func) == NOERR){
		return func(bus, dev, index, value);
	}
	else{
		return 0;
	}
}

int BUS_SETUP_INTR(
	device_t parent,
	device_t dev,
	struct resource *irq,
	int intrFlag,
	void (*handler)(void *),
	void *softc,
	void *opt)
{
	int (*func)(device_t , device_t , struct resource *, int , void (*handler)(void *), void *, void *);

	if (getBusMethod(dev, bus_setup_intr_desc, (void**)&func) == NOERR){
		return func(parent, dev, irq, intrFlag, handler, softc, opt);
	}
	else{
		return 0;
	}
}


int BUS_TEARDOWN_INTR(device_t dev, device_t child, struct resource *irq, void *cookie)
{
	int (*func)(device_t, device_t, struct resource *, void *);

	if (getBusMethod(dev, bus_teardown_intr_desc, (void**)&func) == NOERR){
		return func(dev, child, irq, cookie);
	}
	else{
		return 0;
	}
}


u_int32_t PCI_READ_CONFIG(device_t dev, device_t child, int reg, int width)
{
	u_int32_t (*func)(device_t, device_t, int, int);

	if (getBusMethod(dev, pci_read_config_desc, (void**)&func) == NOERR){
		return func(dev, child, reg, width);
	}
	else{
		return -1;
	}
}

void PCI_WRITE_CONFIG(device_t dev, device_t child, int reg, u_int32_t val, int width)
{
	void (*func)(device_t, device_t, int, u_int32_t, int);

	if (getBusMethod(dev, pci_write_config_desc, (void**)&func) == NOERR){
		func(dev, child, reg, val, width);
	}
}

DEV_GET_METHOD2(PCI_ENABLE_BUSMASTER, pci_enable_busmaster_desc)
DEV_GET_METHOD2(PCI_DISABLE_BUSMASTER, pci_disable_busmaster_desc)

#define DEV_GET_METHOD3(name, desc)							\
void name(device_t dev, device_t child, int space){			\
	void (*func)(device_t, device_t, int);					\
															\
	if (getBusMethod(dev, desc, (void**)&func) == NOERR){	\
		func(dev, child, space);							\
	}														\
}
DEV_GET_METHOD3(PCI_ENABLE_IO, pci_enable_io_desc)
DEV_GET_METHOD3(PCI_DISABLE_IO, pci_disable_io_desc)

int MIIBUS_READREG(device_t dev, int phy, int reg)
{
	int (*func)(device_t, int, int);

	if (getBusMethod(dev, miibus_readreg_desc, (void**)&func) == NOERR){
		return func(dev, phy, reg);
	}
	else{
		return 0;
	}
}

int MIIBUS_WRITEREG(device_t dev, int phy, int reg, int data)
{
	int (*func)(device_t, int, int, int);

	if (getBusMethod(dev, miibus_writereg_desc, (void**)&func) == NOERR){
		return func(dev, phy, reg, data);
	}
	else{
		return 0;
	}
}

DEV_GET_METHOD1(MIIBUS_STATCHG, miibus_statchg_desc)
DEV_GET_METHOD1(MIIBUS_MEDIAINIT, miibus_mediainit_desc)
