/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef kern_device_h
#define kern_device_h

#include <sys/rman.h>

#ifndef ASM_FILE

/* ǥХơȹ¤ */
typedef struct {
	ushort		major;			// ᥸㡼ֹ
	ushort		minor;			// ѡƥʥСޥʡֹ
	int			prt_type;		// ѡƥ󥿥
	uint		all_sect;		// 
	int			sect_size;		// 
	uint		flags;
	const char	*name;
} DEV_STAT;

static inline int getMajor(
	const uint i_dev)
{
	return ((i_dev >> 8) & 0xff);
}

static inline int getMinor(
	const uint i_dev)
{
	return (i_dev & 0xff);
}

extern int initDevice();
extern struct specinfo *getDevByDevnum(const int);
extern void setupIntr(struct resource *, void (*handler)(void *), void *);
extern int read_direct(void *, void*, size_t, size_t, size_t*);
extern int write_direct(void *, void*, size_t, size_t, size_t*);

extern int devOpenDev(struct specinfo *, const int, void**);
extern int devCloseDev(struct specinfo *, void*);
extern int devReadDev(struct specinfo *, void *, const size_t, const size_t, void*);
extern int devWriteDev(struct specinfo *, void *, const size_t, const size_t, void*);
extern int devIoctlDev(struct specinfo *, const int, caddr_t, const int, void*);
extern int devPollDev(struct specinfo *, const int, void*);
extern void devStatDev(struct specinfo *, DEV_STAT *);
extern void statDev(void*, DEV_STAT *);

#endif // ASM_FILE

#endif // kern_device_h
