/*
 * elf.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/param.h>
#include <sys/types.h>
#include <sys/elf32.h>
#include <sys/elf_common.h>
#include <lib/lib.h>
#include <sys/Thread.h>
#include <kern/vm.h>
#include <kern/kmalloc.h>
#include <kern/fs.h>
#include <dev/console/console.h>

#include <kern/debug.h>


/*
 * ELFХʥɤ롣
 *ԳԲġ
 * return : error number
 */
int loadElf(
	EXEC_FD *fd,
	char **argv,
	char **envp,
	uint *o_entryAddr,		// ¹Գϥ˥ɥ쥹
	uint *o_stackAddr)		// åϥ˥ɥ쥹
{
	Elf32_Ehdr *header;
	Elf32_Phdr *phead;
	int size;
	int i;
	int error;

	/* إåɤ߹ */
	header = kmalloc(sizeof(Elf32_Ehdr));
	if (header == NULL) {
		return -ENOMEM;
	}

	fd->offset = 0;
	error = exec_read(fd, header, sizeof(Elf32_Ehdr));
	if (error != sizeof(Elf32_Ehdr)) {
		if (0 <= error) {
			error = -ENOEXEC;
		}
		goto ERR;
	}

	/* ޥåʥСǧ */
	if (memcmp("\177ELF", header->e_ident,4) != 0) {
		error = -ENOEXEC;
		goto ERR;
	}

	/* סcpuǧ */
	if ((header->e_type != ET_EXEC) || (header->e_machine != EM_386)) {
		error = -ENOEXEC;
		goto ERR;
	}

	/* ȴĶѿ桼å˥ԡ롣 */
	error = setArgEnv(getVmTask(getCurrentTask()), argv, envp, o_stackAddr);
	if (error != NOERR) {
		goto ERR;
	}

	/* 桼ΥƥȤȥǡڡ롣 */
	releaseUserPage(getVmTask(getCurrentTask()), getVmProc(getCurrentProc()));

	/* ץإåɤ߹ࡣ */
	size = header->e_phnum * sizeof(Elf32_Phdr);		/* ץإå */
	phead = kmalloc(size);
	if (phead == NULL) {
		error = -ENOMEM;
		goto ERR;
	}
	fd->offset = header->e_phoff;
	error = exec_read(fd, phead, size);
	if (error != size) {
		if (0 <= error) {
			error = -EIO;
		}
		goto ERR2;
	}

	/* ץΥɡ */
	for (i = 0; i < header->e_phnum; ++i) {
		if ((phead[i].p_type == PT_LOAD) && (0 < phead[i].p_memsz)) {
			fd->offset = phead[i].p_offset;
			error = loadBinary(
				getVmTask(getCurrentTask()),
				getVmProc(getCurrentProc()),
				fd, 
				phead[i].p_memsz,
				phead[i].p_filesz,
				phead[i].p_vaddr, 
				(phead[i].p_flags & PF_W) ? LB_WR : LB_R);
			if (error != NOERR) {
				goto ERR2;
			}
		}
	}

	*o_entryAddr = header->e_entry;
	error = NOERR;
ERR2:
	kfree(phead);
ERR:
	kfree(header);

	return error;
}

/*************************************************************************/

void test_elf(void *buf)
{
	printk("entry address=%x\n",((Elf32_Ehdr*)buf)->e_entry);
}
