/*
 * exec.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * եμ¹
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/syscall.h>
#include <kern/fs.h>
#include <sys/Thread.h>
#include <kern/vm.h>
#include <kern/ProcSignal.h>
#include <kern/loader.h>

#include <kern/debug.h>


//#define DEBUG_EXEC 1
#ifdef DEBUG_EXEC
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

//================================== PUBLIC =============================================

int sys_exec(
	const char *path, 
	char **argv, 
	char **envp, 
	volatile SYSCALL3_FRAME frame)
{
	uint entryAddr;
	uint stackAddr;
	int error;

	error = loadFile(path, argv, envp, &entryAddr, &stackAddr);
	if (error != NOERR) {
		return error;
	}

	/* ʥ륢ν */
	ProcSignalDestructor(procGetProcSignal(getCurrentProc()));
	ProcSignalConstructor(procGetProcSignal(getCurrentProc()));

	/* ե빽¤Τν */
	initExecFs();

/* ƥॳե졼ꡣ */
	frame.eip = entryAddr;
	frame.cs = USER_CODE_DES;
	frame.user_esp = stackAddr;
	frame.ss = USER_DATA_DES;

	return NOERR;
}
