/*
 * itimer.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <kern/ProcSignal.h>
#include <sys/Thread.h>
#include <kern/vm.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <kern/itimer.h>

#include <kern/debug.h>


//#define DEBUG_ITIMER 1
#ifdef DEBUG_ITIMER
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern ITIMER *getItimerVirtual();
extern ITIMER *getItimerProc();

//===================================== PRIVATE ====================================================

/*
 * struct timevalCPUå
 * return : CPUå
 */
STATIC INLINE uint64 getClocksFromTimeval(
	const struct timeval *i_timeval)
{
	uint64 clocks;
	
	clocks = calcClockFromMicroSecond(i_timeval->tv_sec * 1000000);
	clocks += calcClockFromMicroSecond(i_timeval->tv_usec);

	return clocks;
}

/*
 * CPUåstruct timeval򥻥åȤ
 */
STATIC INLINE void setTimevalFromClocks(
	const uint64 i_clocks,
	struct timeval *m_timeval)
{
	uint64 microSeconds = calcMicroSecondFromClock(i_clocks);

	m_timeval->tv_sec = microSeconds / 1000000;
	m_timeval->tv_usec = microSeconds % 1000000;
}

/*
 * itimeritimervalͤꤹ
 */
STATIC void getItimerValue(
	const ITIMER *i_itimer,
	struct itimerval *m_itimerval)
{
	setTimevalFromClocks(i_itimer->init, &m_itimerval->it_interval);
	setTimevalFromClocks(i_itimer->current, &m_itimerval->it_value);
}

/*
 * itimervalitimerͤꤹ
 */
STATIC void setItimer(
	const struct itimerval *i_itimerval,
	ITIMER *m_itimer)
{
	m_itimer->init = getClocksFromTimeval(&i_itimerval->it_interval);
	m_itimer->current = getClocksFromTimeval(&i_itimerval->it_value);
}

//===================================== PUBLIC =====================================================

/*
 * 󥹥ȥ饯
 */
void itimerConstructor(
	ITIMER *this)
{
	this->init = 0;
	this->current = 0;
}

/*
 * ǥȥ饯
 */
void itimerDestructor(
	ITIMER *this)
{
}

/*
 * ƥ।󥿡Х륿ޡ
 */
void doItimer(
	const int64 i_clocks,		// вCPUå
	const int i_signal,			// вФ륷ʥ
	void *i_proc,				// ץ
	ITIMER *m_itimer)
{
	if (0 < m_itimer->current) {
		m_itimer->current -= i_clocks;
		if (m_itimer->current <= 0) {
			procSendSignal(i_proc, i_signal);
			m_itimer->current = m_itimer->init;
		}
	}
}

int sys_getitimer(const int i_which, struct itimerval *m_itimerval)
{
	if (vmIsReadArea(getVmProc(getCurrentProc()), m_itimerval, sizeof(*m_itimerval)) == -1){
		return -EFAULT;
	}

	switch (i_which) {
	case ITIMER_VIRTUAL:
		getItimerValue(getItimerVirtual(), m_itimerval);
		break;
	case ITIMER_PROF:
		getItimerValue(getItimerProc(), m_itimerval);
		break;
	case ITIMER_REAL: {
		TimerObj timer;

		// ߤλ֤
		getAlarmTimer(&timer);
		setTimevalMiliSeconds(getInitTime(&timer), &m_itimerval->it_interval);
		setTimevalMiliSeconds(getRemainTime(&timer), &m_itimerval->it_value);

		break;
	}
	default:
		return -EINVAL;
	}

	return 0;
}

int sys_setitimer(
	const int i_which,
	const struct itimerval *i_itimerval,
	struct itimerval *m_itimerval)
{
	if (vmIsReadArea(getVmProc(getCurrentProc()), i_itimerval, sizeof(*i_itimerval)) == -1){
		return -EFAULT;
	}
	if (m_itimerval != NULL){
		if (vmIsReadArea(getVmProc(getCurrentProc()), m_itimerval, sizeof(*m_itimerval)) == -1){
			return -EFAULT;
		}
	}
//	if ((i_itimerval->it_interval.tv_sec < 0) || 
//		(i_itimerval->it_interval.tv_usec < 0) ||
//		(i_itimerval->it_value.tv_sec < 0) || 
//		(i_itimerval->it_value.tv_usec < 0)) {
//		return -EINVAL;
//	}

	switch (i_which) {
	case ITIMER_VIRTUAL:
		if (m_itimerval != NULL) {
			getItimerValue(getItimerVirtual(), m_itimerval);
		}
		setItimer(i_itimerval, getItimerVirtual());
		break;
	case ITIMER_PROF:
		if (m_itimerval != NULL) {
			getItimerValue(getItimerProc(), m_itimerval);
		}
		setItimer(i_itimerval, getItimerProc());
		break;
	case ITIMER_REAL: {
		TimerObj oldTimer;
		uint time = getMiliSecondsTimeval(&i_itimerval->it_value);
		uint initTime = getMiliSecondsTimeval(&i_itimerval->it_interval);

		setAlarmTimer(time, initTime, &oldTimer);
		if (m_itimerval != NULL) {
			setTimevalMiliSeconds(getInitTime(&oldTimer), &m_itimerval->it_interval);
			setTimevalMiliSeconds(getRemainTime(&oldTimer), &m_itimerval->it_value);
		}

		break;
	}
	default:
		return -EINVAL;
	}

	return 0;
}
