/*
 * page_swap.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסեڡ꡼ǥХɤ߽񤭤
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/limits.h>
#include <sys/errno.h>
#include <sys/conf.h>
#include <sys/disk.h>
#include <sys/dkio.h>
#include <lib/lib.h>
#include <kern/vm.h>
#include <kern/devfs.h>
#include <kern/device.h>
#include <kern/Physmem.h>
#include <kern/BlockCache.h>

#include <kern/debug.h>


//#define DEBUG_PAGE_SWAP 1
#ifdef DEBUG_PAGE_SWAP
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== Х륤ݡ ===============================

//================================== PRIVATE ============================================

enum {
	PT_TYPE_PAGING = 0x9a,	/* ڡХååץǥХѡƥֹʲˡ */
	PB_START_SECTER = 2,	/* Хåå׳ϥ */
};

/* ӥåȥޥåפǥХ֥ͤåΰ֤롣 */
static uchar emptyBlock[] = {
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,0,
};

static uchar *pbBitMap;			// ֥åӥåȥޥå
static int pbBitMapCurrent;		// ӥåȥޥåθߤΥХȰ
static int pbBitMapSize;		// ӥåȥޥåץ
static void *devInodeObj;		// ХååץǥХinode֥
static int pbSectors;			// ڡ / 

/*
 * ڡХååפ롣
 * return : ֥å or failed=-1
 */
STATIC int getEmptyBackup()
{
	int bit;
	int i;

	i = pbBitMapCurrent;

	do {
		if (pbBitMap[i] != 0xff) {
			bit = emptyBlock[pbBitMap[i]];
			pbBitMap[i] |= 1 << bit;
			pbBitMapCurrent = i;

			return (i * CHAR_BIT + bit) * pbSectors + PB_START_SECTER;
		}

		if (++i == pbBitMapSize) {
			i=0;
		}
	} while (i != pbBitMapCurrent);

	return -1;
}

/*
 * ֥å˥åȤ롣
 */
STATIC INLINE void setBlockEmpty(
	const uint i_block)
{
	int i;

	i = (i_block - PB_START_SECTER) / pbSectors;
	pbBitMap[i / CHAR_BIT] &= (uchar) ~(1 << (i % CHAR_BIT));
}

//================================== PUBLIC =============================================

/*
 * ڡХååѥǥХޥȤ
 * return : error number
 */
int initBackupDev(
	const char *dev_path)		// device path
{
	DEV_STAT dev_stat;
	struct dkwedge_info *dkinfo;
	int error;

	// Device open
	error = devOpen(dev_path, &devInodeObj);
	if (error != NOERR) {
		return error;
	}

	// ѡƥ󥿥פγǧ
	dkinfo = entryAllocParamMem(getUserStackPoint(), sizeof(*dkinfo));
	error = devIoctl(devInodeObj, DIOCGWEDGEINFO, (caddr_t) dkinfo);
	if (error != 0) {
		return error;
	}
	if (strcmp(dkinfo->dkw_ptype, DKW_PTYPE_PAGE_SWAP) != 0) {
		return -ENODEV;
	}
	pbSectors = PAGE_SIZE / DEV_BSIZE;

	// ӥåȥޥåפγơ
	pbBitMapSize = (dev_stat.all_sect - PB_START_SECTER) / pbSectors / CHAR_BIT;
	pbBitMap = allocMultiKernelPage(ROUNDUP_DIV(pbBitMapSize, PAGE_SIZE));
	if (pbBitMap == NULL) {
		return -ENOMEM;
	}
	memset(pbBitMap, 0, pbBitMapSize);
	pbBitMapCurrent = 0;

	return NOERR;
}

/*
 * ꡼ڡХååפ
 *ԳԲġ
 * returns : error number
 */
int writePage(
	void *physMem,		// Хååʪɥ쥹
	uint *o_block)		// 񤭽Ф֥åֹ
{
	int block;
//	size_t ioSize;
	int error;

	// ֥å
	block = getEmptyBackup();
	if (block == -1) {
		return -ENOSPC;
	}

//	error = write_direct(getDevInfo(devInodeObj), physMem, pbSectors, block, &ioSize);
	error = BlockCacheWrite(getDevInfo(devInodeObj), physMem, pbSectors, block);
	if (error != NOERR) {
		return error;
	}
	
	*o_block = block;

	return NOERR;
}

/*
 * Хååץڡ꡼᤹
 * return : error number
 */
int readPage(
	const uint i_block,		// device block
	void *buf)				// memory buffer
{
//	size_t ioSize;

//	return read_direct(getDevInfo(devInodeObj), buf, pbSectors, i_block, &ioSize);
	return BlockCacheRead(getDevInfo(devInodeObj), buf, pbSectors, i_block);
}

/*
 * ֥å
 */
void freePageBlock(
	const uint i_block)		// ֥åֹ
{
	setBlockEmpty(i_block);
}
