/*
 * syscall.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/syscall.h>
#include <machine/Cpu.h>
#include <net/net.h>
#include <module/interrupt.h>
#include <kern/system.h>
#include <kern/proc.h>
#include <kern/fs.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <kern/itimer.h>
#include <kern/PhysMem.h>
#include <kern/debug.h>

//#define DEBUG_SYSCALL 1
#ifdef DEBUG_SYSCALL
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern int sysInitModule();
extern int sysRegistModule();
extern int sysSleepModule();
extern int sysDeleteModule();
extern int sysMicroDelay();
extern int sendConsole();
extern int sysWakeup();
extern int sysAwake();
extern int sysCdevswAttach();
extern int sysAllocDmaMemory();
extern int writeConsole();
extern int sysPthreadGetState();
extern int sysWaitIntr();
extern int sysAwakeIntr();
extern int sysGetTask();
extern int sysGetSemaphore();
extern int sysReleaseSemaphore();
extern int sysTsleep();
extern int sysWakeup();
extern int sys_sleep();

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

/*
 * System calls entry table
 */
struct syscallEntrys {
	SYSCALL entry[SYS_ENTRYS];
};

struct syscallEntrys syscall_table = {
	.entry[SYS_OPEN]						= sys_open,
	.entry[SYS_READ]						= sys_read,
	.entry[SYS_WRITE]						= sys_write,
	.entry[SYS_CLOSE]						= sys_close,
	.entry[SYS_LSEEK]						= sys_lseek,
	.entry[SYS_MKDIR]						= sys_mkdir,
	.entry[SYS_RENAME]						= sys_rename,
	.entry[SYS_UNLINK]						= sys_unlink,
	.entry[SYS_RMDIR]						= sys_rmdir,
	.entry[SYS_OPENDIR]						= sys_opendir,
	.entry[SYS_READDIR]						= sys_readdir,
	.entry[SYS_REWINDDIR]					= sys_rewinddir,
	.entry[SYS_CHDIR]						= sys_chdir,
	.entry[SYS_FCHDIR]						= sys_fchdir,
	.entry[SYS_GETCWD]						= sys_getcwd,
	.entry[SYS_STAT]						= sys_stat,
	.entry[SYS_FSTAT]						= sys_fstat,
	.entry[SYS_LSTAT]						= sys_lstat,
	.entry[SYS_LOCK]						= sys_lock,
	.entry[SYS_MOUNT]						= sys_mount,
	.entry[SYS_UMOUNT]						= sys_umount,
	.entry[SYS_FORK]						= sys_fork,
	.entry[SYS_EXEC]						= sys_exec,
	.entry[SYS_EXIT]						= sys_exit,
	.entry[SYS_SLEEP]						= sys_sleep,
	.entry[SYS_ALARM]						= sys_alarm,
	.entry[SYS_TIME]						= sys_time,
	.entry[SYS_GETTIMEOFDAY]				= sys_gettimeofday,
	.entry[SYS_SYNC]						= sys_sync,
	.entry[SYS_WAIT]						= sys_wait,
	.entry[SYS_GETPID]						= sys_getpid,
	.entry[SYS_GETGID]						= sys_getgid,
	.entry[SYS_GETPGID]						= sys_getpgid,
	.entry[SYS_GETPPID]						= sys_getppid,
	.entry[SYS_GETUID]						= sys_getuid,
	.entry[SYS_GETSID]						= sys_getsid,
	.entry[SYS_SETGID]						= sys_setgid,
	.entry[SYS_SETPGID]						= sys_setpgid,
	.entry[SYS_SETUID]						= sys_setuid,
	.entry[SYS_SETSID]						= sys_setsid,
	.entry[SYS_TIMES]						= sys_times,
	.entry[SYS_SIGACTION]					= sys_sigaction,
	.entry[SYS_SIGPROCMASK]					= sys_sigprocmask,
	.entry[SYS_KILL]						= sys_kill,
	.entry[SYS_SIGPENDING]					= sys_sigpending,
	.entry[SYS_SIGSUSPEND]					= sys_sigsuspend,
	.entry[SYS_BRK]							= sys_brk,
	.entry[SYS_REBOOT]						= sys_reboot,
	.entry[SYS_FCNTL]						= sys_fcntl,
	.entry[SYS_IOCTL]						= sys_ioctl,
	.entry[SYS_LINK]						= sys_link,
	.entry[SYS_SYMLINK]						= sys_symlink,
	.entry[SYS_READLINK]					= sys_readlink,
	.entry[SYS_SELECT]						= sys_select,
	.entry[SYS_POLL]						= sys_poll,
	.entry[SYS_GETFSSTAT]					= sys_getstatfs,
	.entry[SYS_STATFS]						= sys_statfs,
	.entry[SYS_UNAME]						= sys_uname,
	.entry[SYS_TTYNAME]						= sys_ttyname,
	.entry[SYS_SETTIME]						= sys_settime,
	.entry[SYS_SOCKET]						= sys_socket,
	.entry[SYS_SEND]						= sys_send,
	.entry[SYS_RECV]						= sys_recv,
	.entry[SYS_CONNECT]						= sys_connect,
	.entry[SYS_SHUTDOWN]					= sys_shutdown,
	.entry[SYS_BIND]						= sys_bind,
	.entry[SYS_LISTEN]						= sys_listen,
	.entry[SYS_ACCEPT]						= sys_accept,
	.entry[SYS_GETSOCKNAME]					= sys_getsockname,
	.entry[SYS_GETPEERNAME]					= sys_getpeername,
	.entry[SYS_GETSOCKOPT]					= sys_getsockopt,
	.entry[SYS_SETSOCKOPT]					= sys_setsockopt,
	.entry[SYS_SENDMSG]						= sys_sendmsg,
	.entry[SYS_RECVMSG]						= sys_recvmsg,
	.entry[SYS_GETITIMER]					= sys_getitimer,
	.entry[SYS_SETITIMER]					= sys_setitimer,
	.entry[SYS_CHMOD]						= sys_chmod,
	.entry[SYS_FCHMOD]						= sys_fchmod,
	.entry[SYS_CHOWN]						= sys_chown,
	.entry[SYS_FCHOW]						= sys_fchown,
	.entry[SYS_UTIMES]						= sys_utimes,
	.entry[SYS_CALC_MICROSECONDS]			= sysCalcMicroSeconds,
	.entry[SYS_PTHREAD_CREATE]				= sys_pthread_create,
	.entry[SYS_PTHREAD_EXIT]				= sys_pthread_exit,
	.entry[SYS_PTHREAD_JOIN]				= sys_pthread_join,
	.entry[SYS_PTHREAD_SELF]				= sys_pthread_self,
	.entry[SYS_IS_SET_CTLTERM]				= sysIsSetCtlterm,
	.entry[SYS_SET_CTLTERM]					= sysSetCtlterm,
	.entry[SYS_SLEEP_MODULE]				= sysSleepModule,
	.entry[SYS_DELETE_MODULE]				= sysDeleteModule,
	.entry[SYS_REGIST_MODULE]				= sysRegistModule,
	.entry[SYS_SET_USER_IO_ACCESS]			= sysSetUserIoAccess,
	.entry[SYS_CDEVSW_ATTACH]				= sysCdevswAttach,
	.entry[SYS_WRITE_CONSOLE]				= writeConsole,
	.entry[SYS_ALLOC_DMA_MEMORY]			= sysAllocDmaMemory,
	.entry[SYS_GET_LAST_ADDR]				= sys_getLastAddr,
	.entry[SYS_INTR_ESTABLISH]				= sysIntrEstablish,
	.entry[SYS_INTR_DISESTABLISH]			= sysIntrDisestablish,
	.entry[SYS_PTHREAD_GET_STATE]			= sysPthreadGetState,
	.entry[SYS_MICRO_DELAY]					= sysMicroDelay,
	.entry[SYS_MACHINE1]					= sysIsSupportSysenter,
	.entry[SYS_INIT_MODULE]					= sysInitModule,
	.entry[SYS_TSLEEP]						= sysTsleep,
	.entry[SYS_WAKEUP]						= sysWakeup,
	.entry[SYS_AWAKE]						= sysAwake,
	.entry[SYS_SEND_CONSOLE]				= sendConsole,
	.entry[SYS_BUSY_WAIT]					= sysGetSemaphore,
	.entry[SYS_BUSY_AWAKE]					= sysReleaseSemaphore,
	.entry[SYS_WAIT_IDENTIFY]				= sysWaitIntr,
	.entry[SYS_AWAKE_IDENTIFY]				= sysAwakeIntr,
	.entry[SYS_GET_TASK]					= sysGetTask,
/****************************************************************************************************************/
	.entry[SYS_TEST]						= testDevInterrupt,
};
