/*
 * system.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 + ƥ
 */

#include <sys/utsname.h>
#include <sys/param.h>
#include <machine/apm.h>
#include <machine/syscall.h>
#include <machine/lib.h>
#include <lib/lib.h>
#include <sys/Thread.h>
#include <kern/fs.h>
#include <kern/ProcSignal.h>
#include <kern/PhysMem.h>
#include <kern/vm.h>
#include <kern/system.h>

#include <kern/debug.h>

//===================================== PRIVATE ====================================================

static void shutdownAll()
{
	/* ץkill롣 */
//	sendSignalAllProc(SIGKILL);

	/* ե륷ƥ򥢥ޥȤ롣 */
	sys_umount_root();
/******************************************/
printk("1 ");
/*******************************************/
	sys_sync();
/*******************************************/
printk("2 ");
/*******************************************/
}

//===================================== PUBLIC =====================================================

//--------------------------------------------------------------------------------------------------
// System call
//--------------------------------------------------------------------------------------------------

int sys_reboot(int flag)
{
	// uidǧ
	if (getUid(getCurrentProc()) != 0) {
		return -EACCES;
	}

	switch(flag) {
	case REBOOT_REBOOT:
		shutdownAll();
		// Ƶư
		reboot();
		break;
	case REBOOT_POWEROFF: {
		int error;

		shutdownAll();
		error = setApmPowerOff();
		if (error != NOERR) {
			printk("Apm power off error! %s\n", getApmErrorMessage(error));
			idle();
		}
		break;
	}
	default:
		return -EINVAL;
	}

	return 0;
}


static struct SYSUTS{
	char *sysname;
	char *nodename;
	char *release;
	char *version;
}sysuts = {
	UTSNAME_SYSNAME,
	UTSNAME_NODENAME,
	UTSNAME_RELEASE,
	UTSNAME_VERSION
};

int sys_uname(struct utsname *buf)
{
	if (vmIsReadArea(getVmProc(getCurrentProc()), buf, sizeof(struct utsname)) == ERR) {
		return -EFAULT;
	}

	memcpy(buf->sysname, sysuts.sysname, strlen(sysuts.sysname) + 1);
	memcpy(buf->nodename, sysuts.nodename, strlen(sysuts.nodename) + 1);
	memcpy(buf->release, sysuts.release, strlen(sysuts.release) + 1);
	memcpy(buf->version, sysuts.version, strlen(sysuts.version) + 1);
	memcpy(buf->machine, "UNDEFINE", strlen("UNDEFINE") + 1);

	return 0;
}
