/*
 * timer.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef timer_h
#define timer_h

#include <lib/AggregateList.h>
#include <sys/time.h>

#ifndef ASM_FILE

/*
 * ȥ֥
 *԰¸WaitΥƱ
 */
typedef struct {
	char dummy[48];
} TimerObj;

/*
 * ޡ¤νͭإå
 */
typedef struct {
	AggregateList		aggrList;		// ޡ󥯽
	AggregateListMethod	aggrMethod;		// ޡ󥯥᥽å
	int					lock;			// ԥå
} TIMER_OWNER;

extern void initTimer();
extern void initProcessTimer(void *);
extern void doRealTimer(const uint);
extern void doIntervalTimer(const uint);
extern int setSystemTimer(const uint, const uint, void (*handle)(void*), void*, void**);
extern int setTaskTimer(const uint, const uint, void (*handle)(void*), void*, void**);
extern int setAlarmTimer(const uint, const uint, TimerObj*);
extern void resetTimer(void*);
extern void releaseProcessTimer(TIMER_OWNER*);
extern uint getInitTime(TimerObj*);
extern uint getRemainTime(TimerObj*);
extern void getAlarmTimer(TimerObj*);
extern void micro_timer(uint);
extern void mili_timer(uint);
extern int sys_alarm();

#endif

#endif
