/*
 * vfs.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef kern_vfs_h
#define kern_vfs_h

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <kern/FsRegist.h>

#ifndef ASM_FILE

extern void VfsInit();
extern void VfsClose(void *);
extern int copyRootPath(void *vent, const size_t size, char *m_path);
extern int mountRoot(const char*,const char*);
extern void umountAllFs();
extern int mountToVfs(FS *, void*, void *, void *);
extern int umountPath(const char *);
extern int creatObj(const char *, const mode_t);
extern int mkdirPath(const char *, const mode_t);
extern int creatSymlink(const char *, const mode_t , char *);
extern int openPath(const char *, const int, void **);
extern void linkVent(void *m_vent);
extern int getVent(const char*, void**);
extern void releaseVent(void *);
extern int deleteObj(const char *, const int);
extern int renamePath(const char *, const char *);
extern int statPath(const char *, struct stat *);
extern int statPathSymlink(const char *, struct stat *);
extern int statfsPath(const char *, struct statfs *);
extern int searchMount(struct statfs *, const int);
extern int readlinkPath(const char *, const size_t , char *);
extern int chownPath(const char *, const uid_t, const gid_t);
extern int chownVent(void *, const uid_t, const gid_t);
extern int utimesPath(const char *, const struct timeval *);
extern int linkPath(const char *, const char *);
extern void *getChdirVentPath(const char *, int *);
extern void *getChdirVent(void *, int *);
extern int pollVent(void *, int);
extern int getTypeVent(void *);
extern void *getRootEnt();
extern int getTtynameVent(void *, char *);
extern int chmodPath(const char *, const mode_t);
extern int readVent(void *i_vent, const size_t size, const size_t offset, void *buf);
extern int writeVent(void *i_vent, const size_t size, const size_t offset, void *buf);
extern int ioctlVent(void *, const int, caddr_t, int);
extern int statVent(void *, struct stat *);
extern int ioctlVent(void *, const int, caddr_t, int);
extern int opendirVent(void *, uint *, int *);
extern int readdirVent(void *, uint *, int *, char *);
extern int chmodVent(void *, const mode_t);

#endif

#endif
