/*
 * vm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסղۥ꡼
 *
 *¡ա ʳδ¸Υڡ꥽ѹƤϤʤʤ
 *         ȤƤʤڡȥ꡼ɬ0ꥢ롣
 *
 *Ե§եڡХåå׻Υڡȥ꡼Υ쥤
 *        0bit=0,123bit=¸֥åֹ,2431bit=֥åȥ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <lib/IteratorList.h>
#include <lib/AggregateList.h>
#include <machine/vm.h>
#include <machine/Except.h>
#include <machine/interrupt.h>
#include <machine/mp.h>
#include <machine/lock.h>
#include <machine/Entry.h>
#include <kern/ProcSignal.h>
#include <kern/fs.h>
#include <kern/Physmem.h>
#include <kern/kmalloc.h>
#include <kern/page_swap.h>
#include <kern/proc.h>
#include <sys/Thread.h>
#include <kern/vm.h>

#include <kern/debug.h>

//=====================================  ===================================================

/*
 * ץۥ꡼¤
 * ץˣ
 *ԱƶեСѹVmProcObjΥѹ뤳
 */
typedef struct {
	uint readFirst;					// ƺѤ߽Բĥڡۥɥ쥹
	uint readLast;					// ƺѤ߽Բĥڡۥɥ쥹饹
	uint writeFirst;				// ƺѤ߽߲ĥڡۥɥ쥹
	uint writeLast;					// ƺѤ߽߲ĥڡۥɥ쥹饹
	uint stackFirst;				// ѤߥåƬۥɥ쥹
	uint dmaAllocAddr;				// DMA꡼ƲǽƬۥɥ쥹
	AggregateList aggrVmTask;		// ۥ꡼
	AggregateListMethod aggrMethod;	// Υ᥽å
	int spinLock;					// ԥå
} VmProc;

/*
 * ۥ꡼¤
 * ˣġץۥ꡼¤Τʣꤨ
 *ԱƶեСѹVmTaskObjΥѹ뤳
 */
typedef struct VmTask {
	VmProc *vmProc;					// ץۥ꡼¤
	List list;						// ץۥ꡼󥯥ꥹ
	uint *pageDir;					// ڡǥ쥯ȥ
	uint *restorePageDir;			// ̲۴ĶܹԻθ¸ڡǥ쥯ȥ

	void *kernStack;				// 桼⥸塼ϥɥѥͥ륹å
	void *sigHandleKernStack;		// 桼ʥϥɥѥͥ륹å
	int iomapPageDirIdx;			// 桼ɥ饤СIOޥå׺ѥڡǥ쥯ȥꥤǥå
	uint savePageDirEnt;			// IOޥå׳ڡǥ쥯ȥꥨȥ꡼Υ
	uint saveModuleDirEnt[(DRIVER_END - DRIVER_BEG) / PAGE_DIR_SIZE];	// 桼⥸塼볺ڡǥ쥯ȥꥨȥ꡼Υ
} VmTask;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static int vmTaskConstructor(
	VmTask *this)
{
	memset(this, 0, sizeof(*this));

	this->pageDir = allocKernelPage();
	if (this->pageDir == NULL) {
		return -ENOMEM;
	}
	memset(this->pageDir, 0, PAGE_SIZE);

	listConstructor(&this->list, this);

	// 桼᥽åѥͥ륹åƤ
	this->kernStack = allocKernelPage();
	if (this->kernStack == NULL) {
		return -ENOMEM;
	}

	copyFpuSaveArea(this->kernStack);

	return NOERR;
}

static void vmProcConstructor(
	VmProc *this)
{
	memset(this, 0, sizeof(*this));

	// DMA꡼
	this->dmaAllocAddr = DRIVER_DMA_BEG;

	AggregateListConstructor(&this->aggrVmTask, &this->aggrMethod);
}

/*
 * 桼ʥϥɥѥåƤ
 * return : error number
 */
static int allocUserSignalHandlerStack(
	VmTask *this)
{
	if (this->sigHandleKernStack == NULL) {
		this->sigHandleKernStack = allocKernelPage();
		if (this->sigHandleKernStack == NULL) {
			return -ENOMEM;
		}
		copyFpuSaveArea(this->sigHandleKernStack);
	}
	return NOERR;
}

/*
 * ۥ꡼¤Τե
 *եۥ꡼ե˸ƤФ
 * return : error number
 */
static int vmTaskFork(
	VmTask *this,
	VmTask *src)
{
	int error;

	if (src->sigHandleKernStack != NULL) {
		error = allocUserSignalHandlerStack(this);
		if (error != NOERR) {
			return error;
		}
	}

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// ڡХåå
//--------------------------------------------------------------------------------------------------

/*
 * ڡȥ꡼Хååץ֥åֹ롣
 * return : block number
 */
static inline uint getBackBlock(
	const uint pageEnt)
{
	return (pageEnt & 0xffffff) >> 1;
}

/*
 * ڡȥ꡼˥Хååץ֥åֹꤹ롣
 */
static inline void setBackBlock(
	uint *m_pageEnt,		// page entry address
	const uint i_block)		// Хååץ֥åֹ
{
	*m_pageEnt = i_block << 1;
}

//--------------------------------------------------------------------------------------------------
// ԡ饤
//--------------------------------------------------------------------------------------------------

/*
 * ڡȥ꡼ԡ饤ȤꤵƤ뤫
 * return : YES or NO
 */
static inline int isCopyOnWritePage(
	uint *pageDir,
	const uint i_addr)		// ۥɥ쥹
{
	uint *entry = getPageEntryAddr(i_addr, pageDir);
	return isCopyOnWrite(*entry);
}

/*
 * ԡ饤Ȥ
 * return : error number
 */
static int resetCopyOnWritePage(
	uint *pageDir,
	const uint i_virtAddr)
{
	uint *entry = getPageEntryAddr(i_virtAddr, pageDir);
	uint *physMem;

	ASSERT(isCopyOnWrite(*entry) == YES);

	// ڡȥ꡼Υԡ饤Ȥ
	resetCopyOnWrite(entry);

	// ɬפʤʪ꡼Ƥ
	physMem = getPhysMemFromEntry(*entry);
	enterPhysMemLock(physMem);
	{
		if (1 < getPhysPageLinkCount(physMem)) {
			uint *newPhysMem;

			unlinkPhysTable(physMem);
			newPhysMem = allocUserPage();
			if (newPhysMem == NULL) {
				exitPhysMemLock(physMem);
				return -ENOMEM;
			}
			memcpy(newPhysMem, physMem, PAGE_SIZE);
			setPhysMemEntry(entry, newPhysMem);
		}
	}
	exitPhysMemLock(physMem);

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// ۥ꡼
//--------------------------------------------------------------------------------------------------

static uint *flatPageDir;		// ǡžѥեåȥ꡼ǥڡǥ쥯ȥ

/*
 * ֥꡼ԡѥեåȥ꡼ǥڡǥ쥯ȥκ
 * return : error number
 */
static int creatFlatPageDir()
{
	uint *pageDir;
	int i;
	
	pageDir = allocKernelPage();
	if (pageDir == NULL) {
		return -ENOMEM;
	}
	
	// 4Mեåȥ꡼ڡ
	for (i = 0; i < IOMAP_BEG / PAGE_DIR_SIZE; ++i) {
		set4mPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ꡼ޥåץIOڡѥǥ쥯ȥ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		setIomapPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}
	
	flatPageDir = pageDir;

	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// ڡ
//--------------------------------------------------------------------------------------------------

/*
 * ڡơ֥ܺ
 * return : error number
 */
enum {
	SCAN_END = 1,	// ܺ潪λֵ
};

static int scanPage(
	const uint i_firstAddr,		// ɥ쥹
	const uint i_lastAddr,		// λɥ쥹
	int func(const int, const int, const int, void*),
	void *arg)
{
	int lastDir = ROUNDUP_DIV(i_lastAddr, PAGE_DIR_SIZE);
	int c_page = (i_firstAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE;
	int c_dir;

	for (c_dir = i_firstAddr / PAGE_DIR_SIZE; c_dir < lastDir; c_page = 0, ++c_dir) {
		int error;
		int lastPage = ROUNDUP_DIV(i_lastAddr - c_dir * PAGE_DIR_SIZE, PAGE_SIZE);
		if (PAGE_SIZE / sizeof(uint) < lastPage) {
			lastPage = PAGE_SIZE / sizeof(uint);
		}

		error = func(c_dir, c_page, lastPage, arg);
		if (error != NOERR) {
			return error;
		}
	}
	
	return NOERR;
}

/*
 * Υ桼ǡΰ褫ʪ꡼
 *ԳԲġ
 * return : error number
 */
typedef struct {
	uint *pageDir;
	void *physMem;
} GetPhysMemFromMine;

static int getPhysMemFromMine(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	GetPhysMemFromMine *getPhysMemArg = arg;
	uint *pageTbl = getPhysMemFromEntry(getPhysMemArg->pageDir[c_dir]);
	int c_page;

	for (c_page = firstPage; c_page < lastPage; ++c_page) {
		if (isPagePresenEntry(pageTbl[c_page]) == NO) {
			continue;
		}
		if (pageTbl[c_page] & PAGE_RW) {
			void *physMem = getPhysMemFromEntry(pageTbl[c_page]);
			uint block;
			int error;
			
			// ХååץǥХ˥֤
			error = writePage(physMem, &block);
			if (error != NOERR) {
				return error;
			}
			setBackBlock(&pageTbl[c_page], block);
			getPhysMemArg->physMem = physMem;
			return SCAN_END;
		}
	}
	
	return NOERR;
}

/*
 * ڡȥڡơ֥ʪƤ
 * return : error number
 */
typedef struct {
	uint *pageDir;
	void (*setPageDirEnt)(void *const, uint*);	// ڡǥ쥯ȥꥨȥ꡼᥽å
	void (*setPageEnt)(void *const, uint*);		// ڡȥ꡼᥽å
} AllocPage;

static int allocPage(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	AllocPage *allocPageArg = arg;
	int c_page;
	uint *pageTbl = getPhysMemFromEntry(allocPageArg->pageDir[c_dir]);
	if (pageTbl == NULL) {
		// ڡơ֥ʪ꡼Ƥ
		pageTbl = allocKernelPage();
		if (pageTbl == NULL) {
			return -ENOMEM;
		}
		memset(pageTbl, 0, PAGE_SIZE);
		allocPageArg->setPageDirEnt(pageTbl, &allocPageArg->pageDir[c_dir]);
	}

	// ڡʪ꡼Ƥ
	for (c_page = firstPage; c_page < lastPage; ++c_page) {
		if (pageTbl[c_page] == 0) {
			void *physMem = allocUserPage();
			if (physMem == NULL) {
				return -ENOMEM;
			}
			allocPageArg->setPageEnt(physMem, &pageTbl[c_page]);
		}
	}
	
	return NOERR;
}

/*
 * ڡȥڡơ֥ڡñ̤ǳ롣
 *ոƤӽФ˥ץñ̤¾椵Ƥ
 *Իեڡǥ쥯ȥñ̤ǳ
 */
typedef struct {
	uint *pageDir;
} ReleasePage;

static int releasePage(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	ReleasePage *releasePageArg = arg;
	uint *pageTbl;
	int c_page;

	if (releasePageArg->pageDir[c_dir] == 0) {
		return NOERR;
	}

	pageTbl = getPhysMemFromEntry(releasePageArg->pageDir[c_dir]);

	// ڡȥ꡼γ
	if (getPhysPageLinkCount(pageTbl) == 1) {
		for (c_page = firstPage; c_page < lastPage; ++c_page) {
			if (pageTbl[c_page] == 0) {
				continue;
			}

			// ѤƤڡ
			if (isPagePresenEntry(pageTbl[c_page]) == YES) {
				void *physMem = getPhysMemFromEntry(pageTbl[c_page]);
				enterPhysMemLock(physMem);
				{
					unlinkPhysTable(physMem);
				}
				exitPhysMemLock(physMem);
			}
			else {
				/* ڡХååפƤ */
				freePageBlock(getBackBlock(pageTbl[c_page]));
			}
		}
	}

	// ڡǥ쥯ȥñ̤ǳΤǥڡơ֥
	unlinkPhysTable(pageTbl);
	releasePageArg->pageDir[c_dir] = 0;
	
	return NOERR;
}

/*
 * 桼åؤ
 * return : error number
 */
typedef struct {
	uint *pageDir;
	void **pphysMem;	// ʪ꡼Ƭ
} MapUserStack;

static int mapUserStack(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	MapUserStack *mapUserStackArg = arg;
	int c_page;
	uint *pageTbl = getPhysMemFromEntry(mapUserStackArg->pageDir[c_dir]);

	if (pageTbl == NULL) {
		// ڡơ֥ʪ꡼Ƥ
		pageTbl = allocKernelPage();
		if (pageTbl == NULL) {
			return -ENOMEM;
		}
		memset(pageTbl, 0, PAGE_SIZE);
		setUserRwPageDirEntry(pageTbl, &mapUserStackArg->pageDir[c_dir]);
	}

	// ڡʪ꡼Ƥ
	for (c_page = firstPage; c_page < lastPage; ++c_page) {
		setUserRwPageEntry(*mapUserStackArg->pphysMem, &pageTbl[c_page]);
		--mapUserStackArg->pphysMem;
	}

	return NOERR;
}

/*
 * ڡ򥳥ԡ
 *եԡڡϤ٤ʪ꡼ƤƤ뤳
 *ԳԲġ
 * return : error number
 */
typedef struct {
	uint *dstPageDir;			// ԡڡǥ쥯ȥ
	uint *srcPageDir;			// ԡڡǥ쥯ȥ
} CopyPage;

static int copyPage(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	CopyPage *copyPageArg = arg;
	uint *dstPageTbl = getPhysMemFromEntry(copyPageArg->dstPageDir[c_dir]);
	uint *srcPageTbl = getPhysMemFromEntry(copyPageArg->srcPageDir[c_dir]);
	int c_page;

	ASSERT(dstPageTbl != NULL);

	if (srcPageTbl == NULL) {
		return NOERR;
	}

	for (c_page = firstPage; c_page < lastPage; ++c_page) {
		ASSERT(dstPageTbl[c_page] != 0);

		if (srcPageTbl[c_page] == 0) {
			continue;
		}
		
		if (isPagePresenEntry(srcPageTbl[c_page]) == YES) {
			memcpy(getPhysMemFromEntry(dstPageTbl[c_page]), getPhysMemFromEntry(srcPageTbl[c_page]), PAGE_SIZE);
		}
		else {
			int error = readPage(getBackBlock(srcPageTbl[c_page]), getPhysMemFromEntry(dstPageTbl[c_page]));
			if (error != NOERR) {
				return error;
			}
		}
	}
	
	return NOERR;
}

/*
 * ƥڡ饳ԡ饤Ȥꤹ
 *vmFork()ƤФ
 *ԳԲġ
 */
typedef struct {
	uint *dstPageDir;			// ԡڡǥ쥯ȥ
	uint *srcPageDir;			// ԡڡǥ쥯ȥ
} CopyOnWritePage;

static int copyOnWritePage(
	const int c_dir,
	const int firstPage,
	const int lastPage,
	void *arg)
{
	CopyOnWritePage *copyOnWritePageArg = arg;
	uint *dstPageTbl;
	uint *srcPageTbl;
	int c_page;

	if (copyOnWritePageArg->srcPageDir[c_dir] == 0) {
		return NOERR;
	}

	// ڡơ֥Ƥ
	dstPageTbl = allocKernelPage();
	if (dstPageTbl == NULL) {
		return -ENOMEM;
	}
	setUserRwPageDirEntry(dstPageTbl, &copyOnWritePageArg->dstPageDir[c_dir]);
	srcPageTbl = getPhysMemFromEntry(copyOnWritePageArg->srcPageDir[c_dir]);
	memcpy(dstPageTbl, srcPageTbl, PAGE_SIZE);

	for (c_page = firstPage; c_page < lastPage; ++c_page) {
		void *physMem;

		if (dstPageTbl[c_page] == 0) {
			continue;
		}

		// ԡ饤Ȥ
		if (isPagePresenEntry(dstPageTbl[c_page]) == YES) {
			physMem = getPhysMemFromEntry(dstPageTbl[c_page]);
			enterPhysMemLock(physMem);
			{
				linkPhysTable(physMem);
			}
			exitPhysMemLock(physMem);
			setCopyOnWrite(&srcPageTbl[c_page]);
			setCopyOnWrite(&dstPageTbl[c_page]);
		}
		else {
			int error;

			physMem = allocUserPage();
			if (physMem == NULL) {
				return -ENOMEM;
			}
			error = readPage(getBackBlock(dstPageTbl[c_page]), physMem);
			if (error != NOERR) {
				return error;
			}
			setRwPageEntry(physMem, &dstPageTbl[c_page]);
		}
	}
	
	return NOERR;
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

/*
 * Ժߥڡʪ꡼Ƥ
 *ոƤӽФ˥ץñ̤¾椵Ƥ
 *ԳԲġ
 * return : error number
 */
static int allocPageMem(
	const uint i_virtAddr,
	VmTask *vmTask,
	VmProc *vmProc)
{
	uint *pageDir = vmTask->pageDir;
	uint *pageDirEnt = getPageDirEntryAddr(i_virtAddr, pageDir);
	uint *pageEnt;
	int error;

	// ڡơ֥Ƥ
	if (*pageDirEnt == 0) {
		void *pageTbl;

		/*
		 * ¾åɤǴ˳ƤƤ饨ȥ꡼򥳥ԡ
		 */
		if (2 <= vmProc->aggrMethod.getCount(&vmProc->aggrVmTask)) {
			IteratorList iterator;
			IteratorListConstruct(&iterator, &vmProc->aggrVmTask, &vmProc->aggrMethod);
			while (iterator.hasNext(&iterator) == BOOL_TRUE) {
				VmTask *next = iterator.next(&iterator);
				if (next->pageDir[i_virtAddr / PAGE_DIR_SIZE] != 0) {
					void *physMem  = getPhysMemFromEntry(next->pageDir[i_virtAddr / PAGE_DIR_SIZE]);
					*pageDirEnt = next->pageDir[i_virtAddr / PAGE_DIR_SIZE];
					linkPhysTable(physMem);
					break;
				}
			}
		}

		if (*pageDirEnt == 0) {
			pageTbl = allocKernelPage();
			if (pageTbl == NULL) {
				// Υ桼ǡΰ褫ʪ꡼
				GetPhysMemFromMine getPhysMemArg;
				getPhysMemArg.pageDir = pageDir;
				error = scanPage(vmProc->writeFirst, vmProc->writeLast, getPhysMemFromMine, &getPhysMemArg);
				if (error != SCAN_END) {
					return (error == NOERR) ? -ENOMEM : error;
				}
				pageTbl = getPhysMemArg.physMem;
			}
			memset(pageTbl, 0, PAGE_SIZE);
			setUserRwPageDirEntry(pageTbl, pageDirEnt);
		}
	}

	// ڡƤ
	pageEnt = getPageEntryAddrFromPageTbl(i_virtAddr, getPhysMemFromEntry(*pageDirEnt));
	if (isPagePresenEntry(*pageEnt) == NO) {
		void *physMem = allocUserPage();
		if (physMem == NULL) {
			// Υ桼ǡΰ褫ʪ꡼
			GetPhysMemFromMine getPhysMemArg;
			getPhysMemArg.pageDir = pageDir;
			error = scanPage(vmProc->writeFirst, vmProc->writeLast, getPhysMemFromMine, &getPhysMemArg);
			if (error != SCAN_END) {
				return (error == NOERR) ? -ENOMEM : error;
			}
			physMem = getPhysMemArg.physMem;
		}

		// Хååפ
		if (*pageEnt != 0) {
			error = readPage(getBackBlock(*pageEnt), physMem);
			if (error != NOERR) {
				return error;
			}
			freePageBlock(getBackBlock(*pageEnt));
		}

		setUserRwPageEntry(physMem, pageEnt);
	}
	else {
		// ¾åɤǴ˥ڡƤ硢⤷ʤ
	}

	return NOERR;
}

/*
 * 桼᥽åѥå
 */
static void freeUserMethodStack(
	VmTask *m_vmTask)
{
	if (m_vmTask->sigHandleKernStack != NULL) {
		unlinkPhysTable(m_vmTask->sigHandleKernStack);
	}

	if (m_vmTask->kernStack != NULL) {
		unlinkPhysTable(m_vmTask->kernStack);
	}
}

/*
 * ɥ쥹ȿǤʤ
 * return : NOERR or ERR
 */
static int isCorrectAccess(
	VmProc *vmProc,
	const uint i_firstAddr,
	const uint i_lastAddr)
{
	if ((vmProc->readFirst <= i_firstAddr) && (i_lastAddr <= vmProc->writeLast)) {
		return NOERR;
	}
	else if ((vmProc->stackFirst - PAGE_SIZE * 2 <= i_firstAddr) && (i_lastAddr < USER_ESP_BEG)) {
		return NOERR;
	}
	else if ((DRIVER_DMA_BEG <= i_firstAddr) && (i_lastAddr < vmProc->dmaAllocAddr)) {
		return NOERR;
	}
	return ERR;
}

/*
 * եåȥ꡼ǥĶذܹ
 */
static void switchFlatPageDir(
	VmTask *currentVmTask)
{
	int eflags;

	eflags = enterCli();
	{
		uint addr;

		// ͥ륹åڡǥ쥯ȥ򥳥ԡ
		for (addr = KERNEL_STACK_BEG; addr < KERNEL_END; addr += PAGE_DIR_SIZE) {
			uint *p_pageEnt = getPageDirEntryAddr(addr, flatPageDir);
			*p_pageEnt = *getPageDirEntryAddr(addr, currentVmTask->pageDir);

		}

		// ۥ꡼Ķܹ
		currentVmTask->restorePageDir = currentVmTask->pageDir;
		currentVmTask->pageDir = flatPageDir;
		updatePageDir(currentVmTask->pageDir);
	}
	exitCli(eflags);
}

/*
 * β۴Ķ᤹
 */
static void restorePageDir(
	VmTask *currentVmTask)
{
	int eflags;

	eflags = enterCli();
	{
		// βۥ꡼Ķܹ
		currentVmTask->pageDir = currentVmTask->restorePageDir;
		updatePageDir(currentVmTask->pageDir);
	}
	exitCli(eflags);
}

/*
 * ʸȰݥ򥹥å꡼
 */
typedef struct {
	char **argv;
	void **pstack;
	int argSum;
	int argvSum;
} SetStackArg;

static void setStackArg(
	SetStackArg *setArg)
{
	char *parg = setArg->pstack[setArg->argSum / PAGE_SIZE] + PAGE_SIZE - (setArg->argSum % PAGE_SIZE);
	uint argLimit = ROUNDDOWN(setArg->argSum + PAGE_SIZE, PAGE_SIZE);
	char **pargv;
	uint argvLimit = ROUNDDOWN(setArg->argvSum + PAGE_SIZE, PAGE_SIZE);
	char *argPos = (char*) USER_ESP_BEG - setArg->argSum;
	int i;

	setArg->argvSum = ROUNDUP(setArg->argvSum, sizeof(char*));
	pargv = (char**) (setArg->pstack[setArg->argvSum / PAGE_SIZE] + PAGE_SIZE - (setArg->argvSum % PAGE_SIZE));

	for (i = 0; setArg->argv[i] != NULL; ++i);

	for (; 0 <= i; --i) {
		int strSize;

		setArg->argvSum += sizeof(char*);
		if (argvLimit < setArg->argvSum) {
			pargv = (char**) (setArg->pstack[argvLimit / PAGE_SIZE] + PAGE_SIZE);
			argvLimit += PAGE_SIZE;
		}
		--pargv;

		if (setArg->argv[i] == NULL) {
			*pargv = NULL;
			continue;
		}
		
		// ʸΥԡ
		strSize = strlen(setArg->argv[i]) + 1;
		setArg->argSum += strSize;
		while (argLimit < setArg->argSum) {
			int len = strSize - (setArg->argSum - argLimit);
			parg -= len;
			memcpy(parg, setArg->argv[i] + (setArg->argSum - argLimit), len);

			parg = (char*) setArg->pstack[argLimit / PAGE_SIZE] + PAGE_SIZE;
			argLimit += PAGE_SIZE;
			strSize -= len;
			argPos -= len;
		}
		parg -= strSize;
		argPos -= strSize;
		memcpy(parg, setArg->argv[i], strSize);
		*pargv = argPos;
	}
}

/*
 * ʸХȿ򻻽Ф
 * return : argv󥫥ȡNULLǴޤ
 */
static int calcArgSize(
	char **argv,	// ץ
	uint *o_total)	// ʸХȿ
{
	uint total = 0;
	int cnt;

	for (cnt = 0; argv[cnt] != NULL; ++cnt) {
		total += strlen(argv[cnt]) + 1;
	}
	*o_total = total;
	return cnt + 1;
}

//===================================== PUBLIC =====================================================

/*
 * ۥ꡼ƥν
 * error number
 */
int VmInit()
{
#ifdef DEBUG
	if (sizeof(VmProc) != sizeof(VmProcObj)) {
		printk("VmInit() object size error! VmProc=%d VmProcObj=%d\n", sizeof(VmProc), sizeof(VmProcObj));
		idle();
	}
	if (sizeof(VmTask) != sizeof(VmTaskObj)) {
		printk("VmInit() object size error! VmTask=%d VmTaskObj=%d\n", sizeof(VmTask), sizeof(VmTaskObj));
		idle();
	}
#endif

	return creatFlatPageDir();
}

//--------------------------------------------------------------------------------------------------
// ۥ꡼
//--------------------------------------------------------------------------------------------------

/*
 * ۥץ¤Τꤹ
 */
void initVmProc(
	VmProcObj *m_vmProc)
{
	VmProc *vmProc = (VmProc*) m_vmProc;

	vmProcConstructor(vmProc);
	vmProc->stackFirst = USER_ESP_BEG;
}

/*
 * CPUȤ˲ۥ꡼򳫻Ϥ롣
 *initVmProc()ƤӽФѤǤ뤳
 * return : error number
 */
int createVm(
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	uint *pageDir;
	AllocPage allocPageArg;
	int error;
	int i;

	error = vmTaskConstructor(vmTask);
	if (error != NOERR) {
		return error;
	}
	pageDir = vmTask->pageDir;

	// ͥǡڡǥ쥯ȥ
	for (i = 0; i < KERNEL_DATA_END / PAGE_DIR_SIZE; ++i) {
		set4mPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ͥ륹åγ
	allocPageArg.pageDir = pageDir;
	allocPageArg.setPageDirEnt = setRwPageDirEntry;
	allocPageArg.setPageEnt = setRwPageEntry;
	error = scanPage(KERNEL_STACK_END - PAGE_SIZE, KERNEL_STACK_END, allocPage, &allocPageArg);
	if (error != NOERR) {
		return error;
	}

	// ꡼ޥåץIOڡǥ쥯ȥ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		setIomapPageEntry(i * PAGE_DIR_SIZE, &pageDir[i]);
	}

	// ۥץ¤ΤϿ
	vmTask->vmProc = vmProc;
	vmProc->aggrMethod.insertHead(&vmProc->aggrVmTask, &vmTask->list);

	// ڡ󥰳
	enablePaging(pageDir);

	return NOERR;
}

/*
 * ƥץβۥץ¤Τ򥳥ԡ
 */
void vmProcFork(
	VmProcObj *i_dstVmProc,
	VmProcObj *i_srcVmProc)
{
	VmProc *dstVmProc = (VmProc*) i_dstVmProc;
	VmProc *srcVmProc = (VmProc*) i_srcVmProc;

	vmProcConstructor(dstVmProc);
	dstVmProc->readFirst = srcVmProc->readFirst;
	dstVmProc->readLast = srcVmProc->readLast;
	dstVmProc->writeFirst = srcVmProc->writeFirst;
	dstVmProc->writeLast = srcVmProc->writeLast;
	dstVmProc->stackFirst = srcVmProc->stackFirst;
}

/*
 * ƥץΥ꡼ƥȤ򥳥ԡ
 *պǽΥåɺvmProcFork()ƤӽФѤǤ뤳
 *ԳԲġ
 * return : error number or 1 = 
 */
int vmFork(
	const int isKernelThread,			// ͥ륹åɤȤ"0"ʳ
	VmTaskObj *m_vmTaskmParent,
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc)
{
	VmTask *vmTaskmParent = (VmTask*) m_vmTaskmParent;
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	uint *pageDirParent = vmTaskmParent->pageDir;
	uint *pageDir;
	AllocPage allocPageArg;
	int i;
	int error;

	error = vmTaskConstructor(vmTask);
	if (error != NOERR) {
		return error;
	}
	pageDir = vmTask->pageDir;

	// ۥ꡼¤Τե
	error = vmTaskFork(vmTask, vmTaskmParent);
	if (error != NOERR) {
		return error;
	}

	// ͥǡڡǥ쥯ȥ򥳥ԡ
	for (i = 0; i < KERNEL_DATA_END / PAGE_DIR_SIZE; ++i) {
		pageDir[i] = pageDirParent[i];
	}

	// ꡼ޥåץIOڡǥ쥯ȥ򥳥ԡ
	for (i = IOMAP_BEG / PAGE_DIR_SIZE; i < PAGE_SIZE / sizeof(uint); ++i) {
		pageDir[i] = pageDirParent[i];
	}

	// ͥ륹åγ
	allocPageArg.pageDir = pageDir;
	allocPageArg.setPageDirEnt = setRwPageDirEntry;
	allocPageArg.setPageEnt = setRwPageEntry;
	error = scanPage(KERNEL_STACK_END - PAGE_SIZE, KERNEL_STACK_END, allocPage, &allocPageArg);
	if (error != NOERR) {
		goto ERR1;
	}

	// 桼ΰʪ꡼˥Ǥ褦եåȥ꡼۴Ķ˰ܹ
	switchFlatPageDir(vmTaskmParent);

	if (isKernelThread != 0) {
		/*
		 * 桼ۥ꡼ΰϻѤʤ
		 */
		vmProc->readFirst =  0;
		vmProc->readLast = 0;
		vmProc->writeFirst =  0;
		vmProc->writeLast = 0;
		vmProc->stackFirst = USER_ESP_BEG;
	}
	else {
		CopyPage copyPageArg;

		if (vmProc->aggrMethod.getCount(&vmProc->aggrVmTask) == 0) {
			// 桼ƥȥǡ򥳥ԡ饤Ȥꤹ
			CopyOnWritePage copyOnWritePageArg;
			copyOnWritePageArg.dstPageDir = pageDir;
			copyOnWritePageArg.srcPageDir = pageDirParent;
			error = scanPage(vmProc->readFirst, vmProc->writeLast, copyOnWritePage, &copyOnWritePageArg);
			if (error != NOERR) {
				goto ERR1;
			}
		}
		else {
			// ¾åɤΥڡǥ쥯ȥ򥳥ԡ
			int last = ROUNDUP_DIV(vmProc->writeLast, PAGE_DIR_SIZE);
			for (i = USER_BEG / PAGE_DIR_SIZE; i < last; ++i) {
				if (pageDirParent[i] != 0) {
					void *physMem = getPhysMemFromEntry(pageDirParent[i]);
					linkPhysTable(physMem);
					pageDir[i] = pageDirParent[i];
				}
			}
		}

		// 桼å򥿥Ȥ˳Ƥ
		allocPageArg.pageDir = pageDir;
		allocPageArg.setPageDirEnt = setUserRwPageDirEntry;
		allocPageArg.setPageEnt = setUserRwPageEntry;
		error = scanPage(vmProc->stackFirst, USER_ESP_BEG, allocPage, &allocPageArg);
		if (error != NOERR) {
			goto ERR3;
		}
		
		copyPageArg.dstPageDir = pageDir;
		copyPageArg.srcPageDir = pageDirParent;
		error = scanPage(vmProc->stackFirst, USER_ESP_BEG, copyPage, &copyPageArg);
		if (error != NOERR) {
			goto  ERR3;
		}
	}
	
	// ͥ륹å˥ƥȤ
	{
		void *stack = getPhysMemFromEntry(*getPageEntryAddr(KERNEL_STACK_END - PAGE_SIZE, pageDir));
		if (setChildContext(stack) == YES) {
			// ¹Գ
			return 1;
		}
	}

	// ۥץ¤ΤϿ
	vmTask->vmProc = vmProc;
	vmProc->aggrMethod.insertHead(&vmProc->aggrVmTask, &vmTask->list);

	// եåȥ꡼۴Ķꡢƥڡǥ쥯ȥ򹹿
	restorePageDir(vmTaskmParent);

	return NOERR;
ERR3:
	{
		ReleasePage releasePageArg;

		releasePageArg.pageDir = pageDir;
		scanPage(vmProc->stackFirst, USER_ESP_BEG, releasePage, &releasePageArg);
		if (vmProc->aggrMethod.getCount(&vmProc->aggrVmTask) == 0) {
			scanPage(vmProc->readFirst, vmProc->writeLast, releasePage, &releasePageArg);
		}
ERR1:
		releasePageArg.pageDir = pageDir;
		scanPage(KERNEL_STACK_BEG, KERNEL_STACK_END, releasePage, &releasePageArg);
		unlinkPhysTable(pageDir);
	}

	return error;
}

/*
 * ¹ԥե꡼˥ɤ
 * EXEC_FDݥ󥿤NULLʤ꡼0ꥢ롣
 *ԳԲġ
 * return : error number
 */
int loadBinary(
	VmTaskObj *vmTask,
	VmProcObj *m_vmProc,
	EXEC_FD *open_f,		// EXEC_FDݥ
	size_t size,			// ƥХȿ
	size_t load_size,		// ɥХȿ
	uint i_firstAddr,		// ɳϲۥɥ쥹
	int attribute)			// ڡ°ɹߤΤ=LB_R,ɤ߽=LB_WR
{
	uint *pageDir = ((VmTask*) vmTask)->pageDir;
	VmProc *vmProc = (VmProc*) m_vmProc;
	uint *pageEnt;
	uint addr,last;
	AllocPage allocPageArg;
	int error;

	last = i_firstAddr + size;

	// ɥʬ꡼Ƥ
	allocPageArg.pageDir = pageDir;
	allocPageArg.setPageDirEnt = setUserRwPageDirEntry;
	allocPageArg.setPageEnt = setUserRwPageEntry;
	error = scanPage(i_firstAddr, last, allocPage, &allocPageArg);
	if (error != NOERR) {
		goto ERR;
	}

	// ե뤫꡼ɤ߹
	updatePageDir(pageDir);
	error = exec_read(open_f, (void*) i_firstAddr, load_size);
	if (error != load_size) {
		if (0 <= error) {
			error = -EIO;
		}
		goto ERR;
	}

	// ե뤫ɤ߹ʬʹߤΥ꡼ϥꥢ
	memset((char*) i_firstAddr + load_size, 0, size - load_size);

	// ڡ°ɹߤʤꤷľ
	if (attribute == LB_R) {
		for (addr = i_firstAddr; addr < last; addr += PAGE_SIZE) {
			pageEnt = getPageEntryAddr(addr, pageDir);
			setUserReadPageEntry(getPhysMemFromEntry(*pageEnt), pageEnt);
		}
		updatePageDir(pageDir);
	}

	// ڡϡλɥ쥹򹹿
	if (attribute == LB_R) {
		if ((vmProc->readFirst == 0) || (i_firstAddr < vmProc->readFirst)) {
			vmProc->readFirst = ROUNDDOWN(i_firstAddr, PAGE_SIZE);
		}
		if (vmProc->readLast < last) {
			vmProc->readLast = ROUNDUP(last, PAGE_SIZE);
		}
	}
	else {
		if ((vmProc->writeFirst == 0) || (i_firstAddr < vmProc->writeFirst)) {
			vmProc->writeFirst = ROUNDDOWN(i_firstAddr, PAGE_SIZE);
		}
		if (vmProc->writeLast < last) {
			vmProc->writeLast = ROUNDUP(last, PAGE_SIZE);
		}
		
		// ߲ΰϽԲΰˤʤ
		if (vmProc->writeFirst < vmProc->readLast) {
			return -ENOEXEC;
		}
	}

	error = NOERR;
ERR:
	return error;
}

/*
 * βۥ꡼Ķ
 */
void releaseVmTask(
	VmTaskObj *m_vmTask,
	VmProcObj *i_vmProc)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) i_vmProc;
	uint *pageDir = vmTask->pageDir;

	enter_spinlock(&vmProc->spinLock);
	{
		ReleasePage releasePageArg;
		releasePageArg.pageDir = pageDir;

		// 桼ƥȡǡڡ롣
		scanPage(vmProc->readFirst, vmProc->writeLast, releasePage, &releasePageArg);

		// 桼å롣
		scanPage(vmProc->stackFirst, USER_END, releasePage, &releasePageArg);

		// ɥ饤СDMAڡ롣
		scanPage(DRIVER_DMA_BEG, DRIVER_DMA_END, releasePage, &releasePageArg);

		// ͥ륹åڡ롣
		scanPage(KERNEL_STACK_BEG, KERNEL_STACK_END, releasePage, &releasePageArg);

		unlinkPhysTable(pageDir);

		vmProc->aggrMethod.removeEntry(&vmProc->aggrVmTask, &vmTask->list);
	}
	exit_spinlock(&vmProc->spinLock);
	
	freeUserMethodStack(vmTask);
}

/*
 * 桼ΥƥȤȥǡڡ롣
 *exec˸ƤФ
 */
void releaseUserPage(
	VmTaskObj *i_vmTask,
	VmProcObj *i_vmProc)
{
	VmTask *vmTask = (VmTask*) i_vmTask;
	VmProc *vmProc = (VmProc*) i_vmProc;
	ReleasePage releasePageArg;

	releasePageArg.pageDir = vmTask->pageDir;
	scanPage(vmProc->readFirst, vmProc->writeLast, releasePage, &releasePageArg);

	// ͭۥɥ쥹ΰ
	vmProc->readFirst =  0;
	vmProc->readLast = 0;
	vmProc->writeFirst =  0;
	vmProc->writeLast = 0;
}

/*
 * 桼åꤹ
 *Իեڡǥ쥯ȥιɬ
 * return : error number
 */
int setArgEnv(
	VmTaskObj *i_vmTask,
	char **argv,
	char **envp,
	uint *o_stackAddr)
{
	/*
	 * 桼å
	 *  ĶѿʸNULLü
	 *  
	 *  ʸNULLü
	 *  
	 *  ĶѿݥʺǸNULL)
	 *  ݥʺǸNULL)
	 *  Ķѿݥ󥢥ɥ쥹
	 *  ݥ󥢥ɥ쥹
	 *  
	 *  ꥿󥢥ɥ쥹
	 */
	int argc;			// 
	int argv_total;		// Ķѿݥ
	uint arg_total;		// ĶѿץХȿ
	uint stack_total;	// Ķѿ꥿󥢥ɥ쥹Хȿ
	int stack_cnt;		// å꡼
	char **pstack;		// å꡼ݥ
	uint argvStart;		// ݥ󳫻ϥեå
	uint envpStart;		// Ķѿݥ󳫻ϥեå
	int error;

	// ץ򻻽
	{
		uint total;

		argv_total = calcArgSize(argv, &total);
		argc = argv_total - 1;
		arg_total = total;
		argv_total += calcArgSize(envp, &total);
		arg_total += total;
		if (ARG_MAX < arg_total) {
			return -E2BIG;
		}
	}
	
	// åƤ
	{
		int i;

		stack_total = ROUNDUP(arg_total + sizeof(char*) * argv_total + sizeof(char**) * 2 + sizeof(int) + sizeof(void*), sizeof(void*));
		stack_cnt = ROUNDUP_DIV(stack_total, PAGE_SIZE);
		pstack = kmalloc(sizeof(void*) * stack_cnt);
		for (i = 0; i < stack_cnt; ++i) {
			pstack[i] = allocUserPage();
			if (pstack[i] == NULL) {
				for (i -= 1; 0 <= i; --i) {
					unlinkPhysTable(pstack[i]);
				}
				return -ENOMEM;
			}
		}
	}

	// 򥹥å꡼
	{
		SetStackArg setArg;

		setArg.argv = envp;
		setArg.pstack = (void**) pstack;
		setArg.argSum = 0;
		setArg.argvSum = arg_total;
		setStackArg(&setArg);
		envpStart = setArg.argvSum;

		setArg.argv = argv;
		setStackArg(&setArg);
		argvStart = setArg.argvSum;
	}

	// 桼ץϤ
	{
		uint argArra[] = {argc, USER_ESP_BEG - argvStart, USER_ESP_BEG - envpStart};
		int stackArra = argvStart / PAGE_SIZE;
		uint *parg = (uint*) (pstack[stackArra] + PAGE_SIZE - (argvStart % PAGE_SIZE));
		int i;
		
		for (i = 2; 0 <= i; --i) {
			if (parg == (uint*) pstack[stackArra]) {
				parg = (uint*) (pstack[++stackArra] + PAGE_SIZE);
			}
			--parg;
			*parg = argArra[i];
		}
	}

	// åޥå
	{
		VmTask *vmTask = (VmTask*) i_vmTask;
		VmProc *vmProc = vmTask->vmProc;
		ReleasePage releasePageArg;
		MapUserStack mapUserStackArg;

		releasePageArg.pageDir = vmTask->pageDir;
		scanPage(vmProc->stackFirst, USER_ESP_BEG, releasePage, &releasePageArg);

		mapUserStackArg.pageDir = vmTask->pageDir;
		mapUserStackArg.pphysMem = (void**) &pstack[stack_cnt - 1];
		error = scanPage(USER_ESP_BEG - (PAGE_SIZE * stack_cnt), USER_ESP_BEG, mapUserStack, &mapUserStackArg);
		if (error != NOERR) {
			goto END;
		}
		
		vmProc->stackFirst = USER_ESP_BEG - (PAGE_SIZE * stack_cnt);
	}

	*o_stackAddr = USER_ESP_BEG - stack_total;

	setUserStackPoint(USER_ESP_BEG - stack_total);
END:
	kfree(pstack);
	return error;
}

/*
 * ڡե
 * todo
 *  桼åڡԺߤνθľ(¤ߤ)
 *ԳԲġ
 */
void pageFault(
	VmTaskObj *m_vmTask,
	VmProcObj *m_vmProc,
	const uint i_faultAddr,
	TaskContext *i_frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN		= 1,
		PAGE_WRITE	= 2,
		USER_MODE	= 4,
		RSVBIT		= 8,
	};
	VmTask *vmTask = (VmTask*) m_vmTask;
	VmProc *vmProc = (VmProc*) m_vmProc;
	int error;
	
	// ڡȥͽӥå㳰
	if (i_frame->error & RSVBIT) {
		printk("\nPage entry reserve bit vioration!\n");
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}

	// ꡼ȿΥå
	if (isCorrectAccess(vmProc, i_faultAddr, i_faultAddr + 1) == ERR) {
		printk("\nPage privilege violation! Fault Address = 0x%x\n", i_faultAddr);
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}

	// ڡԺ
	if ((i_frame->error & PRESEN) == 0) {
		// ڡȥ꡼˥ڡ꡼Ƥ
		enter_spinlock(&vmProc->spinLock);
		{
			error = allocPageMem(i_faultAddr, vmTask, vmProc);
		}
		exit_spinlock(&vmProc->spinLock);
		if (error == NOERR) {
			if ((vmProc->stackFirst - PAGE_SIZE * 2 <= i_faultAddr) && (i_faultAddr < vmProc->stackFirst)) {
				vmProc->stackFirst = ROUNDDOWN(i_faultAddr, PAGE_SIZE);
			}
			updatePageDir(vmTask->pageDir);
		}
		else {
			printk("\nallocPageMem() error! : %d ", error);
			forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		}
		return;
	}

	// ԡ饤
	if (isCopyOnWritePage(vmTask->pageDir, i_faultAddr) == YES) {
		// ԡ饤ȤΥڡȥ꡼˥ڡ꡼Ƥ
		error = resetCopyOnWritePage(vmTask->pageDir, i_faultAddr);
		if (error == NOERR) {
			updatePageDir(vmTask->pageDir);
		}
		else {
			WARNING(0);
			forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		}
		return;
	}

	// ڡ񤭹߰ȿ
	if (i_frame->error & PAGE_WRITE) {
		printk("\nRead only page violation! Fault Address = 0x%x\n", i_faultAddr);
		printContext(i_frame);
		forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
		return;
	}
	
	// ڡȿ
	printk("\nUnknown page violation! Fault Address = 0x%x\n", i_faultAddr);
	printContext(i_frame);
	forceSendSignal(TaskGetTaskSignal(getCurrentTask()), SIGSEGV);
	return;
}

//--------------------------------------------------------------------------------------------------
// 桼ϥɥ饹å
//--------------------------------------------------------------------------------------------------

/*
 * ⥸塼ڡǥ쥯ȥꥨȥ꡼¤
 */
typedef struct {
	uint entry[(DRIVER_END - DRIVER_BEG) / PAGE_DIR_SIZE];
} ModuleDirEnt;

/*
 * ʥϥɥѥͥ륹åƤ
 * return : error number
 */
int vmCreatSignalHandlerStack(
	VmTaskObj *m_vmTask)
{
	VmTask *vmTask = (VmTask*) m_vmTask;
	return allocUserSignalHandlerStack(vmTask);
}

/*
 * ʥϥɥѥͥ륹åѤ
 *ճ߶ػߤǸƤӽФ뤳
 * return : Page directory
 */
void *vmChangeSignalHandlerStack()
{
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	uint *kernStackEnt = getPageEntryAddr(KERNEL_ESP_BEG, vmTask->pageDir);
	void *kernPhysMem = getPhysMemFromEntry(*kernStackEnt);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(kernStackEnt, vmTask->sigHandleKernStack);
	vmTask->sigHandleKernStack = kernPhysMem;

	return vmTask->pageDir;
}

/*
 * ⥸塼ƤӽФѥͥ륹åѤ
 *ճ߶ػߤǸƤӽФ뤳
 * return : Page directory
 */
void *vmChangeKernelStack()
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());
	uint *entry = getPageEntryAddr(KERNEL_ESP_BEG, this->pageDir);
	void *physMem = getPhysMemFromEntry(*entry);

	ASSERT(this->kernStack != NULL);

	// åڡȥ꡼꡼촹
	setPhysMemEntry(entry, this->kernStack);
	this->kernStack = physMem;

	return this->pageDir;
}

/*
 * ⥸塼ڡIOޥåץڡꤹ
 */
void vmSetModuleCall(
	VmTaskObj *moduleVmTaskObj)
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());
	VmTask *module = (VmTask*) moduleVmTaskObj;
	int c_dir;

	// ⥸塼ڡǥ쥯ȥ򥻥åȤ
	for (c_dir = DRIVER_BEG / PAGE_DIR_SIZE; c_dir < DRIVER_END / PAGE_DIR_SIZE; ++c_dir) {
		this->saveModuleDirEnt[c_dir - (DRIVER_BEG / PAGE_DIR_SIZE)] = this->pageDir[c_dir];
		this->pageDir[c_dir] = module->pageDir[c_dir];
	}
	
	// IOޥåץڡǥ쥯ȥ򥻥åȤ
	this->savePageDirEnt = this->pageDir[module->iomapPageDirIdx];
	this->pageDir[module->iomapPageDirIdx] = module->pageDir[module->iomapPageDirIdx];
	this->iomapPageDirIdx = module->iomapPageDirIdx;
}

/*
 * ⥸塼ڡIOޥåץڡ򸵤᤹
 *աոƤӽФä塢桼ץ˲۴Ķ򹹿뤳
 */
void vmResetModuleCall()
{
	VmTask *this = (VmTask*) getVmTask(getCurrentTask());
	int c_dir;

	// ⥸塼ڡǥ쥯ȥꥻåȤ
	for (c_dir = DRIVER_BEG / PAGE_DIR_SIZE; c_dir < DRIVER_END / PAGE_DIR_SIZE; ++c_dir) {
		this->pageDir[c_dir] = this->saveModuleDirEnt[c_dir - (DRIVER_BEG / PAGE_DIR_SIZE)];
	}
	
	// IOޥåץڡǥ쥯ȥꥻåȤ
	this->pageDir[this->iomapPageDirIdx] = this->savePageDirEnt;
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

/*
 * ڡǥ쥯ȥꥢɥ쥹
 * return : ڡǥ쥯ȥꥢɥ쥹
 */
uint *getPageDir(
	VmTaskObj *i_vmTask)
{
	VmTask *vmTask = (VmTask*) i_vmTask;
	return vmTask->pageDir;
}

/*
 * 桼ΰ衦ͥ륹åɥ쥹ʪɥ쥹
 * return : ʪɥ쥹 or 0
 */
uint getPhysicalFromLogicalAddr(
	VmTaskObj *i_vmTask,
	const uint logicalAddr)
{
	uint *pageTbl = getPhysMemFromEntry(((VmTask*) i_vmTask)->pageDir[logicalAddr / PAGE_DIR_SIZE]);
	
	if (pageTbl != NULL) {
		uint pageEnt = pageTbl[(logicalAddr % PAGE_DIR_SIZE) / PAGE_SIZE];

		return (uint) getPhysMemFromEntry(pageEnt) + (logicalAddr & (PAGE_SIZE - 1));
	}
	else {
		return 0;
	}
}

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

/*
 * ɹ߲ǽ
 * return : NOERR or ERR
 */
int vmIsReadArea(
	VmProcObj*i_vmProc,
	const void *i_virtAddr,		// ꡼ɥ쥹
	uint i_bytes)				// ꡼
{
	VmProc *vmProc = (VmProc*) i_vmProc;
	uint firstAddr = (uint) i_virtAddr;

	return isCorrectAccess(vmProc, firstAddr, firstAddr + i_bytes);
}

/*
 * ߲ǽ
 * return : NOERR or ERR
 */
int vmIsWriteArea(
	VmProcObj*i_vmProc,
	const void *i_virtAddr,		// ꡼ɥ쥹
	uint i_bytes)				// ꡼
{
	VmProc *vmProc = (VmProc*) i_vmProc;
	uint firstAddr = (uint) i_virtAddr;
	uint lastAddr = firstAddr + i_bytes;

	if ((vmProc->writeFirst <= firstAddr) && (lastAddr <= vmProc->writeLast)) {
		return NOERR;
	}
	else if ((vmProc->stackFirst - PAGE_SIZE * 2 <= firstAddr) && (lastAddr < USER_ESP_BEG)) {
		return NOERR;
	}
	else {
		return ERR;
	}
}

//--------------------------------------------------------------------------------------------------
// ƥॳ
//--------------------------------------------------------------------------------------------------

/*
 * 桼ڡΥɥ쥹ޤǳƤ롣
 */
int sys_brk(
	uint addr)
{
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	VmProc *vmProc = vmTask->vmProc;

	enter_spinlock(&vmProc->spinLock);
	{
		if ((vmProc->writeLast <= addr) && (addr < vmProc->stackFirst)) {
			vmProc->writeLast = ROUNDUP(addr, PAGE_SIZE);
		}
	}
	exit_spinlock(&vmProc->spinLock);

	return 0;
}

/*
 * Ƥɥ쥹κǸ
 */
int sys_getLastAddr(
	uint *o_linearAddr)
{
	*o_linearAddr = ((VmProc*) getVmProc(getCurrentProc()))->writeLast;
	return NOERR;
}

/*
 * IOΰ桼PAGE_SIZEñ̤ǥǽˤ롣
 */
int sysSetUserIoAccess(
	const uint kernAddr,
	const uint size)
{
	uint *pageDir;
	VmTask *vmTask;
	uint *pageTbl;
	uint base;
	int end;
	int c_dir;

	if (size == 0) {
		return NOERR;
	}

	// ͥ롦IOޥåΰʳԲ
	if ((KERNEL_END <= kernAddr) && (kernAddr < IOMAP_BEG)) {
		return -EFAULT;
	}
	
	// ڡǥ쥯ȥϰϤĶԲ
	if ((kernAddr + size < kernAddr)
	 || (ROUNDDOWN(kernAddr, PAGE_DIR_SIZE) + PAGE_DIR_SIZE != ROUNDUP(kernAddr + size, PAGE_DIR_SIZE))) {
		return -EFAULT;
	}
	
	vmTask = (VmTask*) getVmTask(getCurrentTask());
	pageDir = vmTask->pageDir;

	// եåȲۥ꡼Ķѹ
	switchFlatPageDir(vmTask);
	
	/*
	 * ڡơ֥ꤹ
	 */
	pageTbl = allocUserPage();
	if (pageTbl == NULL) {
		restorePageDir(vmTask);
		return -ENOMEM;
	}
	
	base = ROUNDDOWN(kernAddr, PAGE_DIR_SIZE);
	for (c_dir = 0; c_dir < PAGE_SIZE / sizeof(uint); ++c_dir) {
		setRwPageEntry((char*) base + (PAGE_SIZE * c_dir), &pageTbl[c_dir]);
	}

	// 桼IOMAPڡȥ꡼
	end = ROUNDUP_DIV((kernAddr + size) & (PAGE_DIR_SIZE - 1), PAGE_SIZE);
	for (c_dir = (kernAddr & (PAGE_DIR_SIZE - 1)) / PAGE_SIZE; c_dir < end; ++c_dir) {
		setUserIomapPageEntry(base + (PAGE_SIZE * c_dir), &pageTbl[c_dir]);
	}
	setUserRwPageDirEntry(pageTbl, &pageDir[kernAddr / PAGE_DIR_SIZE]);

	// 桼IOMAPڡǥ쥯ȥꥤǥå¸
	vmTask->iomapPageDirIdx = kernAddr / PAGE_DIR_SIZE;

	restorePageDir(vmTask);
	
	return NOERR;
}

/*
 * ʬХȶƤ롣Ƥ꡼ϣ˥Хȶޤʤ
 */
int sysAllocDmaMemory(
	const uint size,
	uint *o_physAddr,		// ʪɥ쥹
	uint *o_linearAddr)		// ɥ쥹
{
	enum {
		START_BOUND	= 4,		// Хȶ
		BOUNDARY	= 0x10000,	// ˥ХȶATADMAơ֥ϣ˥Хȶޤʤ
	};
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	VmProc *vmProc = vmTask->vmProc;
	uint startAddr;			// DMA꡼Ƭɥ쥹

	if (size == 0) {
		*o_linearAddr = 0;
		return 0;
	}
	if (BOUNDARY < size) {
		return -EOVERFLOW;
	}
	
	enter_spinlock(&vmProc->spinLock);
	{
		// Ƭɥ쥹λ
		startAddr = ROUNDUP(vmProc->dmaAllocAddr, START_BOUND);
		if (ROUNDUP(startAddr + 1, BOUNDARY) < startAddr + size) {
			startAddr = ROUNDUP(startAddr + 1, BOUNDARY);
		}
		if (DRIVER_DMA_END <= startAddr) {
			return -ENOMEM;
		}

		// DMAڡ˥꡼Ƥ
		{
			AllocPage allocPageArg;
			int error;

			allocPageArg.pageDir = vmTask->pageDir;
			allocPageArg.setPageDirEnt = setUserRwPageDirEntry;
			allocPageArg.setPageEnt = setUserRwPageEntry;
			error = scanPage(startAddr, startAddr + size, allocPage, &allocPageArg);
			if (error != NOERR) {
				return error;
			}
			vmProc->dmaAllocAddr = startAddr + size;
		}
	}
	exit_spinlock(&vmProc->spinLock);

	*o_physAddr = getPhysicalFromLogicalAddr((VmTaskObj*) vmTask, startAddr);
	*o_linearAddr = startAddr;

	return NOERR;
}

/*
 * DMA꡼
 */
/*
int sysFreeDmaMemory(
	const uint linearAddr,
	const uint size)
{
	VmTask *vmTask = (VmTask*) getVmTask(getCurrentTask());
	ReleasePage releasePageArg;

	releasePageArg.pageDir = vmTask->pageDir;
	scanPage(linearAddr, linearAddr + size, releasePage, &releasePageArg);

	return NOERR;
}
*/
//**************************************************************************************************

#ifdef DEBUG
void test_vm(
	uint *pageDir,
	uint startAddr)
{
	static uint *addr = NULL;
	uint *entry = getPageEntryAddr(startAddr, pageDir);
	if (addr != entry) {
		addr = entry;
	}
	else {
		return;
	}
	
	if (setDebug((uint) entry, DEBUG_WRITE | DEBUG_4BYTE) == ERR) {
		printk("setDebug error!\n");
		idle();
	}
}
#endif
