/*
 * vm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 */

#ifndef vm_h
#define vm_h

#include <sys/types.h>
#include <machine/Entry.h>
#include <machine/vm.h>
#include <machine/DevInterrupt.h>
#include <kern/fs.h>

#ifndef ASM_FILE

enum{
	// loadBinary() flag.
	LB_R	= 1,
	LB_WR	= 2,
};

/*
 * ۥ꡼¤
 *԰¸VmTaskΥƱ
 */
typedef struct {
	char dummy[116];
} VmProcObj;

typedef struct {
	char dummy[56];
} VmTaskObj;

extern int VmInit();
extern void initVmProc(VmProcObj*);
extern int createVm(VmTaskObj*, VmProcObj*);
extern void vmProcFork(VmProcObj*, VmProcObj*);
extern int vmFork(const int, VmTaskObj*, VmTaskObj*, VmProcObj*);
extern int loadBinary(VmTaskObj*, VmProcObj*, EXEC_FD*, size_t, size_t, uint, int);
extern int setArgEnv(VmTaskObj*, char**, char**, uint*);
extern void releaseUserPage(VmTaskObj*, VmProcObj*);
extern void releaseVmTask(VmTaskObj*, VmProcObj*);
extern void pageFault(VmTaskObj*, VmProcObj*, const uint, TaskContext*);
extern int vmIsReadArea(VmProcObj*, const void*, uint);
extern int vmIsWriteArea(VmProcObj*, const void*, uint);
extern int vmCreatSignalHandlerStack(VmTaskObj*);
extern void *vmChangeSignalHandlerStack();
extern void *vmChangeKernelStack();
extern uint *vmSetModule(VmTaskObj*);
extern uint *vmResetModule();
extern uint vmSetModuleParam(VmTaskObj*, const void*, uint, uint, uint, uint, uint, uint);
extern void vmSetModuleCall(VmTaskObj*);
extern void vmResetModuleCall();
extern uint *getPageDir(VmTaskObj*);
extern uint getPhysicalFromLogicalAddr(VmTaskObj*, const uint);

extern int sys_brk();
extern int sys_getLastAddr();
extern int sysSetUserIoAccess();

#endif	// ASM_FILE

#endif
