/*
 * AggregateCircle.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * Iteratorѥν۴ĥꥹ
 *
 *
 * Ǥ¾ϸƤӽФ¦ǤԤȡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/object.h>
#include <lib/IteratorList.h>
#include <lib/AggregateList.h>

#include <kern/debug.h>


//#define DEBUG_AGGREGATE_CIRCLE 1
#ifdef DEBUG_AGGREGATE_CIRCLE
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

/*
 * ³Ǥμ³
 */
STATIC INLINE void addNext(
	List *dst,
	List *src)
{
	src->next = dst->next;
	src->prev = dst;
	src->next->prev = src;
	dst->next = src;
}

/*
 * ³Ǥ³
 */
STATIC INLINE void addPrev(
	List *dst,		// ³ꥹȥСݥ
	List *src)		// ³ꥹȥСݥ
{
	src->next = dst;
	src->prev = dst->prev;
	dst->prev->next = src;
	dst->prev = src;
}

/*
 * ꥹȤ
 */
STATIC INLINE void erase(
	List *src)
{
	src->prev->next = src->next;	// nextǽѤ
	src->next->prev = src->prev;
	src->next =  NULL;
	src->prev = NULL;
}

//================================== PUBLIC =============================================

/*
 * ꥹȥإå³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertHead(
	AggregateList *this,
	List *m_list)
{
	if (this->head == NULL) {
		m_list->next = m_list->prev = m_list;
		this->head = m_list;
	}
	else {
		addPrev(this->head, m_list);
		this->head = m_list;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼μ³
 */
STATIC void insertNext(
	AggregateList *this,
	List *m_dst,				// ³ȥ꡼
	List *m_src)
{
	/*
	 * ۴ĤϤ줿ȥ꡼μˤ³Ǥ褦ˤ
	 */
//	List *prev = m_dst->next->prev;
	
//	addNext(prev, m_src);
//	m_dst->next = m_src;
	addNext(m_dst, m_src);
	this->count += 1;
}

/*
 * ꥹȥȥ꡼³
 */
STATIC void insertPrev(
	AggregateList *this,
	List *m_dst,				// ³ȥ꡼
	List *m_src)
{
	// ³ꥹȥȥ꡼ϽƤ뤳
	addPrev(m_dst, m_src);
	this->count += 1;
}

/*
 * ꥹȥȥ꡼
 *Իեȥ꡼إåʤإåϼΥȥ꡼˰ܤ
 */
STATIC void removeEntry(
	AggregateList *this,
	List *m_list)
{
	// ȥ꡼³Ƥ뤳
	ASSERT(m_list != NULL);

	if (this->head == m_list) {
		if (m_list->next == m_list) {
			this->head = NULL;
		}
		else {
			this->head = m_list->next;
		}
	}
	erase(m_list);
	this->count -= 1;
}

/*
 * إåɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		List *headEntry = this->head;
		removeEntry(this, headEntry);

		return headEntry->object;
	}
	else {
		return NULL;
	}
}

/*
 * إåɥȥ꡼򻲾
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		return this->head->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refNext(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	return i_dst->next->object;
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refPrev(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	return i_dst->prev->object;
}

/*
 * إåλؤȥ꡼򼡤Υȥ꡼˰ܤ
 */
void pointHeadNext(
	AggregateList *this)
{
	ASSERT(this->head != NULL);
	
	this->head = this->head->next;
}

/*
 * ȥ꡼Υȥ꡼˻ؤȥ꡼򡢳ȥ꡼μΥȥ꡼Ѥơ
 * ۴ĥꥹȤϤ
 */
void removeOut(
	AggregateList *this,
	List *m_list)
{
	m_list->prev->next = m_list->next;
	m_list->next->prev = m_list->prev;
	this->count -= 1;
}

/*
 * ꥹ³򻲾
 * return : 
 */
STATIC int getCount(
	AggregateList *this)
{
	return this->count;
}

/*
 * ꥹȤ˷ҤäƤ뤫
 * return : YES or NO
 */
STATIC int isLink(
	AggregateList *this,
	const List *dst)
{
	return (dst->next != NULL) ? YES : NO;
}

/*
 * ̤б
 */
STATIC void dummyFunc()
{
	printk("This operation not supported!\n");
	ASSERT(0);
}

//--------------------------------------------------------------------------------------------------
// ƥ졼ѥ᥽å
//--------------------------------------------------------------------------------------------------

/*
 * إåɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refHeadEntry(
	AggregateList *this)
{
	return this->head;
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refNextEntry(
	AggregateList *this,
	const List *i_dst)
{
	ASSERT(i_dst != NULL);

	if (i_dst->next != this->head) {
		return i_dst->next;
	}
	else {
		return NULL;
	}
}

//--------------------------------------------------------------------------------------------------
// 󥹥ȥ饯
//--------------------------------------------------------------------------------------------------

void AggregateCircleConstructor(
	AggregateList *this,
	AggregateListMethod *method)
{
	// 
	this->head = NULL;
	this->end = NULL;
	this->count = 0;

	method->insertHead = insertHead;
	method->insertEnd = (LIST_FUNC2) dummyFunc;
	method->insertNext = insertNext;
	method->insertPrev = insertPrev;
	method->removeEntry = removeEntry;
	method->getHead = getHead;
	method->getEnd = (LIST_FUNC1) dummyFunc;
//	method->getNext = getNext;
//	method->getPrev = getPrev;
	method->refHead = refHead;
	method->refEnd = (LIST_FUNC6) dummyFunc;
	method->refNext = refNext;
	method->refPrev = refPrev;
	method->pointHeadNext = pointHeadNext;
	method->removeOut = removeOut;
	method->refHeadList = refHeadEntry;
	method->refEndList = (LIST_FUNC10) dummyFunc;
	method->refNextList = refNextEntry;
	method->refPrevList = (LIST_FUNC11) dummyFunc;
	method->getCount = getCount;
	method->isLink = isLink;
}
