/*
 * AggregateList.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *ԳסIteratorѥListIteratorꥹꥹȤϽ۴ĤǤĤʤ롣
 *
 *չǤ¾ϸƤӽФ¦ǤԤȡ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/object.h>
#include <lib/IteratorList.h>
#include <lib/AggregateList.h>

#include <kern/debug.h>


//#define DEBUG_AGGREGATE_LIST 1
#ifdef DEBUG_AGGREGATE_LIST
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//================================== PRIVATE ============================================

/*
 * ³Ǥμ³
 */
STATIC INLINE void addNext(
	List *prev,
	List *src)
{
	List *next = prev->next;
	prev->next = src;
	src->prev = prev;
	src->next = next;
	next->prev = src;
}

/*
 * ³Ǥ³
 */
STATIC INLINE void addPrev(
	List *next,		// ³ꥹȥСݥ
	List *src)		// ³ꥹȥСݥ
{
	List *prev = next->prev;
	prev->next = src;
	src->prev = prev;
	src->next = next;
	next->prev = src;
}

/*
 * ꥹȤ
 */
STATIC INLINE void remove(
	List *src)
{
	List *prev = src->prev;
	List *next = src->next;
	prev->next = next;
	next->prev = prev;
	src->next = src->prev = NULL;
}

//===================================== PUBLIC =====================================================

/*
 * ꥹȥإå³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertHead(
	AggregateList *this,
	List *list)
{
	ASSERT(list != NULL);
	ASSERT((list->next == NULL) && (list->prev == NULL));

	if (this->head == NULL) {
		list->next = list->prev = list;
		this->head = list;
		this->end = list;
	}
	else {
		addPrev(this->head, list);
		this->head = list;
	}
	this->count += 1;
}

/*
 * ꥹȥɤ³
 *³ꥹȥȥ꡼ϽƤ뤳
 */
STATIC void insertEnd(
	AggregateList *this,
	List *list)
{
	ASSERT(list != NULL);
	ASSERT((list->next == NULL) && (list->prev == NULL));

	if (this->end == NULL) {
		list->next = list->prev = list;
		this->head = list;
		this->end = list;
	}
	else {
		addNext(this->end, list);
		this->end = list;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼μ³
 */
STATIC void insertNext(
	AggregateList *this,
	List *prev,				// ³ȥ꡼
	List *src)
{
	ASSERT(prev != NULL);
	ASSERT(src != NULL);
	ASSERT((src->next == NULL) && (src->prev == NULL));

	addNext(prev, src);
	if (this->end == prev) {
		this->end = src;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼³
 */
STATIC void insertPrev(
	AggregateList *this,
	List *next,				// ³ȥ꡼
	List *src)
{
	ASSERT(next != NULL);
	ASSERT(src != NULL);
	ASSERT((src->next == NULL) && (src->prev == NULL));

	addPrev(next, src);
	if (this->head == next) {
		this->head = src;
	}
	this->count += 1;
}

/*
 * ꥹȥȥ꡼
 * ³Ƥʤϲ⤷ʤ
 */
STATIC void removeEntry(
	AggregateList *this,
	List *list)
{
	ASSERT(list != NULL);

	if (list->next == NULL) {
		return;
	}

	if (this->head == list) {
		if (list->next != list) {
			this->head = list->next;
		}
		else {
			this->head = NULL;
		}
	}
	if (this->end == list) {
		if (list->prev != list) {
			this->end = list->prev;
		}
		else {
			this->end = NULL;
		}
	}
	remove(list);
	this->count -= 1;
}

/*
 * إåɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		List *head = this->head;
		removeEntry(this, head);
		return head->object;
	}
	else {
		return NULL;
	}
}

/*
 * ɥȥ꡼Ф
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *getEnd(
	AggregateList *this)
{
	if (this->end != NULL) {
		List *end = this->end;
		removeEntry(this, end);
		return end->object;
	}
	else {
		return NULL;
	}
}

/*
 * إåɥȥ꡼򻲾
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refHead(
	AggregateList *this)
{
	if (this->head != NULL) {
		return this->head->object;
	}
	else {
		return NULL;
	}
}

/*
 * ɥȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refEnd(
	AggregateList *this)
{
	if (this->end != NULL) {
		return this->end->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refNext(
	AggregateList *this,
	const List *list)
{
	ASSERT(list != NULL);

	if (this->end != list) {
		return list->next->object;
	}
	else {
		return NULL;
	}
}

/*
 * Υȥ꡼򻲾Ȥ
 * return : ȥ꡼ν°֥ or NULL
 */
STATIC OBJECT *refPrev(
	AggregateList *this,
	const List *list)
{
	ASSERT(list != NULL);

	if (this->head != list) {
		return list->prev->object;
	}
	else {
		return NULL;
	}
}

/*
 * ꥹ³򻲾
 * return : 
 */
STATIC int getCount(
	AggregateList *this)
{
	return this->count;
}

/*
 * ꥹȤ˷ҤäƤ뤫
 * return : YES or NO
 */
STATIC int isLink(
	AggregateList *this,
	const List *list)
{
	ASSERT(list != NULL);

	return (list->next != NULL) ? YES : NO;
}

/*
 * ̤б
 */
STATIC void dummyFunc()
{
	printk("This operation not support!\n");
	ASSERT(0);
}

//--------------------------------------------------------------------------------------------------
// ƥ졼ѥ᥽å
//--------------------------------------------------------------------------------------------------

/*
 * إåɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refHeadEntry(
	AggregateList *this)
{
	return this->head;
}

/*
 * ɥꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refEndEntry(
	AggregateList *this)
{
	return this->end;
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refNextEntry(
	AggregateList *this,
	const List *list)
{
	ASSERT(list != NULL);

	if (this->end != list) {
		return list->next;
	}
	else {
		return NULL;
	}
}

/*
 * Υꥹȥȥ꡼򻲾
 * return : ꥹȥȥ꡼ or NULL
 */
STATIC List *refPrevEntry(
	AggregateList *this,
	const List *list)
{
	ASSERT(list != NULL);

	if (this->head != list) {
		return list->prev;
	}
	else {
		return NULL;
	}
}

//--------------------------------------------------------------------------------------------------
// 󥹥ȥ饯
//--------------------------------------------------------------------------------------------------

void AggregateListConstructor(
	AggregateList *this,
	AggregateListMethod *method)
{
	// 
	this->head = NULL;
	this->end = NULL;
	this->count = 0;

	method->insertHead = insertHead;
	method->insertEnd = insertEnd;
	method->insertNext = insertNext;
	method->insertPrev = insertPrev;
	method->removeEntry = removeEntry;
	method->getHead = getHead;
	method->getEnd = getEnd;
	method->refHead = refHead;
	method->refEnd = refEnd;
	method->refNext = refNext;
	method->refPrev = refPrev;
	method->pointHeadNext = (LIST_FUNC7) dummyFunc;
	method->removeOut = (LIST_FUNC8) dummyFunc;
	method->refHeadList = refHeadEntry;
	method->refEndList = refEndEntry;
	method->refNextList = refNextEntry;
	method->refPrevList = refPrevEntry;
	method->getCount = getCount;
	method->isLink = isLink;
}
