/*
 * AggregateList.h
 *
 * Copyright 2007; Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * IteratorѥListIteratorAggregateList
 */

#ifndef lib_AggregateList_h
#define lib_AggregateList_h

#include <sys/object.h>
#include <lib/List.h>

#ifndef ASM_FILE

/*
 * ꥹȽ°¤
 */
typedef struct AggregateList {
	List			*head;		// ꥹȥإå
	List			*end;		// ꥹȥ
	int 			count;		// ³ꥹȿ
} AggregateList;

/*
 * ꥹȽ¤
 */
typedef struct AggregateListMethod {
	void			(*insertHead) (struct AggregateList *, List *);
	void			(*insertEnd) (struct AggregateList *, List *);
	void			(*insertNext) (struct AggregateList *, List *, List *);
	void			(*insertPrev) (struct AggregateList *, List *, List *);
	void			(*removeEntry) (struct AggregateList *, List *);
	OBJECT*			(*getHead) (struct AggregateList *);
	OBJECT*			(*getEnd) (struct AggregateList *);
	OBJECT*			(*refHead) (struct AggregateList *);
	OBJECT*			(*refEnd) (struct AggregateList *);
	OBJECT*			(*refNext) (struct AggregateList *, const List *);
	OBJECT*			(*refPrev) (struct AggregateList *, const List *);
	void			(*pointHeadNext) (struct AggregateList *);
	void			(*removeOut) (struct AggregateList *, List *);
	List*			(*refHeadList) (struct AggregateList *);
	List*			(*refEndList) (struct AggregateList *);
	List*			(*refNextList) (struct AggregateList *, const List *);
	List*			(*refPrevList) (struct AggregateList *, const List *);
	int 			(*getCount) (struct AggregateList *);
	int				(*isLink) (struct AggregateList *, const List *);
} AggregateListMethod;

typedef OBJECT*	(*LIST_FUNC1) (struct AggregateList *);
typedef void	(*LIST_FUNC2) (struct AggregateList *, List *);
typedef OBJECT*	(*LIST_FUNC3) (struct AggregateList *, List *);
typedef void	(*LIST_FUNC4) (struct AggregateList *, List *, List *);
typedef OBJECT*	(*LIST_FUNC5) (struct AggregateList *, const List *);
typedef OBJECT*	(*LIST_FUNC6) (struct AggregateList *);
typedef void	(*LIST_FUNC7) (struct AggregateList *);
typedef void	(*LIST_FUNC8) (struct AggregateList *, List *);
typedef void	(*LIST_FUNC9) (struct AggregateList *, void *);
typedef List*	(*LIST_FUNC10) (struct AggregateList *);
typedef List*	(*LIST_FUNC11) (struct AggregateList *, const List *);
typedef int		(*LIST_FUNC12) (struct AggregateList *, const List *);
typedef int		(*LIST_FUNC13) (struct AggregateList *);

extern void AggregateListConstructor(AggregateList*, AggregateListMethod*);
extern void AggregateCircleConstructor(AggregateList*, AggregateListMethod*);

#endif // ASM_FILE

#endif // lib_AggregateList_h
