/*
 * Hierarchy.c
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסճع¤
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <lib/Hierarchy.h>

#include <kern/debug.h>

//#define TEST_LIB_HIERARCHY

//#define DEBUG_LIB_HIERARCHY 1
#ifdef DEBUG_LIB_HIERARCHY
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static AggregateListMethod aggrMethod;		// ꥹȥ᥽å

#ifdef TEST_LIB_HIERARCHY
static void testHierarchy()
{
	Hierarchy hierarchy1;
	Hierarchy hierarchy2;
	Hierarchy hierarchy3;
	Hierarchy hierarchy4;

	HierarchyConstructor(&hierarchy1, (void*) 1);
	HierarchyConstructor(&hierarchy2, (void*) 2);
	HierarchyConstructor(&hierarchy3, (void*) 3);
	HierarchyConstructor(&hierarchy4, (void*) 4);

	if (HierarchyGetChildCount(&hierarchy1) != 0) {
		panic("HierarchyGetChildCount error file=%s line=%d", __FILE__, __LINE__);
	}

	HierarchyAdd(&hierarchy2, &hierarchy1);
	HierarchyAdd(&hierarchy3, &hierarchy2);
	HierarchyAdd(&hierarchy4, &hierarchy2);

	if (HierarchyGetChildCount(&hierarchy2) != 2) {
		panic("HierarchyGetChildCount error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetChildCount(&hierarchy4) != 0) {
		panic("HierarchyGetChildCount error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetParent(&hierarchy4) != (void*) 2) {
		panic("HierarchyGetParent( error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetParent(&hierarchy1) != NULL) {
		panic("HierarchyGetParent error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetChild(&hierarchy4) != NULL) {
		panic("HierarchyGetChild error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetChild(&hierarchy2) != (void*) 3) {
		panic("HierarchyGetChild( error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetNext(&hierarchy3) != (void*) 4) {
		panic("HierarchyGetChild( error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarchyGetNext(&hierarchy4) != NULL) {
		panic("HierarchyGetChild( error file=%s line=%d", __FILE__, __LINE__);
	}

	HierarchyRemove(&hierarchy3);
	HierarchyRemove(&hierarchy4);

	if (HierarchyGetChildCount(&hierarchy2) != 0) {
		panic("HierarchyGetChildCount error file=%s line=%d", __FILE__, __LINE__);
	}

	printk("testHierarchy OK\n");
}
#endif

//===================================== PUBLIC =====================================================

int HierarchyInit()
{
#ifdef TEST_LIB_HIERARCHY
	testHierarchy();
#endif
	return NOERR;
}

void HierarchyConstructor(
	Hierarchy *this,
	void *object)
{
	listConstructor(&this->list, object);
	this->parent = NULL;
	AggregateListConstructor(&this->aggrChild, &aggrMethod);
	this->object = object;
}

void HierarchyDestructor(
	Hierarchy *this)
{
	// ⤷ʤ
}

void HierarchyAdd(
	Hierarchy *this,
	Hierarchy *parent)
{
	aggrMethod.insertEnd(&parent->aggrChild, &this->list);
	this->parent = parent;
}

void HierarchyRemove(
	Hierarchy *this)
{
	if (this->parent == NULL) {
		return;
	}

	aggrMethod.removeEntry(&this->parent->aggrChild, &this->list);
	this->parent = NULL;
}

/*
 * ƥ֥Ȥ
 * return : Hierarchy or NULL
 */
void *HierarchyGetParent(
	Hierarchy *this)
{
	return (this->parent != NULL) ? this->parent->object : NULL;
}

/*
 * ҥꥹȺǽΥ֥Ȥ
 * return : Hierarchy or NULL
 */
void *HierarchyGetChild(
	Hierarchy *this)
{
	return aggrMethod.refHead(&this->aggrChild);
}

/*
 * ҥꥹȼΥ֥Ȥ
 * return : Hierarchy or NULL
 */
void *HierarchyGetNext(
	Hierarchy *this)
{
	if(this->parent == NULL) {
		return NULL;
	}
	return aggrMethod.refNext(&this->parent->aggrChild, &this->list);
}

/*
 * ҥ֥ȿ
 * return : ҥ֥ȿ
 */
int HierarchyGetChildCount(
	Hierarchy *this)
{
	return aggrMethod.getCount(&this->aggrChild);
}
