/*
 * Hierarchy.h
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef lib_Hierarchy_h
#define lib_Hierarchy_h

#include <lib/AggregateList.h>

#ifndef ASM_FILE

/*
 * ع¤
 */
typedef struct Hierarchy {
	List				list;
	struct Hierarchy	*parent;		// 
	AggregateList		aggrChild;		// ҥꥹȽ
	void 				*object;
} Hierarchy;

extern void HierarchyConstructor(Hierarchy*, void*);
extern void HierarchyDestructor(Hierarchy*);
extern void HierarchyAdd(Hierarchy*, Hierarchy*);
extern void HierarchyRemove(Hierarchy*);
extern void *HierarchyGetParent(Hierarchy*);
extern void *HierarchyGetChild(Hierarchy*);
extern void *HierarchyGetNext(Hierarchy*);
extern int HierarchyGetChildCount(Hierarchy*);

#endif // ASM_FILE

#endif // lib_Hierarchy_h
