/*
 * bitmap.c
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 * ӥåȥޥåѴؿ
 *
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/limits.h>
#include <lib/bitmap.h>

#include <kern/debug.h>


//#define DEBUG_BITMAP 1
#ifdef DEBUG_BITMAP
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//==================================  ===========================================

//================================== PRIVATE ============================================

typedef struct {
	uchar	low;		// Хǲ̥ӥåȰ
	uchar	count;		// Хǲ̤Ϣ³Ƥӥåȿ
	uchar	high;		// ХǾ̥ӥåȰ
} BYTE_BIT;

static const BYTE_BIT byteBit[] = {
//   0       1       2       3       4       5       6       7       8       9       a       b       c       d       e       f
	{0,0,0},{0,1,1},{1,1,2},{0,2,2},{2,1,3},{0,1,3},{1,2,3},{0,3,3},{3,1,4},{0,1,4},{1,1,4},{0,2,4},{2,2,4},{0,1,4},{1,3,4},{0,4,4},//0
	{4,1,5},{0,1,5},{1,1,5},{0,2,5},{2,1,5},{0,1,5},{1,2,5},{0,3,5},{3,2,5},{0,1,5},{1,1,5},{0,2,5},{2,3,5},{0,1,5},{1,4,5},{0,5,5},//1
	{5,1,6},{0,1,6},{1,1,6},{0,2,6},{2,1,6},{0,1,6},{1,2,6},{0,3,6},{3,1,6},{0,1,6},{1,1,6},{0,2,6},{2,2,6},{0,1,6},{1,3,6},{0,4,6},//2
	{4,2,6},{0,1,6},{1,1,6},{0,2,6},{2,1,6},{0,1,6},{1,2,6},{0,3,6},{3,3,6},{0,1,6},{1,1,6},{0,2,6},{2,4,6},{0,1,6},{1,5,6},{0,6,6},//3
	{6,1,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,1,7},{0,1,7},{1,1,7},{0,2,7},{2,2,7},{0,1,7},{1,3,7},{0,4,7},//4
	{4,1,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,2,7},{0,1,7},{1,1,7},{0,2,7},{2,3,7},{0,1,7},{1,4,7},{0,5,7},//5
	{5,2,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,1,7},{0,1,7},{1,1,7},{0,2,7},{2,2,7},{0,1,7},{1,3,7},{0,4,7},//6
	{4,3,7},{0,1,7},{1,1,7},{0,2,7},{2,1,7},{0,1,7},{1,2,7},{0,3,7},{3,4,7},{0,1,7},{1,1,7},{0,2,7},{2,5,7},{0,1,7},{1,6,7},{0,7,7},//7
	{7,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},//8
	{4,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,2,8},{0,1,8},{1,1,8},{0,2,8},{2,3,8},{0,1,8},{1,4,8},{0,5,8},//9
	{5,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},//a
	{4,2,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,3,8},{0,1,8},{1,1,8},{0,2,8},{2,4,8},{0,1,8},{1,5,8},{0,6,8},//b
	{6,2,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},//c
	{4,1,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,2,8},{0,1,8},{1,1,8},{0,2,8},{2,3,8},{0,1,8},{1,4,8},{0,5,8},//d
	{5,3,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,1,8},{0,1,8},{1,1,8},{0,2,8},{2,2,8},{0,1,8},{1,3,8},{0,4,8},//e
	{4,4,8},{0,1,8},{1,1,8},{0,2,8},{2,1,8},{0,1,8},{1,2,8},{0,3,8},{3,5,8},{0,1,8},{1,1,8},{0,2,8},{2,6,8},{0,1,8},{1,7,8},{0,8,8} //f
};

static const u_int8_t bit[8][9] = {
	{0, 0x1,  0x3,  0x7,  0xf,  0x1f, 0x3f, 0x7f, 0xff},
	{0, 0x2,  0x6,  0xe,  0x1e, 0x3e, 0x7e, 0xfe, 0xfe},
	{0, 0x4,  0xc,  0x1c, 0x3c, 0x7c, 0xfc, 0xfc, 0xfc},
	{0, 0x8,  0x18, 0x38, 0x78, 0xf8, 0xf8, 0xf8, 0xf8},
	{0, 0x10, 0x30, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0},
	{0, 0x20, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0},
	{0, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0},
	{0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
};

//================================== PUBLIC ==============================================

/*
 * ӥåȰ֤
 * reutrn : ǲ̥ӥåȰ or ERR
 */
int getBitmapPos(
	const int i_start,		// ȥӥåȰ֡ʣ
	const int i_allNum,		// ӥåȥޥåӥåȿ
	const u_int8_t *i_bitmap)
{
	int startByte;
	int lastByte;
	int byte;

	ASSERT(i_start <= INT_MAX);
	ASSERT(i_allNum <= INT_MAX);
	ASSERT(i_start < i_allNum);
	
	// ΤХȤ򸡺
	lastByte = ROUNDUP_DIV(i_allNum, CHAR_BIT);
	startByte = i_start / CHAR_BIT;
	byte = startByte;
	for (;;) {
		if (i_bitmap[byte] != 0) {
			if ((byte * CHAR_BIT + byteBit[(u_int8_t) i_bitmap[byte]].low) < i_allNum) {
				// ȯ
				break;
			}
		}

		++byte;
		if (lastByte <= byte) {
			byte = 0;
		}
		if (byte == startByte) {
			// ̵
			return ERR;
		}
	}
	
	return byte * CHAR_BIT + byteBit[(u_int8_t) i_bitmap[byte]].low;
}

/*
 * ӥåȰ֤
 * reutrn : ǲ̶ӥåȰ or ERR
 */
int getBitmapEmptyPos(
	const int i_start,		// ȥӥåȰ֡ʣ
	const int i_allNum,		// ӥåȥޥåӥåȿ
	const u_int8_t *i_bitmap)
{
	int startByte;
	int lastByte;
	int byte;

	ASSERT(i_start <= INT_MAX);
	ASSERT(i_allNum <= INT_MAX);
	ASSERT(i_start < i_allNum);
	
	// ΤХȤ򸡺
	lastByte = ROUNDUP_DIV(i_allNum, CHAR_BIT);
	startByte = i_start / CHAR_BIT;
	byte = startByte;
	for (;;) {
		if (i_bitmap[byte] != 0xff) {
			if ((byte * CHAR_BIT + byteBit[(u_int8_t) ~i_bitmap[byte]].low) < i_allNum) {
				// ȯ
				break;
			}
		}

		++byte;
		if (lastByte <= byte) {
			byte = 0;
		}
		if (byte == startByte) {
			// ̵
			return ERR;
		}
	}
	
	return byte * CHAR_BIT + byteBit[(u_int8_t) ~i_bitmap[byte]].low;
}

/*
 * ӥåȥޥåפ
 * return : ӥåȥޥå
 */
u_int8_t bitmapGet(
	const int i_num,		// ӥåȰ֡ʣ
	const int i_count)		// ӥåȿ
{
	ASSERT(i_num < CHAR_BIT);
	ASSERT(i_count <= CHAR_BIT);

	return bit[i_num][i_count];
}

/*
 * ӥåȥޥåפγ֥ӥåȤ򥻥åȤ
 */
void bitmapSet(
	const int i_num,		// ӥåȰ֡ʣ
	const int i_count,		// ӥåȿ
	u_int8_t *m_bitmap)		// ӥåȥޥå
{
	ASSERT(i_count <= CHAR_BIT);

	m_bitmap[i_num / CHAR_BIT] |= bit[i_num % CHAR_BIT][i_count];
}

/*
 * ӥåȥޥåפγ֥ӥåȤꥻåȤ
 */
void bitmapReset(
	const int i_pos,		// ӥåȰ֡ʣ
	const int i_count,		// ӥåȿ
	u_int8_t *m_bitmap)		// ӥåȥޥå
{
	ASSERT(i_count <= CHAR_BIT);

	m_bitmap[i_pos / CHAR_BIT] &= ~bit[i_pos % CHAR_BIT][i_count];
}

/*
 * Хȥӥåȥޥå׾μ
 */
void getBitmapRange(
	const u_int8_t bitmap,
	BitmapInfo *m_info)
{
	m_info->low = byteBit[bitmap].low;
	m_info->count = byteBit[bitmap].count;
	m_info->high = byteBit[bitmap].high;
}

/*
 * ӥåȥޥåפ٤ƥåȤƤ뤫
 * return : YES or NO
 */
int bitmapIsSet(
	const u_int8_t *dst,
	const u_int8_t src)
{
	if (src == 0) {
		return NO;
	}
	return ((*dst & src) == src) ? YES : NO;
}
