/*
 * bitmap.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef bitmap_h
#define bitmap_h

#include <sys/types.h>
#include <sys/param.h>

#ifndef ASM_FILE

/*
 * Хȥӥåȥޥå׾¤
 */
typedef struct {
	int low;		// ǲ̥ӥåȰ֣
	int count;		// ǲ̤Ϣ³ӥåȿ
	int high;		// Ǿ̥ӥåȰ֡ܣ
} BitmapInfo;

extern int getBitmapPos(const int, const int, const u_int8_t *);
extern int getBitmapEmptyPos(const int, const int, const u_int8_t *);
extern u_int8_t bitmapGet(const int, const int);
extern void bitmapSet(const int, const int, u_int8_t *);
extern void bitmapReset(const int, const int, u_int8_t *);
extern void getBitmapRange(const u_int8_t, BitmapInfo*);
extern int bitmapIsSet(const u_int8_t*, const u_int8_t);

#endif

#endif
