/*
 * lib.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥ饤֥꡼
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/limits.h>
#include <sys/tty.h>
#include <sys/libkern.h>
#include <machine/stdarg.h>
#include <kern/time.h>
#include <kern/vm.h>
#include <dev/console/console.h>
#include <lib/lib.h>

/****************************************************************************
 *
 * Format string.
 *
 ****************************************************************************/

enum{
	TMP_BUF_SIZE = 12,
};

//================================== PRIVATE ============================================

/*
 * ʸѴƥХåե¸롣
 * parameters :
 * return : converted string size
 */
static int formatString(const char *str,char *buf,uint *arg)
{
	int ivalue,size;
	int i;


	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			switch(*++str)
			{
				case 'd':
					ivalue = *arg++;
					if(ivalue<0)
					{
						buf[i++]='-';
						ivalue*=-1;
					}
					i += iToDecimal(ivalue, &buf[i]);
					break;
				case 'u':
					ivalue = *arg++;
					i += iToDecimal(ivalue, &buf[i]);
					break;
				case 'x':
					i += iToBinary(*arg++,&buf[i]);
					break;
				case 's':
					size=strlen((char*)*arg);
					memcpy(&buf[i],(char*)*arg,size);
					++arg;
					i+=size;
					break;
				case '%':
				default:
					buf[i++]='%';
			}
		}
		else buf[i++]=*str;
	}

	buf[i]='\0';

	return i;
}


//================================== PUBLIC =============================================

/*
 * ̽ϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
int printk(const char *str,...)
{
	char buf[240];
	int size;
	void *arg = &str+1;

	size = formatString(str, buf, arg);
	writeConsole(buf, size);

	return 0;
}

/*
 * Хåեϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
int sprintk(char *buf,const char *str,...)
{
	void *arg = &str+1;

	return formatString(str,buf,arg);
}

/*
 * Convert ascii to integer
 * parameters : string
 * return : integer or 0(Ǥʤ)
 */
int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}

void bcopy (const void *from, void *to, size_t len)
{
	memcpy(to, from, len);
}

/*
 * 10ʿʸѴ롣
 * return : string length
 */
int iToDecimal(uint value, char *m_str)
{
	char tmp_buf[TMP_BUF_SIZE];
	int cnt;

	for (cnt = TMP_BUF_SIZE - 1; ; --cnt){
		tmp_buf[cnt] = value % 10 + '0';
		if (!(value /= 10)){
			break;
		}
	}
	memcpy(m_str, &tmp_buf[cnt], TMP_BUF_SIZE - cnt);
	m_str[TMP_BUF_SIZE - cnt] = '\0';

	return TMP_BUF_SIZE - cnt;
}

/*
 * 16ʿʸѴ롣
 * return : string length
 */
int iToBinary(uint value,char *m_str)
{
	char tmp_buf[TMP_BUF_SIZE];
	int cnt;

	for (cnt = TMP_BUF_SIZE-1; ; --cnt){
		tmp_buf[cnt] = value % 16 + '0';
		if ('9' < tmp_buf[cnt]){
			tmp_buf[cnt] += 'a' - '9' - 1;
		}
		if (!(value /= 16)){
			break;
		}
	}
	memcpy(m_str, &tmp_buf[cnt], TMP_BUF_SIZE - cnt);
	m_str[TMP_BUF_SIZE - cnt] = '\0';

	return TMP_BUF_SIZE - cnt;
}

/****************************************************************************
 * ץȥ롼
 ****************************************************************************/

//================================== PRIVATE ============================================

#define TOCONS	0x01
#define TOTTY	0x02
#define TOLOG	0x04
#define MAXNBUF	(sizeof(quad_t) * CHAR_BIT + 1)
struct	tty *constty;			/* pointer to console "window" tty */

struct putchar_arg {
	int	flags;
	int	pri;
	struct	tty *tty;
};

static void putchar(int ch, void *arg)
{
	struct putchar_arg *ap = (struct putchar_arg*) arg;
	int flags = ap->flags;
//	struct tty *tp = ap->tty;

//	if (panicstr){
//		constty = NULL;
//	}
//	if ((flags & TOCONS) && tp == NULL && constty) {
//		tp = constty;
//		flags |= TOTTY;
//	}
//	if ((flags & TOTTY) && tp && tputchar(c, tp) < 0 && (flags & TOCONS) && tp == constty)
//		constty = NULL;
//	if ((flags & TOLOG)){
//		msglogchar(c, ap->pri);
//	}
	if ((flags & TOCONS) == TOCONS && constty == NULL && ch != '\0'){
		char c = ch;
		writeConsole(&c, 1);
	}
}

struct snprintf_arg {
	char	*str;
	size_t	remain;
};

/*
 *FreeBSD
 */
static void snprintf_func(int ch, void *arg)
{
	struct snprintf_arg *const info = arg;

	if (info->remain >= 2) {
		*info->str++ = ch;
		info->remain--;
	}
}

/*
 *FreeBSD
 * Put a NUL-terminated ASCII number (base <= 36) in a buffer in reverse
 * order; return an optional length and a pointer to the last character
 * written in the buffer (i.e., the first character of the string).
 * The buffer pointed to by `nbuf' must have length >= MAXNBUF.
 */
static char *ksprintn(char *nbuf, u_long ul, int base, int *lenp)
{
	char *p;

	p = nbuf;
	*p = '\0';
	do {
		*++p = hex2ascii(ul % base);
	} while (ul /= base);
	if (lenp)
		*lenp = p - nbuf;
	return (p);
}

/*
 * ksprintn, but for a quad_t.
 */
static char *ksprintqn(char *nbuf, u_quad_t uq, int base, int *lenp)
{
	char *p;

	p = nbuf;
	*p = '\0';
	do {
		*++p = hex2ascii(uq % base);
	} while (uq /= base);
	if (lenp)
		*lenp = p - nbuf;
	return (p);
}

//================================== PUBLIC =============================================

/*
 *FreeBSD
 * Scaled down version of printf(3).
 * Two additional formats:
 * The format %b is supported to decode error registers.
 * Its usage is: 
 * 	printf("reg=%b\n", regval, "<base><arg>*");
 * where <base> is the output base expressed as a control character, e.g.
 * \10 gives octal; \20 gives hex.  Each arg is a sequence of characters,
 * the first of which gives the bit number to be inspected (origin 1), and
 * the next characters (up to a control character, i.e. a character <= 32),
 * give the name of the register.  Thus:
 *
 *	kvprintf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=3<BITTWO,BITONE>
 *
 * XXX:  %D  -- Hexdump, takes pointer and separator string:
 *		("%6D", ptr, ":")   -> XX:XX:XX:XX:XX:XX
 *		("%*D", len, ptr, " " -> XX XX XX XX ...
 */
int kvprintf(char const *fmt, void (*func)(int, void*), void *arg, int radix, va_list ap)
{
#define PCHAR(c) {int cc=(c); if (func) (*func)(cc,arg); else *d++ = cc; retval++; }
	char nbuf[MAXNBUF];
	char *p, *q, *d;
	u_char *up;
	int ch, n;
	u_long ul;
	u_quad_t uq;
	int base, lflag, qflag, tmp, width, ladjust, sharpflag, neg, sign, dot;
	int dwidth;
	char padc;
	int retval = 0;

	ul = 0;
	uq = 0;
	if (!func)
		d = (char *) arg;
	else
		d = NULL;

	if (fmt == NULL)
		fmt = "(fmt null)\n";

	if (radix < 2 || radix > 36)
		radix = 10;

	for (;;) {
		padc = ' ';
		width = 0;
		while ((ch = (u_char)*fmt++) != '%') {
			if (ch == '\0')
				return retval;
			PCHAR(ch);
		}
		qflag = 0; lflag = 0; ladjust = 0; sharpflag = 0; neg = 0;
		sign = 0; dot = 0; dwidth = 0;
reswitch:	switch (ch = (u_char)*fmt++) {
		case '.':
			dot = 1;
			goto reswitch;
		case '#':
			sharpflag = 1;
			goto reswitch;
		case '+':
			sign = 1;
			goto reswitch;
		case '-':
			ladjust = 1;
			goto reswitch;
		case '%':
			PCHAR(ch);
			break;
		case '*':
			if (!dot) {
				width = va_arg(ap, int);
				if (width < 0) {
					ladjust = !ladjust;
					width = -width;
				}
			} else {
				dwidth = va_arg(ap, int);
			}
			goto reswitch;
		case '0':
			if (!dot) {
				padc = '0';
				goto reswitch;
			}
		case '1': case '2': case '3': case '4':
		case '5': case '6': case '7': case '8': case '9':
				for (n = 0;; ++fmt) {
					n = n * 10 + ch - '0';
					ch = *fmt;
					if (ch < '0' || ch > '9')
						break;
				}
			if (dot)
				dwidth = n;
			else
				width = n;
			goto reswitch;
		case 'b':
			ul = va_arg(ap, int);
			p = va_arg(ap, char *);
			for (q = ksprintn(nbuf, ul, *p++, NULL); *q;)
				PCHAR(*q--);

			if (!ul)
				break;

			for (tmp = 0; *p;) {
				n = *p++;
				if (ul & (1 << (n - 1))) {
					PCHAR(tmp ? ',' : '<');
					for (; (n = *p) > ' '; ++p)
						PCHAR(n);
					tmp = 1;
				} else
					for (; *p > ' '; ++p)
						continue;
			}
			if (tmp)
				PCHAR('>');
			break;
		case 'c':
			PCHAR(va_arg(ap, int));
			break;
		case 'D':
			up = va_arg(ap, u_char *);
			p = va_arg(ap, char *);
			if (!width)
				width = 16;
			while(width--) {
				PCHAR(hex2ascii(*up >> 4));
				PCHAR(hex2ascii(*up & 0x0f));
				up++;
				if (width)
					for (q=p;*q;q++)
						PCHAR(*q);
			}
			break;
		case 'd':
			if (qflag)
				uq = va_arg(ap, quad_t);
			else if (lflag)
				ul = va_arg(ap, long);
			else
				ul = va_arg(ap, int);
			sign = 1;
			base = 10;
			goto number;
		case 'l':
			if (lflag) {
				lflag = 0;
				qflag = 1;
			} else
				lflag = 1;
			goto reswitch;
		case 'o':
			if (qflag)
				uq = va_arg(ap, u_quad_t);
			else if (lflag)
				ul = va_arg(ap, u_long);
			else
				ul = va_arg(ap, u_int);
			base = 8;
			goto nosign;
		case 'p':
			ul = (uintptr_t)va_arg(ap, void *);
			base = 16;
			sharpflag = (width == 0);
			goto nosign;
		case 'q':
			qflag = 1;
			goto reswitch;
		case 'n':
		case 'r':
			if (qflag)
				uq = va_arg(ap, u_quad_t);
			else if (lflag)
				ul = va_arg(ap, u_long);
			else
				ul = sign ?
				    (u_long)va_arg(ap, int) : va_arg(ap, u_int);
			base = radix;
			goto number;
		case 's':
			p = va_arg(ap, char *);
			if (p == NULL)
				p = "(null)";
			if (!dot)
				n = strlen (p);
			else
				for (n = 0; n < dwidth && p[n]; n++)
					continue;

			width -= n;

			if (!ladjust && width > 0)
				while (width--)
					PCHAR(padc);
			while (n--)
				PCHAR(*p++);
			if (ladjust && width > 0)
				while (width--)
					PCHAR(padc);
			break;
		case 'u':
			if (qflag)
				uq = va_arg(ap, u_quad_t);
			else if (lflag)
				ul = va_arg(ap, u_long);
			else
				ul = va_arg(ap, u_int);
			base = 10;
			goto nosign;
		case 'x':
		case 'X':
			if (qflag)
				uq = va_arg(ap, u_quad_t);
			else if (lflag)
				ul = va_arg(ap, u_long);
			else
				ul = va_arg(ap, u_int);
			base = 16;
			goto nosign;
		case 'z':
			if (qflag)
				uq = va_arg(ap, u_quad_t);
			else if (lflag)
				ul = va_arg(ap, u_long);
			else
				ul = sign ?
				    (u_long)va_arg(ap, int) : va_arg(ap, u_int);
			base = 16;
			goto number;
nosign:			sign = 0;
number:
			if (qflag) {
				if (sign && (quad_t)uq < 0) {
					neg = 1;
					uq = -(quad_t)uq;
				}
				p = ksprintqn(nbuf, uq, base, &tmp);
			} else {
				if (sign && (long)ul < 0) {
					neg = 1;
					ul = -(long)ul;
				}
				p = ksprintn(nbuf, ul, base, &tmp);
			}
			if (sharpflag && (qflag ? uq != 0 : ul != 0)) {
				if (base == 8)
					tmp++;
				else if (base == 16)
					tmp += 2;
			}
			if (neg)
				tmp++;

			if (!ladjust && width && (width -= tmp) > 0)
				while (width--)
					PCHAR(padc);
			if (neg)
				PCHAR('-');
			if (sharpflag && (qflag ? uq != 0 : ul != 0)) {
				if (base == 8) {
					PCHAR('0');
				} else if (base == 16) {
					PCHAR('0');
					PCHAR('x');
				}
			}

			while (*p)
				PCHAR(*p--);

			if (ladjust && width && (width -= tmp) > 0)
				while (width--)
					PCHAR(padc);

			break;
		default:
			PCHAR('%');
			if (lflag)
				PCHAR('l');
			PCHAR(ch);
			break;
		}
	}
#undef PCHAR
}


//FreeBSD
int vprintf(const char *fmt, va_list ap)
{
//	int savintr;
	struct putchar_arg pca;
	int retval;

//	savintr = consintr;		/* disable interrupts */
//	consintr = 0;
	pca.tty = NULL;
	pca.flags = TOCONS | TOLOG;
	pca.pri = -1;
	retval = kvprintf(fmt, putchar, &pca, 10, ap);
//	if (!panicstr)
//		msgbuftrigger = 1;
//	consintr = savintr;		/* reenable interrupts */
	return retval;
}

/*
 *FreeBSD
 */
int vsnprintf(char *str, size_t size, const char *format, va_list ap)
{
	struct snprintf_arg info;
	int retval;

	info.str = str;
	info.remain = size;
	retval = kvprintf(format, snprintf_func, &info, 10, ap);
	if (info.remain >= 1)
		*info.str++ = '\0';
	return retval;
}

/*
 *FreeBSD
 */
int printf(const char *fmt, ...)
{
	va_list ap;
//	int savintr;
	struct putchar_arg pca;
	int retval;

//	savintr = consintr;		/* disable interrupts */
//	consintr = 0;
	va_start(ap, fmt);
	pca.tty = NULL;
	pca.flags = TOCONS | TOLOG;
	pca.pri = -1;
	retval = kvprintf(fmt, putchar, &pca, 10, ap);
	va_end(ap);
//	if (!panicstr)
//		msgbuftrigger = 1;
//	consintr = savintr;		/* reenable interrupts */
	return retval;
}

/*
 *FreeBSD
 */
int snprintf(char *str, size_t size, const char *format, ...)
{
	int retval;
	va_list ap;

	va_start(ap, format);
	retval = vsnprintf(str, size, format, ap);
	va_end(ap);
	return(retval);
}

/*
 *FreeBSD
 */
int sprintf(char *buf, const char *cfmt, ...)
{
	int retval;
	va_list ap;

	va_start(ap, cfmt);
	retval = kvprintf(cfmt, NULL, (void *)buf, 10, ap);
	buf[retval] = '\0';
	va_end(ap);
	return retval;
}

/*
 * ͥѥ˥å
 */
void panic(
	const char *ctl, 
	...)
{
	va_list va;

	va_start(va, ctl);
	printf("Kernel panic! ");
	vprintf(ctl, va);
	vprintf("\n", NULL);
	va_end(va);

	idle();
}

/***********************************************************************************
 *
 * IO٥Хåե
 *
 ***********************************************************************************/

/*
 * IO٥Хåե˥ԡ
 * return : ԡХȿ
 */
int copyIovec(
	const char *i_data,		// ԡǡ
	const int len,			// ԡǡ
	struct iovec *iov,		// ԡIO٥Хåե
	const int iovLen,		// ԡIO٥Хåեǥå
	int *m_iovArrey,		// ߤIO٥Хåեǥå
	int *m_iovOffset)		// ߤIO٥Хåեեå
{
	const char *data = i_data;
	int allSize = 0;
	int dataSize = len;
	int iovArrey = *m_iovArrey;
	int iovOffset = *m_iovOffset;

	/* 桼Хåե˥ԡ */
	while (iovArrey < iovLen){
		int cpSize = (dataSize <= iov[iovArrey].iov_len - iovOffset)? dataSize : iov[iovArrey].iov_len - iovOffset;
		memcpy(iov[iovArrey].iov_base + iovOffset, data, cpSize);
		allSize += cpSize;
		dataSize -= cpSize;
		iovOffset += cpSize;

		if (iovOffset == iov[iovArrey].iov_len){
			iovOffset = 0;
			++iovArrey;
		}
		if (dataSize == 0){
			break;
		}
		data += cpSize;
	}
	*m_iovArrey = iovArrey;
	*m_iovOffset = iovOffset;

	return allSize;
}

/*
 * uio¤moveؿ
 */
int uiomove(caddr_t cp, int n, struct uio *uio)
{
	struct iovec *iov;
	u_int cnt;

	while (n > 0 && uio->uio_resid) {
		iov = uio->uio_iov;
		cnt = iov->iov_len;
		if (cnt == 0) {
			uio->uio_iov++;
			uio->uio_iovcnt--;
			continue;
		}
		if (cnt > n){
			cnt = n;
		}

		switch (uio->uio_segflg) {
			case UIO_USERSPACE:
				// 
			case UIO_USERISPACE:
				// 
			case UIO_SYSSPACE:
				if (uio->uio_rw == UIO_READ){
					memcpy(iov->iov_base, cp, cnt);
				}
				else{
					memcpy(cp, iov->iov_base, cnt);
				}
				break;
			case UIO_NOCOPY:
				break;
		}
		iov->iov_base += cnt;
		iov->iov_len -= cnt;
		uio->uio_resid -= cnt;
		uio->uio_offset += cnt;
		cp += cnt;
		n -= cnt;
	}

	return 0;
}

/***************************************************************************************
 *ȥ󥰴ؿ
 ***************************************************************************************/

/*
 *FreeBSD
 * Copy src to dst, truncating or null-padding to always copy n bytes.
 * Return dst.
 */
char *strncpy(char *dst, const char *src, size_t n)
{
	if (n != 0) {
		register char *d = dst;
		register const char *s = src;

		do {
			if ((*d++ = *s++) == 0) {
				/* NUL pad the remaining n-1 bytes */
				while (--n != 0)
					*d++ = 0;
				break;
			}
		} while (--n != 0);
	}
	return (dst);
}

/*
 *FreeBSD
 */
int strncmp(const char *s1, const char *s2, size_t n)
{
	if (n == 0)
		return (0);
	do {
		if (*s1 != *s2++){
			return (*(const unsigned char *)s1 - *(const unsigned char *)(s2 - 1));
		}
		if (*s1++ == 0){
			break;
		}
	} while (--n != 0);

	return (0);
}

/*
 *ահΥϷ礷ʸκĹ
 *ʸ󤬺ĹˤʤäNULLʸդ˽λ
 * return : ʸ󥵥
 */
int strLenCat(char *i_dst, const char *i_src, const size_t len)
{
	const char *src = i_src;
	int i;

	for (i = strnlen(i_dst, len); i < len; ++i) {
		i_dst[i] = *src++;
		if (i_dst[i] == '\0') {
			return i;
		}
	}

	return len;
}

/***************************************************************************************
 * ե饰ѹԤ
 ***************************************************************************************/

/*
 * ե饰ͤͤδ֤Ԥˤ
 */
void waitFlag(
	const int waitValue,	// Ԥ
	int *flag)
{
	/*
	 * ѥǺŬ̵¥롼פʤ褦gotoȤ
	 */
LOOP:
	if (*flag == waitValue) {
		goto LOOP;
	}
}

/*
 * ӥåȤåȤƤ뤫
 * return : 0ʳ or 0
 */
int bitIsSet(
	uint *dst,
	const uint bitFlag)
{
	return *dst & bitFlag;
}

/***************************************************************************************
 *
 *ǥХå
 *
 ***************************************************************************************/

#ifdef DEBUG
/*
 * ̤ƬԤǤդη夫ʸɽ
 */
void printDebug(int column,const char *str,...)
{
	char buf[240];
	int size;
	void *arg = &str + 1;

	displayTop(column, "          ", 10);
	size = formatString(str,buf,arg);
	displayTop(column, buf, size);
}
#endif
