/*
 * lib.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * lib.clib.Sѥإåե
 */

#ifndef kern_lib_h
#define kern_lib_h

#include <sys/types.h>
#include <sys/uio.h>
#include <machine/io.h>
#include <machine/segment.h>

#ifndef ASM_FILE

struct iovec;

// ӥåȸå
#define	BIT_CLR(t, f)	((t) &= ~(f))
#define BIT_SET(t, f)	((t) |= (f))
#define	BIT_ISSET(t, f)	bitIsSet(&t, f)

#define ROUNDUP(a, b) (((uint)(a) + (b) - 1) / (b) * (b))
#define ROUNDDOWN(a, b) ((uint)(a) / (b) * (b))
#define ROUNDUP_DIV(a, b) (((uint)(a) + (b) - 1) / (b))
#define OFFSETOF(type, member) ((size_t) &((type*)0)->member)
#define ARRAY_LENGTH(x)	(sizeof(x) / sizeof(x[0]))
#define SWAP(a, b)	{int tmp = b; b = a; a = tmp;}
#define WAIT_LOOP(condition)	{LOOP:	if (condition){goto LOOP;}}

extern int (*write_tty)(void*,size_t,size_t);
extern int printk(const char*,...);
extern int sprintk(char *,const char*,...);
extern int iToDecimal(uint, char *);
extern int iToBinary(uint,char *);
extern void idle();
extern int read_tr();
extern uint getFualtAddr();
extern char *strcpy(char*,const char*);
extern int strcmp(const char*,const char*);
extern char *strncpy(char *, const char *, size_t);
extern int atoi(const char*);
extern void memCpyBack(void*,const void*, size_t);
extern void *memcpy(void *to, const void *from, size_t);
extern void *memset(void*,int,size_t);
extern int copyIovec(const char*, const int, struct iovec*, const int, int*, int*);
extern int snprintf (char *, size_t, const char *, ...);
extern int bitIsSet(uint*, const uint);

extern inline void *memmove(void *s1,const void *s2,size_t n)
{
	if((s1>s2)&&((char*)s1<(char*)s2+n))memCpyBack(s1,s2,n);
	else memcpy(s1,s2,n);

	return s1;
}

extern inline int memcmp(const void *s1,const void *s2,size_t n)
{
	int i=0;


	while(((char*)s1)[i]==((char*)s2)[i])
		if(++i>=n)return 0;

	if(((char*)s1)[i]>((char*)s2)[i])return 1;
	return -1;
}

extern inline char *strcpy(char *s1,const char *s2)
{
	char *p=s1;


	while((*p++=*s2++)!='\0');

	return s1;
}

extern inline size_t strlen(const char *s)
{
	const char *p = s;


	while(*p++ != '\0');

	return (size_t)(p-s-1);
}

extern inline size_t strnlen(const char *str, const size_t len)
{
	size_t i;

	for (i = 0; i < len; ++i) {
		if (str[i] == '\0') {
			return i;
		}
	}

	return len;
}

extern inline int strcmp(const char *s1, const char *s2)
{
	while (*s1 == *s2++){
		if (*s1++ == '\0'){
			return 0;
		}
	}
	if ((uchar)*s1 > (uchar)*--s2){
		return 1;
	}
	return -1;
}

extern inline char *strcat(char *s1,const char *s2)
{
	char *p = s1;

	for (; *p != '\0'; ++p);
	while ((*p++ = *s2++) != '\0');

	return s1;
}

/*
 * ʸ򥳥ԡʸ󥵥 + 1 ֤
 * return : ʸ󥵥
 */
extern inline int cpystr(
	char *s1,			// ԡХåե
	const char *s2)		// ԡʸ
{
	int i;

	i = 0;
	while ((s1[i] = s2[i]) != '\0') {
		++i;
	}

	return i + 1;
}

extern int strncmp(const char *, const char *, size_t);
extern int strLenCat(char *dst, const char *src, const size_t len);
extern void waitFlag(const int, int *);

#ifdef DEBUG
extern void printDebug(int,const char*,...);
#endif

#endif // ASM_FILE

#endif // kern_lib_h
