/*
 * lib_path.c
 *
 * Copyright 2005, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ѥʸؿ
 */


#include <sys/param.h>
#include <sys/types.h>
#include <kern/fs.h>


// ʸӤפХȿ֤
// ɤ餫NULLʸǤ⽪
int cmpStrNum(const char *dstStr, const char *srcStr)
{
	int count;

	for (count = 0; dstStr[count] & srcStr[count]; ++count) {
		if (dstStr[count] != srcStr[count]) {
			break;
		}
	}

	return count;
}

/*
 * ̾ʸȥѥʸӤ롣
 * return : 0 =  or 1 = 礭 or -1 = 
 */
int pathCmpName(
	const char *name,
	const char *path,
	const int count)		// ӥХȿ
{
	int i;

	for (i = 0; i < count; ++i){
		if (name[i] != path[i]){
			if ((uchar)name[i] > (uchar)path[i]){
				return 1;
			}
			else{
				return -1;
			}
		}
	}

	if ((path[count] == '/') || (path[count] == '\0')){
		return 0;
	}

	return -1;
}

/*
 * ѥʸ󥵥Ϥ롣
 * parmeters : path
 */
size_t pathLen(
	const char *path)
{
	const char *p = path;

	while (*p != '\0') {
		if (*++p == '/') {
			break;
		}
	}

	return p - path;
}

/*
 * ѥ饹ȥѥɤȽꤹ롣
 * return : YES or NO
 */
int isLastPath(const char *i_path)
{
	const char *path;

	for (path = i_path; *path != '\0'; ++path){
		if (*path == '/') {
			while (*++path == '/');
			break;
		}
	}

	return (*path == '\0') ? YES : NO;
}

/*
 * Υѥȥ꡼̾Ƭݥ󥿤롣
 * return : ѥȥ꡼̾Ƭݥ
 */
const char *pathGetNext(
	const char *i_path)
{
	const char *path = i_path;

	for (; *path != '\0'; ++path) {
		if (*path == '/') {
			for (; *path == '/'; ++path);
			break;
		}
	}

	return path;
}
