/*
 * Module.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסե⥸塼
 *
 *
 *
 *ԸƤ
 */

#define MODULE

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/uio.h>
#include <lib/IteratorList.h>
#include <lib/AggregateList.h>
#include <lib/lib.h>
#include <kern/kmalloc.h>
#include <kern/vm.h>
#include <kern/proc.h>
#include <kern/Hierarchy.h>
#include <kern/TaskWait.h>
#include <sys/Thread.h>
#include <kern/devfs.h>
#include <machine/lock.h>
#include <module/Module.h>

#include <kern/debug.h>

//#define DEBUG_MODULE 1
#ifdef DEBUG_MODULE
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//==================================  ===========================================

struct tty {
	int dummy;
};

struct buf {
	int dummy;
};

struct knote {
	int dummy;
};

/*
 * Block device switch table
 */
struct bdevsw {
	int		(*d_open)(dev_t, int, int, void *);
	int		(*d_close)(dev_t, int, int, void *);
	void	(*d_strategy)(struct buf *);
	int		(*d_ioctl)(dev_t, u_long, caddr_t, int, void *);
	int		(*d_dump)(dev_t, daddr_t, caddr_t, size_t);
	int		(*d_psize)(dev_t);
	int		d_type;
};

/*
 * Character device switch table
 */
struct _cdevsw {
	int			(*d_open)(dev_t, int, int, void *);
	int			(*d_close)(dev_t, int, int, void *);
	int			(*d_read)(dev_t, struct uio *, int);
	int			(*d_write)(dev_t, struct uio *, int);
	int			(*d_ioctl)(dev_t, u_long, caddr_t, int, void *);
	void		(*d_stop)(struct tty *, int);
	struct tty *(*d_tty)(dev_t);
	int			(*d_poll)(dev_t, int, void *);
	paddr_t		(*d_mmap)(dev_t, off_t, int);
	int			(*d_kqfilter)(dev_t, struct knote *);
	int			d_type;
};

typedef struct Module {
	List			list;
	char			name[MODULE_NAME_MAX + 1];
	ThreadObj		*task;
	dev_t 			dev;
	void			*returnMethod;
	struct _cdevsw	devsw;
} Module;

//================================== Х륤ݡ ===============================

extern int callUserMethod(ThreadObj*, const void*, const void*, const uint, const uint, const uint, const uint, const uint, const uint);

//================================== PRIVATE ============================================

/*
 * ⥸塼ꥹȽ
 *ե⥸塼ʸ󥵥MODULE_NAME_MAXǤ뤳
 */
static AggregateList moduleAggr;
static AggregateListMethod aggrMethod;
static int spinLock;

static void ModuleConstructor(
	Module *this,
	const char *i_name,
	struct _cdevsw *devsw,
	const dev_t dev,
	void *returnMethod)
{
	listConstructor(&this->list, this);
	snprintf(this->name, MODULE_NAME_MAX, "%s", i_name);
	this->task = getCurrentTask();
	this->devsw = *devsw;
	this->dev = dev;
	this->returnMethod = returnMethod;
	enter_spinlock(&spinLock);
	{
		aggrMethod.insertHead(&moduleAggr, &this->list);
	}
	exit_spinlock(&spinLock);
}

static void ModuleDestructor(
	Module *this)
{
	enter_spinlock(&spinLock);
	{
		aggrMethod.removeEntry(&moduleAggr, &this->list);
	}
	exit_spinlock(&spinLock);
	kfree(this);
}

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

STATIC INLINE ThreadObj *getTask(
	Module *this)
{
	return this->task;
}
	
//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

STATIC INLINE int setName(
	Module *this,
	const char *i_name)
{
	if (snprintf(this->name, MODULE_NAME_MAX, "%s", i_name) <= MODULE_NAME_MAX) {
		return NOERR;
	}
	else {
		return -ENAMETOOLONG;
	}
}

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

STATIC Module *searchTask(
	const ThreadObj *i_task)
{
	Module *module = NULL;
	IteratorList iterator;

	enter_spinlock(&spinLock);
	{
		IteratorListConstruct(&iterator, &moduleAggr, &aggrMethod);
		while (iterator.hasNext(&iterator) == BOOL_TRUE) {
			Module *next = iterator.next(&iterator);
			if (next->task == i_task) {
				module = next;
				break;
			}
		}
	}
	exit_spinlock(&spinLock);
	
	return module;
}

STATIC Module *searchName(
	const char *i_name)
{
	Module *module = NULL;
	IteratorList iterator;

	enter_spinlock(&spinLock);
	{
		IteratorListConstruct(&iterator, &moduleAggr, &aggrMethod);
		while (iterator.hasNext(&iterator) == BOOL_TRUE) {
			Module *next = iterator.next(&iterator);
			if (strcmp(i_name, next->name) == 0) {
				module = next;
				break;
			}
		}
	}
	exit_spinlock(&spinLock);
	
	return module;
}

//================================== PUBLIC =============================================

void ModuleInit()
{
	AggregateListConstructor(&moduleAggr, &aggrMethod);
}

//--------------------------------------------------------------------------------------------------
// եե󥯥
//--------------------------------------------------------------------------------------------------

/*
 * ǥХ򥪡ץ󤹤
 * return : error number
 */
int moduleOpenDev(
	void *i_this,
	const int oflag,
	void **o_privateData)
{
	Module *this = i_this;
	return callUserMethod(this->task, this->devsw.d_open, this->returnMethod, 
		this->dev,
		oflag,
		S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP,	// ϰǻäƤɬפ
		NULL,
		0,
		0);
}

/*
 * ǥХ򥯥
 * return : error number
 */
int moduleCloseDev(
	void *i_this,
	void *i_privateData)
{
	Module *this = i_this;
	return callUserMethod(this->task, this->devsw.d_close, this->returnMethod, 
		this->dev,
		O_RDWR,									// ϰǻäƤɬפ
		S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP,	// ϰǻäƤɬפ
		NULL,
		0,
		0);
}

/*
 * ǥХɤ߹
 * return : read bytes or error number
 */
int moduleReadDev(
	void *i_this,
	void *buf,				// ߥХåե
	const size_t len,		// ɤ߹ߥХȿ
	const off_t offset,		// ɤ߹߳ϥ֥å
	void *i_privateData)
{
	Module *this = i_this;
	struct iovec *iovec = entryAllocParamMem(getUserStackPoint(), sizeof(struct iovec));
	struct uio *uio = entryAllocParamMem(getUserStackPoint(), sizeof(struct uio));
	int error;

	iovec->iov_base = buf;
	iovec->iov_len = len;
	setUio(1, UIO_READ, offset, len, iovec, uio);
	error = callUserMethod(this->task, this->devsw.d_read, this->returnMethod, 
		this->dev,
		(const uint) uio,
		(const uint) getCurrentTask(),
		0,
		0,
		0);
	if (error == 0) {
		return len - uio->uio_resid;
	}
	else {
		return error;
	}
}

/*
 * ǥХ˽񤭹
 * return : write bytes or error number
 */
int moduleWriteDev(
	void *i_this,
	void *buf,				// ɤ߹ߥХåե
	const size_t len,		// ߥХȿ
	const off_t offset,		// ߳ϥ֥å
	void *i_privateData)
{
	Module *this = i_this;
	struct iovec *iovec = entryAllocParamMem(getUserStackPoint(), sizeof(struct iovec));
	struct uio *uio = entryAllocParamMem(getUserStackPoint(), sizeof(struct uio));
	int error;

	iovec->iov_base = buf;
	iovec->iov_len = len;
	setUio(1, UIO_WRITE, offset, len, iovec, uio);
	error = callUserMethod(this->task, this->devsw.d_write, this->returnMethod, 
		this->dev,
		(const uint) uio,
		(const uint) getCurrentTask(),
		0,
		0,
		0);
	if (error == 0) {
		return len - uio->uio_resid;
	}
	else {
		return error;
	}
}

/*
 * ǥХIOCTL
 * return : error number
 */
int moduleIoctlDev(
	void *i_this,
	const int cmd,
	caddr_t param,
	const int fflag,
	void *i_privateData)
{
	Module *this = i_this;
	return callUserMethod(this->task, this->devsw.d_ioctl, this->returnMethod, 
		this->dev,
		cmd,
		(const uint) param,
		fflag,
		0,
		NULL);
}

/*
 * ǥХPOLL
 * return : error number
 */
int modulePollDev(
	void *i_this,
	const int events,
	void *i_privateData)
{
	Module *this = i_this;
	return callUserMethod(this->task, this->devsw.d_poll, this->returnMethod, 
		this->dev,
		events,
		(const uint) getTaskWait(getCurrentTask()),
		0,
		0,
		0);
}

/*
 * ǥХơȤμ
 * return : error number
 */
void moduleStatDev(
	void *i_this,
	DEV_STAT *m_devStat)
{
	// ⤷ʤ
}

/*
 * struct uio ǥХ˽񤭹
 * return : error number
 */
int moduleWriteUio(
	void *i_this,
	const off_t block,		// ߳ϥ֥å
	const int size,
	struct iovec *iovec,
	const int iovCnt)
{
	Module *this = i_this;
	struct uio *uio = entryAllocParamMem(getUserStackPoint(), sizeof(struct uio));
	
	setUio(iovCnt, UIO_WRITE, block, size, iovec, uio);

	return callUserMethod(this->task, this->devsw.d_write, this->returnMethod,
		this->dev,
		(const uint) uio,
		(const uint) getCurrentTask(),
		0,
		0,
		0);
}

//----------------------------------------------------------
// ƥॳ
//----------------------------------------------------------

/*
 * ⥸塼ν
 * return : error number
 */
int sysInitModule(
	WaitAggrObj **o_waitObj,		// ޥեȹ¤
	WaitIdentObj **o_waitIdentObj)	// ̥ȹ¤
{
	WaitAggrObj *waitObj;
	WaitIdentObj *waitIdentObj;

	waitObj = kmalloc(sizeof(*waitObj));
	if (waitObj == NULL) {
		return -ENOMEM;
	}
	WaitAggrConstructor(waitObj);
	*o_waitObj = waitObj;

	waitIdentObj = kmalloc(sizeof(*waitIdentObj));
	if (waitIdentObj == NULL) {
		kfree(waitObj);
		return -ENOMEM;
	}
	WaitIdentConstruct(waitIdentObj);
	*o_waitIdentObj = waitIdentObj;

	// 桼⡼ɤɣľܤǤ褦ꤹ
	setUserModeIo();

	return NOERR;
}

/*
 * ⥸塼Ͽ
 * return : error number
 */
int sysRegistModule(
	const char *i_name)		// ⥸塼̾
{
	Module *this;

	if (vmIsReadArea(getVmProc(getCurrentProc()), i_name, sizeof(MODULE_NAME_MAX + 1)) == ERR) {
		return -EFAULT;
	}

	this = kmalloc(sizeof(*this));
	if (this == NULL) {
		return -ENOMEM;
	}
	ModuleConstructor(this, i_name, NULL, 0, NULL);

	return 0;
}

/*
 * ⥸塼ƤӽФԤ֤ˤ
 * return : error number
 */
int sysSleepModule()
{
	Module *this = searchTask(getCurrentTask());
//	if (this == NULL) {
//		return -ENOENT;
//	}

	// ƥץ
	procWakeParent(getCurrentProc());

	// 
	TaskWaitDaemon();

	// ⥸塼ǥХ
	ModuleDestructor(this);

	return NOERR;
}

/*
 * ⥸塼
 * return : error number
 */
int sysDeleteModule(
	const char *i_name)		// ⥸塼̾
{
	Module *module;
	ThreadObj *task;

	if (vmIsReadArea(getVmProc(getCurrentProc()), i_name, sizeof(MODULE_NAME_MAX + 1)) != NOERR) {
		return -EFAULT;
	}

	module = searchName(i_name);
	if (module == NULL) {
		return -ENOENT;
	}
	task = getTask(module);
	TaskWaitDaemonActiveSoon(getTaskWait(task));

	return NOERR;
}

int sysCdevswAttach(
	const char *devname, 
	struct _cdevsw *devsw, 
	const dev_t dev,
	void *returnMethod)
{
	Module *this;

	if (vmIsReadArea(getVmProc(getCurrentProc()), devname, sizeof(MODULE_NAME_MAX + 1)) == ERR) {
		return -EFAULT;
	}
	if (vmIsReadArea(getVmProc(getCurrentProc()), devsw, sizeof(*devsw)) == ERR) {
		return -EFAULT;
	}
	if (MODULE_NAME_MAX <= strnlen(devname, MODULE_NAME_MAX)) {
		return -ENAMETOOLONG;
	}
	
	this = kmalloc(sizeof(*this));
	if (this == NULL) {
		return -ENOMEM;
	}
	ModuleConstructor(this, devname, devsw, dev, returnMethod);

	// ǥХեϿ
	return makeDevfModule(devname, this, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP);
}

int sysBdevswAttach(
	const char *devname, 
	struct bdevsw *devsw, 
	int devmajor)
{
	return (0);
}

int devsw_detach()
{
	return 0;
}

//**************************************************************************************************

#ifdef DEBUG
void testModule()
{
}
#endif
