/*
 * Module.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */

#ifndef module_Module_h
#define module_Module_h

#ifndef ASM_FILE

enum {
	MODULE_NAME_MAX = 15,	// ⥸塼̾Хȿ
};

#ifdef KERNEL

#include <kern/device.h>

extern void ModuleInit();
extern int moduleOpenDev(void*, const int, void**);
extern int moduleCloseDev(void*, void*);
extern int moduleReadDev(void*, void*, const size_t, const off_t, void*);
extern int moduleWriteDev(void*, void*, const size_t, const off_t, void*);
extern int moduleIoctlDev(void*, const int, caddr_t, const int, void*);
extern int modulePollDev(void*, const int, void*);
extern void moduleStatDev(void*, DEV_STAT*);
extern int moduleWriteUio(void*, const off_t, const int, struct iovec*, const int);

#else

extern int initModule(void**, void**);
extern int registModule(const char *);
extern int sleepModule();
extern int deleteModule(const char *);
extern int cdevsw_attach(const char *devname, const struct cdevsw *devsw, int devmajor, void*);

#endif // KERNEL

#endif // ASM_FILE

#endif // module_Module_h
