/*
 * interrupt.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <machine/interrupt.h>
#include <machine/vm.h>
#include <sys/Thread.h>

#include <kern/debug.h>

//=====================================  ===================================================

/*
 * ߥǥץ
 */
typedef struct {
	ThreadObj	*task;			// ɥ饤С
	int (*handler)(void *);		// ߥϥɥ
	void		*arg;			// ߥϥɥѥ᡼
	void		*returnMethod;	// ߥϥɥ꥿᥽å
	void		*stackPoint;	// 桼ΰ襹åݥ
} IntrDescriptor;

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static IntrDescriptor intrDescriptor[IRQ_ENTRY];

static void IntrDscConstructor(
	IntrDescriptor *this,
	int (*i_handler)(void *), 
	void *i_arg,
	void *i_returnMethod)
{
	this->task = getCurrentTask();
	this->handler = i_handler;
	this->arg = i_arg;
	this->returnMethod = i_returnMethod;
	this->stackPoint = getUserStackPoint();
}

static void IntrDscDestructor(
	IntrDescriptor *this)
{
	// ⤷ʤ
}

//===================================== PUBLIC =====================================================

//--------------------------------------------------------------------------------------------------
// Getter
//--------------------------------------------------------------------------------------------------

ThreadObj *IntrDscGetTask(
	const int i_irq)
{
	return intrDescriptor[i_irq].task;
}

void *IntrDscGetHandler(
	const int i_irq)
{
	return intrDescriptor[i_irq].handler;
}

void *IntrDscGetArg(
	const int i_irq)
{
	return intrDescriptor[i_irq].arg;
}

void *IntrDscGetReturnMethod(
	const int i_irq)
{
	return intrDescriptor[i_irq].returnMethod;
}

void *IntrDscGetStackPoint(
	const int i_irq)
{
	return intrDescriptor[i_irq].stackPoint;
}

//--------------------------------------------------------------------------------------------------
// Setter
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Yes or No
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// Search
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
// System call
//--------------------------------------------------------------------------------------------------

/*
 * 桼ߥϥɥϿ
 *եåɤƤӽФ
 * return : error number
 */
int sysIntrEstablish(
	const int irq, 
	const int type, 
	const int level,
	int (*handler)(void *), 
	void *arg,
	void *returnMethod)		// Intr handler return method
{
	if (IRQ_ENTRY <= irq) {
		return -EINVAL;
	}

	IntrDscConstructor(&intrDescriptor[irq], handler, arg, returnMethod);
	release_irq_mask(irq);

	// 
	TaskWaitDaemon();

	return NOERR;
}

/*
 * ߥϥɥϿ
 * return : error number
 */
int sysIntrDisestablish(
	const uint irq)		// free an interrupt
{
	if (IRQ_ENTRY <= irq) {
		return -EINVAL;
	}

	// ϥɥ饿γǧ
	if (IntrDscGetTask(irq) != getCurrentTask()) {
		return -ENODEV;
	}

	IntrDscDestructor(&intrDescriptor[irq]);

	return NOERR;
}

//*****************************************************************************************************************

#ifdef DEBUG
int testInterrupt()
{
	return 0;
}
#endif
