/*
 * icmp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet controlMessage Protocl.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <lib/lib.h>
#include <machine/interrupt.h>
#include <machine/lock.h>
#include <kern/vm.h>
#include <kern/proc.h>
#include <kern/TaskWait.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <kern/ProcSignal.h>
#include <net/net.h>
#include <net/ip.h>
#include <net/icmp.h>
#include <net/netlib.h>

#include<kern/debug.h>

//#define DEBUG_ICMP 1
#ifdef DEBUG_ICMP
#define STATIC
#define INLINE
#else
#define STATIC	static
#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

static SOCKET waitSocket;	/* ȥåȥ */
static int waitGate;		/* 쥷ֽѥԥ󥲡 */

/*
 * Ԥåȥ󥯤³롣
 * Ǥ³ѤǤڤΥƤ³롣
 */
STATIC void setWaitLink(
	SOCKET *sock)
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&waitGate);
	{
		sock->next->prev = sock->prev;
		sock->prev->next = sock->next;
		sock->next = waitSocket.next;
		sock->prev = &waitSocket;
		waitSocket.next->prev = sock;
		waitSocket.next = sock;
	}
	exit_spinlock(&waitGate);
	exitCli(eflag);
}

/*
 * Ԥåȥ󥯤ڤΥ
 */
STATIC void resetWaitLink(
	SOCKET *sock)
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&waitGate);
	{
		sock->next->prev = sock->prev;
		sock->prev->next = sock->next;
		sock->next = sock->prev = sock;
	}
	exit_spinlock(&waitGate);
	exitCli(eflag);
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

/*
 * Transmit ICMP frame.
 * parameters : destination IP,type,code,ICMP head address,ICMP data size
 */
STATIC void transIcmp(uint dstip,uchar type,uchar code,ICMP_HEADER *head,int size)
{
	TRANS_BUF_INFO tbi;

	/* إåꡣ */
	head->type=type;
	head->code=code;
	head->chksum=0;
	head->chksum=calcSum((uint*)head,size);

	/* Хåեơ֥ */
	tbi.data[2]=NULL;
	tbi.size[2]=0;
	tbi.data[1]=(char*)head;
	tbi.size[1]=size;
	tbi.ipType=IPPROTO_ICMP;
/****************************************************************************
printk("TRANS ICMP type=%d,code=%d\n",head->type,head->code);
****************************************************************************/
	transIp(NULL, &tbi, dstip, 0);
}

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------

//Գ
// IPǡ򥻡֤롣
// ȥץϵ
// return : 0 or 1 = task switch
STATIC int saveRecv(struct mbuf *mbuf)
{
	SOCKET *sock;

	for (sock = waitSocket.next; sock != &waitSocket; sock = sock->next){
		/* åȤ */
		putRecvBuf(mbuf, &sock->recvBuf, &sock->lockGate);
		if (sock->waitTask != NULL){
			TaskAwakeSoon(getTaskWait(sock->waitTask));
			return 1;
		}
	}

	return 0;
}

/*
 * ǡ
 * return : error number
 */
STATIC int waitReceive(
	SOCKET *sock, 
	uint timeout)
{
	if (refRecvBuf(&sock->recvBuf) == NULL) {
		for (;;) {
			uint remainTime;

			// ʥߤ
			if(isSigint(TaskGetTaskSignal(getCurrentTask())) == YES) {
				return -EINTR;
			}

			// Ԥ
			sock->waitTask = getCurrentTask();
			remainTime = TaskWaitTimer(timeout);

			if (refRecvBuf(&sock->recvBuf) != NULL) {
				break;
			}
			if (remainTime == 0) {
				return -ETIMEDOUT;
			}
		}
	}

	return NOERR;
}

/*
 * 
 */
STATIC void initRecv()
{
	waitSocket.next = waitSocket.prev = &waitSocket;
}

//--------------------------------------------------------------------------------------------------
// åȥӥؿ
//--------------------------------------------------------------------------------------------------

STATIC int send(
	SOCKET *sock, 
	void *msg, 
	size_t len, 
	int flags, 
	struct sockaddr *to)
{
	TRANS_BUF_INFO tbi;
	ICMP_HEADER *icmp;

	/* Хåեơ֥ */
	tbi.data[2] = NULL;
	tbi.size[2] = 0;
	tbi.data[1] = (char*) msg;
	tbi.size[1] = len;
	tbi.ipType = IPPROTO_ICMP;
/****************************************************************************
{
	union{
		uint ui;
		uchar uc[4];
	}ip;
	uchar *ch = msg;
	int i;

	ip.ui = ((struct sockaddr_in*) to)->sin_addr.s_addr;
	printk("TRANS ICMP ip=%u.%u.%u.%u\n", ip.uc[0], ip.uc[1], ip.uc[2], ip.uc[3]);
	for (i = 0; i < len; ++i) {
		printf("%02x", ch[i]);
	}
	printk("\n");
}
****************************************************************************/
	icmp = (ICMP_HEADER*) msg;
	if (icmp->type == ICMP_TYPE_ECHOREQ) {
		setWaitLink(sock);
	}
	transIp(sock, &tbi, ((struct sockaddr_in*) to)->sin_addr.s_addr, 0);

	return len;
}


// return : copy data size or error number
STATIC int recv(SOCKET *sock,struct msghdr *msg)
{
	enum {
		REPLY_TIMEOUT = 2000	/* ॢȥߥá */
	};
	int dataSize,cpSize,iovArrey,iovOffset;
	struct mbuf *mbuf;
	IP_HEADER *ip;
	int error;

	/* ǡ */
	error = waitReceive(sock, REPLY_TIMEOUT);
	resetWaitLink(sock);
	if (error != NOERR){
		return error;
	}
	mbuf = refRecvBuf(&sock->recvBuf);

	/* ǡХåե˥ԡ */
	ip = getMbufDataPointer(mbuf);
	dataSize = getIpSize(ip) - mbuf->mh_offset;
	iovArrey = iovOffset = 0;
	cpSize = copyIovec((char*)ip + mbuf->mh_offset, dataSize, msg->msg_iov, msg->msg_iovlen, &iovArrey, &iovOffset);
	if (iovArrey == msg->msg_iovlen){
		// 桼ХåեäѤäƥԡޤEOF뤿IPХåեϻĤƤ
		mbuf->mh_offset += cpSize;
		return cpSize;
	}

	sock->dstip = ip->srcip;

	/* IPХåե */
	detachRecvBuf(mbuf, &sock->recvBuf, &sock->lockGate);
	m_freem(mbuf);

	return dataSize;
}


STATIC int connect(SOCKET *a)
{
	return -EOPNOTSUPP;
}

STATIC int shutdown(SOCKET *sock,int flag)
{
	return -EOPNOTSUPP;
}

STATIC int listen(SOCKET *a,int fd)
{
	return -EOPNOTSUPP;
}

STATIC int accept(SOCKET *sock,SOCKET **newsock,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}

STATIC int poll(SOCKET *sock, int events)
{
	if (events & (POLLIN | POLLRDNORM | POLLRDBAND | POLLPRI)) {
		if (refRecvBuf(&sock->recvBuf) != NULL){
			return POLLIN | POLLRDNORM | POLLRDBAND | POLLPRI;
		}
		else{
			sock->waitTask = getCurrentTask();
			return 0;
		}
	}
	if (events & (POLLOUT | POLLWRNORM | POLLWRBAND)) {
			return POLLOUT | POLLWRNORM | POLLWRBAND;
	}
	
	return 0;
}

STATIC SOCKET_INFO sockInfo = {send, recv, connect, shutdown, listen, accept, poll};

//===================================== PUBLIC =====================================================

// Init ICMP.
int initIcmp()
{
	registSocket(&sockInfo, IPPROTO_ICMP);
	initRecv();

	return 0;
}

//Գ
// Receive ICMP frame.
// return : 0 or task switch = 1
int receiveIcmp(struct mbuf *mbuf)
{
	IP_HEADER *ip = getMbufDataPointer(mbuf);
	ICMP_HEADER *icmp = (ICMP_HEADER*)ip->data;
	int icmpSize = getIpSize(ip) - sizeof(IP_HEADER);

/****************************************************************************************************************
{
	union{
		uint ui;
		uchar uc[4];
	}src_ip;

	src_ip.ui = ip->srcip;
	printk("receiveIcmp() ip=%u.%u.%u.%u\n", src_ip.uc[0],src_ip.uc[1],src_ip.uc[2],src_ip.uc[3]);
}
****************************************************************************************************************/
	/* åγǧ */
	if (calcSum((uint*)icmp, icmpSize)){
		return 0;
	}

	switch (icmp->type) {
		case ICMP_TYPE_ECHOREQ:
			setIpTask(NULL, mbuf);
			break;
		case ICMP_TYPE_ECHOREP:
			return saveRecv(mbuf);
	}

	return 0;
}

/*
 * IPåɤƤӽФ
 */
void doIcmpService(SOCKET *sock, IP_HEADER *ip)
{
	ICMP_HEADER *icmp = (ICMP_HEADER*)ip->data;

	if (sock == NULL){
		transIcmp(ip->srcip, ICMP_TYPE_ECHOREP, 0, icmp,getIpSize(ip) - sizeof(IP_HEADER));
	}
}

void releaseSockIcmp(SOCKET *sock)
{
	resetWaitLink(sock);
}
