/*
 * netlib.c
 *
 * Copyright 2005, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <net/net.h>
#include <net/netlib.h>
#include <kern/time.h>

#include <kern/debug.h>


//#define DEBUG_NETLIB 1
#ifdef DEBUG_NETLIB
	#define STATIC
	#define INLINE
#else
	#define STATIC static
	#define INLINE	inline
#endif


/***********************************************************************************
 *
 * å
 *
 ***********************************************************************************/


/*
 * åη׻
 * parameters : data1 address,data2 address,byte size1,byte size2
 * return : פ
 */
ushort calcSum(uint *data,int size)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64 = 0;
	for (;sizeof(uint) <= size; size -= sizeof(uint)) {
		sum.u64 += *data++;
	}
	if (0 < size) {
		sum.u64 += *data & ((1 << (size * 8)) - 1);
	}

	tmp = sum.u32[1];
	sum.u32[1] = 0;
	sum.u64 += tmp;
	tmp = sum.u32[1];
	sum.u32[1] = 0;
	sum.u32[0] += tmp;

	tmp = sum.u16[1];
	sum.u16[1] = 0;
	sum.u32[0] += tmp;
	tmp = sum.u16[1];
	sum.u16[1] = 0;
	sum.u16[0] += tmp;

	return ~sum.u16[0];
}

/*
 * Note!
 *  size1uintǳڤˤƤ롣
 */
ushort calcSumM(uint *data1,uint *data2,int size1,int size2)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	} sum;
	uint tmp;

	sum.u64 = 0;
	for (;sizeof(uint) <= size1; size1 -= sizeof(uint)) {
		sum.u64 += *data1++;
	}
	for (;sizeof(uint) <= size2; size2 -= sizeof(uint)) {
		sum.u64 += *data2++;
	}
	if (0 < size2) {
		sum.u64 += *data2 & ((1 << (size2 * 8)) - 1);
	}

	tmp = sum.u32[1];
	sum.u32[1] = 0;
	sum.u64 += tmp;
	tmp = sum.u32[1];
	sum.u32[1] = 0;
	sum.u32[0] += tmp;

	tmp = sum.u16[1];
	sum.u16[1] = 0;
	sum.u32[0] += tmp;
	tmp = sum.u16[1];
	sum.u16[1] = 0;
	sum.u16[0] += tmp;

	return ~sum.u16[0];
}

/************************************************************************************
 *
 * åȥץ
 *
 ************************************************************************************/

//================================== PRIVATE ============================================

/*
 * åȥ٥륪ץ
 * return : 0 or error number
 */
static int setSockOpt(SOCKET *sock, int optName, const int *optVal, int optLen)
{
	switch (optName){
		case SO_TIMESTAMP:
			// 
		case SO_REUSEADDR:
			if (optLen < sizeof(int)){
				return -EINVAL;
			}
			switch (*optVal){
				case 1:
					sock->sockOpt.name |= optName;
					break;
				case 0:
					sock->sockOpt.name &= ~optName;
					break;
				default:
					return -EINVAL;
			}
			break;
		default:
			return -ENOPROTOOPT;
	}

	return 0;
}

/*
 * IP٥륪ץ
 * return : 0 or error number
 */
static int setIpOpt(SOCKET *sock, int optName, const int *optVal, int optLen)
{
	switch (optName){
		case IP_TOS:
			if (optLen < sizeof(int)){
				return -EINVAL;
			}
			sock->ipOpt.name = optName;
			sock->ipOpt.value = *optVal;
			break;
		default:
			return -ENOPROTOOPT;
	}

	return 0;
}

//================================== PUBLIC =============================================

/*
 * åȥץμ
 */
int getOpt(SOCKET *sock, int level, int optName, int *optVal, int *optLen)
{

	return -ENOPROTOOPT;
}

/*
 * åȥץ
 */
int setOpt(SOCKET *sock, int level, int optName, const int *optVal, int optLen)
{
	switch (level){
		case SOL_SOCKET:
			return setSockOpt(sock, optName, optVal, optLen);
		case IPPROTO_IP:
			return setIpOpt(sock, optName, optVal, optLen);
		default:
			return -ENOPROTOOPT;
	}
	
	return 0;
}

/*
 * åȥץμ¹
 * return : 0
 */
void doSockOpt(SOCKET *sock, caddr_t cmsghdr, u_int cmsgLen)
{
	struct timeval timeval;
	struct cmsghdr *cmsg = (struct cmsghdr*)cmsghdr;
	
	if (sock->sockOpt.name & SO_TIMESTAMP){
		/* åĹγǧ */
		if (cmsgLen < sizeof(struct cmsghdr) + sizeof(struct timeval)){
			cmsg->cmsg_len = 0;
			return;
		}

		/* μ */
		gettimeofday(&timeval);
		cmsg->cmsg_level = SOL_SOCKET;
		cmsg->cmsg_type = SCM_TIMESTAMP;
		cmsg->cmsg_len = sizeof(struct cmsghdr) + sizeof(struct timeval);
		memcpy(CMSG_DATA(cmsg), &timeval, sizeof(struct timeval));
	}
}
