/*
 * Copyright (c) 1980, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)route.h	8.4 (Berkeley) 1/9/95
 * $FreeBSD: src/sys/net/route.h,v 1.36.2.5 2002/02/01 11:48:01 ru Exp $
 */

#ifndef _NET_ROUTE_H_
#define _NET_ROUTE_H_


#include <sys/cdefs.h>
#include <sys/socket.h>
//#include <sys/mbuf.h>
#include <net/radix.h>


struct mbuf;


/*
 * Index offsets for sockaddr array for alternate internal encoding.
 */
#define RTAX_DST		0	/* destination sockaddr present */
#define RTAX_GATEWAY	1	/* gateway sockaddr present */
#define RTAX_NETMASK	2	/* netmask sockaddr present */
#define RTAX_GENMASK	3	/* cloning mask sockaddr present */
#define RTAX_IFP		4	/* interface name sockaddr present */
#define RTAX_IFA		5	/* interface addr sockaddr present */
#define RTAX_AUTHOR		6	/* sockaddr for author of redirect */
#define RTAX_BRD		7	/* for NEWADDR, broadcast or p-p dest addr */
#define RTAX_MAX		8	/* size of array to allocate */


struct rt_addrinfo {
	int				rti_addrs;
	struct sockaddr	*rti_info[RTAX_MAX];
	int				rti_flags;
	struct ifaddr	*rti_ifa;
	struct ifnet	*rti_ifp;
};


/*
 * These numbers are used by reliable protocols for determining
 * retransmission behavior and are included in the routing structure.
 */
struct rt_metrics {
	u_long	rmx_locks;		/* Kernel must leave these values alone */
	u_long	rmx_mtu;		/* MTU for this path */
	u_long	rmx_hopcount;	/* max hops expected */
	u_long	rmx_expire;		/* lifetime for route, e.g. redirect */
	u_long	rmx_recvpipe;	/* inbound delay-bandwidth product */
	u_long	rmx_sendpipe;	/* outbound delay-bandwidth product */
	u_long	rmx_ssthresh;	/* outbound gateway buffer limit */
	u_long	rmx_rtt;		/* estimated round trip time */
	u_long	rmx_rttvar;		/* estimated rtt variance */
	u_long	rmx_pksent;		/* packets sent using this route */
	u_long	rmx_filler[4];	/* will be used for T/TCP later */
};

/*
 * We distinguish between routes to hosts and routes to networks,
 * preferring the former if available.  For each route we infer
 * the interface to use from the gateway address supplied when
 * the route was entered.  Routes that forward packets through
 * gateways are marked so that the output routines know to address the
 * gateway rather than the ultimate destination.
 */
struct rtentry {
	struct radix_node	rt_nodes[2];	/* tree glue, and other values */
#define	rt_key(r)	((struct sockaddr *)((r)->rt_nodes->rn_key))
#define	rt_mask(r)	((struct sockaddr *)((r)->rt_nodes->rn_mask))
	struct sockaddr		*rt_gateway;	/* value */
	long				rt_refcnt;		/* # held references */
	u_long				rt_flags;		/* up/down?, host/net */
	struct ifnet		*rt_ifp;		/* the answer: interface to use */
	struct ifaddr		*rt_ifa;		/* the answer: interface to use */
	struct sockaddr		*rt_genmask;	/* for generation of cloned routes */
	caddr_t				rt_llinfo;		/* pointer to link level info cache */
	struct rt_metrics	srt_rmx;		/* metrics used by rx'ing protocols */
	struct rtentry		*rt_gwroute;	/* implied entry for gatewayed routes */
	int	(*rt_output) __P((struct ifnet *, struct mbuf *, struct sockaddr *, struct rtentry *));	/* output routine for this (rt,if) */
	struct rtentry		*rt_parent; 	/* cloning parent of this route */
	void				*rt_filler2;	/* more filler */
};


#endif
