/*
 * udp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * User datagram Protocl.
 */


#include <sys/types.h>
#include <sys/param.h>
#include <sys/mbuf.h>
#include <lib/lib.h>
#include <machine/interrupt.h>
#include <machine/lock.h>
#include <kern/vm.h>
#include <sys/Thread.h>
#include <kern/TaskWait.h>
#include <kern/time.h>
#include <kern/ProcSignal.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <net/net.h>
#include <net/ip.h>
#include <net/ethernet.h>
#include <net/udp.h>
#include <net/netlib.h>


//#define DEBUG_UDP 1
#ifdef DEBUG_UDP
	#define STATIC
#else
	#define STATIC static
#endif


/**************************************************************************
 *
 * 
 *
 **************************************************************************/

//================================== PRIVATE ============================================

static SOCKET waitSocket;	/* ȥåȥ󥯡 */
static int waitGate;		/* ͥѥåȡ */

/*
 * Ԥåȥ󥯤³롣
 * Ǥ³ѤǤڤΥƤ³롣
 */
STATIC void setWaitLink(SOCKET *sock)
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&waitGate);
	{
		sock->next->prev = sock->prev;
		sock->prev->next = sock->next;
		sock->next = waitSocket.next;
		sock->prev = &waitSocket;
		waitSocket.next->prev = sock;
		waitSocket.next = sock;
	}
	exit_spinlock(&waitGate);
	exitCli(eflag);
}

/*
 * Ԥåȥ󥯤ڤΥ
 * parameters : socket
 */
STATIC void resetWaitLink(SOCKET *sock)
{
	int eflag;

	eflag = enterCli();
	enter_spinlock(&waitGate);
	{
		sock->next->prev = sock->prev;
		sock->prev->next = sock->next;
		sock->next = sock->prev = sock;
	}
	exit_spinlock(&waitGate);
	exitCli(eflag);
}

/*
 *Զ
 * Save receive data.
 * return : 0 or task switch = 1
 */
STATIC int saveRecv(struct mbuf *mbuf)
{
	SOCKET *sock;
	IP_HEADER *ip = getMbufDataPointer(mbuf);
	UDP_HEADER *udp = (UDP_HEADER*)ip->data;

	for (sock = waitSocket.next; sock != &waitSocket; sock = sock->next){
		/* åȤ */
		if (sock->srcport == udp->dstport){
			putRecvBuf(mbuf, &sock->recvBuf, &sock->lockGate);
			if (sock->waitTask != NULL){
				TaskAwakeSoon(getTaskWait(sock->waitTask));
				return 1;
			}
			return 0;
		}
	}

	// Ĥ餺
	setIpTask(NULL, mbuf);

	return 0;
}

//================================== PROTECTED ==========================================

/*
 * ǡ
 * return : error number
 */
STATIC int waitReceive(
	SOCKET *sock,
	uint timeout)
{
	if (refRecvBuf(&sock->recvBuf) == NULL) {
		for (;;) {
			uint remainTime;

			// ʥߤ
			if (isSigint(TaskGetTaskSignal(getCurrentTask())) == YES) {
				return -EINTR;
			}

			// Ԥ
			sock->waitTask = getCurrentTask();
			remainTime = TaskWaitTimer(timeout);

			if (refRecvBuf(&sock->recvBuf) != NULL) {
				break;
			}
			if (remainTime == 0) {
				return -ETIMEDOUT;
			}
		}
	}

	return NOERR;
}

/*
 * 
 */
STATIC void initRecv()
{
	waitSocket.next = waitSocket.prev = &waitSocket;
}

//================================== PUBLIC =============================================


//Գ
// Receive UDP frame.
// return : 0 or task switch=1
int receiveUdp(struct mbuf *mbuf)
{
	PSEUDO_HEADER pshead;
	IP_HEADER *ip = getMbufDataPointer(mbuf);
	UDP_HEADER *udp = (UDP_HEADER*)ip->data;

/*********************************************************************************************
if (ip->srcip == 0x40019ac)
{
	union{
		uint ui;
		uchar uc[4];
	}src_ip;

	src_ip.ui = ip->srcip;
	printk("RECV UDP srcport=%x,dstport=%x,length=%d,ip=%u.%u.%u.%u\n",
		swapWord(udp->srcport),swapWord(udp->dstport),swapWord(udp->len),
		src_ip.uc[0],src_ip.uc[1],src_ip.uc[2],src_ip.uc[3]);
}
**********************************************************************************************/
	/* åγǧ */
	pshead.srcip=ip->srcip;
	pshead.dstip=ip->dstip;
	pshead.tmp=0;
	pshead.prot=ip->prot;
	pshead.len=udp->len;
	if (calcSumM((uint*)&pshead,(uint*)udp,sizeof(PSEUDO_HEADER),swapWord(udp->len)))
		return 0;

	return saveRecv(mbuf);
}


/**************************************************************************
 *
 * UDPӥؿ
 *
 **************************************************************************/


//================================== PRIVATE ============================================


STATIC int sendNotReach()
{
	// ̤
	return 0;
}


//================================== PUBLIC =============================================


// IPåɤƤӽФ
void doUdpService(SOCKET *sock, IP_HEADER *ip)
{
	if (sock == NULL){
		sendNotReach();
	}
}


void releaseSockUdp(SOCKET *sock)
{
	resetWaitLink(sock);
}


/**************************************************************************
 *
 * åȥӥؿ
 *
 **************************************************************************/


STATIC int send(SOCKET *sock, void *msg, size_t len, int flags, struct sockaddr *to)
{
	char head[sizeof(PSEUDO_HEADER) + sizeof(UDP_HEADER)];
	PSEUDO_HEADER *pshead;
	UDP_HEADER *udp;
	TRANS_BUF_INFO tbi;

	/* Set pseudo header. */
	pshead = (PSEUDO_HEADER*)head;
	if (to == NULL){
		pshead->dstip = sock->dstip;
	}
	else{
		pshead->dstip = ((struct sockaddr_in*)to)->sin_addr.s_addr;
	}
	pshead->srcip = getEtherIp(getEtherNum(pshead->dstip));
	pshead->tmp = 0;
	pshead->prot = IPPROTO_UDP;
	pshead->len = swapWord(len + sizeof(UDP_HEADER));

	/* Set UDP head. */
	udp = (UDP_HEADER*)(head + sizeof(PSEUDO_HEADER));
	udp->srcport = sock->srcport;
	if (to == NULL){
		udp->dstport = sock->dstport;
	}
	else{
		udp->dstport = ((struct sockaddr_in*)to)->sin_port;
	}
	udp->len = swapWord(len + sizeof(UDP_HEADER));
	udp->chksum = 0;
	udp->chksum = calcSumM((uint*)head, (uint*)msg, sizeof(PSEUDO_HEADER) + sizeof(UDP_HEADER), len);

	/* Хåեơ֥ */
	tbi.data[2] = (char*)msg;
	tbi.size[2] = len;
	tbi.data[1] = (char*)udp;
	tbi.size[1] = sizeof(UDP_HEADER);
	tbi.ipType = IPPROTO_UDP;
/********************************************************************************************
{
	union{
		uint ui;
		uchar uc[4];
	}dst_ip;

	dst_ip.ui = sock->dstip;
	printk("TRANS UDP srcport=%x,dstport=%x,length=%d,ip=%u.%u.%u.%u\n",
		swapWord(udp->srcport),swapWord(udp->dstport),swapWord(udp->len),
		dst_ip.uc[0],dst_ip.uc[1],dst_ip.uc[2],dst_ip.uc[3]);
}
*********************************************************************************************/
	transIp(sock, &tbi, pshead->dstip, 0);

	return len;
}

/*
 * return : copy data size or error number
 */
STATIC int recv(SOCKET *sock, struct msghdr *msg)
{
	enum {
		REPLY_TIMEOUT = 1000000			// ॢms
	};
	int dataSize, cpSize, iovArrey, iovOffset;
	struct mbuf *mbuf;
	IP_HEADER *ip;
	UDP_HEADER *udp;
	int error;

	/* ǡ */
	setWaitLink(sock);
	error = waitReceive(sock, REPLY_TIMEOUT);
	if (error != NOERR){
		return error;
	}
	mbuf = refRecvBuf(&sock->recvBuf);

	/* ǡХåե˥ԡ */
	ip = getMbufDataPointer(mbuf);
	udp = (UDP_HEADER*)ip->data;
	dataSize = swapWord(udp->len) - sizeof(UDP_HEADER) - mbuf->mh_offset;
	iovArrey = iovOffset = 0;
	cpSize = copyIovec(udp->data + mbuf->mh_offset, dataSize, msg->msg_iov, msg->msg_iovlen, &iovArrey, &iovOffset);
	if (iovArrey == msg->msg_iovlen){
		// 桼ХåեäѤäƥԡޤEOF뤿IPХåեϻĤƤ
		mbuf->mh_offset += cpSize;
		return cpSize;
	}

	sock->dstip = ip->srcip;
	sock->dstport = udp->srcport;

	/* IPХåե */
	detachRecvBuf(mbuf, &sock->recvBuf, &sock->lockGate);
	m_freem(mbuf);

	return dataSize;
}


STATIC int connect(SOCKET *sock)
{
	setWaitLink(sock);
	
	return 0;
}

STATIC int listen(SOCKET *sock,int fd)
{
	return -EOPNOTSUPP;
}

STATIC int accept(SOCKET *sock,SOCKET **newSock,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}

STATIC int shutdown(SOCKET *sock,int flag)
{
	return -EOPNOTSUPP;
}

STATIC int poll(SOCKET *sock, int events)
{
	if (events & (POLLIN | POLLRDNORM | POLLRDBAND | POLLPRI)) {
		if (refRecvBuf(&sock->recvBuf) != NULL){
			return POLLIN | POLLRDNORM | POLLRDBAND | POLLPRI;
		}
		else{
			sock->waitTask = getCurrentTask();
			setWaitLink(sock);
			return 0;
		}
	}
	if (events & (POLLOUT | POLLWRNORM | POLLWRBAND)) {
			return POLLOUT | POLLWRNORM | POLLWRBAND;
	}
	
	return 0;
}

/**************************************************************************
 *
 * 
 *
 **************************************************************************/

//================================== PRIVATE ============================================


STATIC SOCKET_INFO sockInfo = {send, recv, connect, shutdown, listen, accept, poll};


//================================== PUBLIC =============================================


// Init UDP.
int initUdp()
{
	registSocket(&sockInfo,IPPROTO_UDP);
	initRecv();

	return 0;
}
