/*
 * setup2.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ᥤץ
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/module.h>
#include <sys/conf.h>
#include <sys/mbuf.h>
#include <sys/Thread.h>
#include <machine/Except.h>
#include <machine/pc.h>
#include <machine/pcibus.h>
#include <machine/bios.h>
#include <machine/apm.h>
#include <machine/fpu.h>
#include <machine/tss.h>
#include <machine/Cpu.h>
#include <machine/lib.h>
#include <machine/Entry.h>
#include <machine/interrupt.h>
#include <dev/pci/pci.h>
#include <dev/console/console.h>
#include <dev/MC146818.h>
#include <dev/8254.h>
#include <dev/serial.h>
#include <dev/miscdev.h>
#include <fs/ext2.h>
#include <isa/isavar.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <lib/lib.h>
#include <machine/sp.h>
#include <machine/mp.h>
#include <kern/PhysMem.h>
#include <kern/BufPool.h>
#include <kern/BlockCache.h>
#include <kern/page_swap.h>
#include <kern/fs.h>
#include <kern/vfs.h>
#include <kern/Hierarchy.h>
#include <kern/proc.h>
#include <kern/ProcSignal.h>
#include <kern/device.h>
#include <kern/devfs.h>
#include <kern/time.h>
#include <kern/timer.h>
#include <kern/term.h>
#include <kern/syscall.h>
#include <module/Module.h>

#include <kern/debug.h>


//===================================== Х륤ݡ =======================================

extern void init_syscall();
extern int setupDriver();

//===================================== PRIVATE ====================================================

//===================================== PUBLIC =====================================================

void main()
{
//*************************************************
	saveRealIdt();
//*************************************************
	EntryInit();

	// 㳰ϥɥꤹ
	init_except();

	// 󥽡ν
	initConsole();

	// TSSǥץɤ
	initTss(0);

	// 塼ν
	initSchedule(0);

	// CPUǽγǧ
	{
		Cpu cpu;

		if (CpuConstructor(&cpu) != NOERR) {
			panic("This cpu is not supported file=%s line=%d", __FILE__, __LINE__);
		}
		if (cpu.isSupportCpu(&cpu) == NO) {
			panic("This cpu is not supported file=%s line=%d", __FILE__, __LINE__);
		}
		if (cpu.isSupportSysenter(&cpu) == YES) {
			cpu.setSysenter(&cpu);
			changeUserCall();
		}
	}

	// PCν
	if (initPc() != NOERR){
		panic("init PC error file=%s line=%d", __FILE__, __LINE__);
	}

	/* APMν */
	InitApm();

	/* fpuν */
	initFpu();

	/* ʪ꡼ν */
	PhysMemInit();

	// ޡν
	initTime();
	initTimer();

	// cpuåͤ¬
	printk("cpu0 clock = %d HZ\n", calcCpuClock());

	if (VmInit() != NOERR) {
		panic("createIdleProc error file=%s line=%d", __FILE__, __LINE__);
	}

	if (HierarInit() != NOERR) {
		panic("HierarInit error file=%s line=%d", __FILE__, __LINE__);
	}

	if (ProcSignalInit() != NOERR) {
		panic("ProcSignalInit error file=%s line=%d", __FILE__, __LINE__);
	}

	// ɥץʺǽΥץˤ
	if (createIdleProc(0) != NOERR){
		panic("createIdleProc error file=%s line=%d", __FILE__, __LINE__);
	}

	// ߤSMP
	if (isMp() == YES) {
		if (init_mp() != NOERR){
			panic("Init mp error file=%s line=%d", __FILE__, __LINE__);
		}
	}
	else {
		if (init_sp() != NOERR){
			panic("Init sp error file=%s line=%d", __FILE__, __LINE__);
		}
	}

	// 󥿡Х륿ޡν
	initIntervalTimer();

	// ꥢ륯åޡν
	initRealTimer();
	
	/* Init system call. */
	init_syscall();
}

void init()
{
	int rest;
	int error;

	sti();

	// Initץ
	rest = sys_fork();
	if (rest < 0){
		panic("Init process fork error file=%s line=%d", __FILE__, __LINE__);
	}
	else if (0 < rest) {
		// ɥ롼׳
		startIdle();
	}
	setInitProc();
//**************************************************************************************************
	setUserStackPoint(USER_ESP_BEG);
//**************************************************************************************************

	error = initDevice();
	if (error != NOERR) {
		panic("Init device error file=%s line=%d", __FILE__, __LINE__);
	}

	// BIOSطν
	bios32_init();
	
	// Хåեסν
	BufPooInit();

	// mbufν
	initMbuf();

	// ۥե륷ƥν
	VfsInit();

	/* ǥХե륷ƥν */
	initDeviceFs();

	// ⥸塼ν
	ModuleInit();

//**************************************************************************************************
	// 롼ȥե륷ƥफɤǤʤɥ饤Сɤ롣
	// i386/Entry_asm.SdevIrq14,devIrq15ѹɬ
	error = setupDriver();
	if (error != NOERR) {
		panic("setupDriver error : %d file=%s line=%d", error, __FILE__, __LINE__);
	}
//**************************************************************************************************

	// ISAХν
	if (initIsa() != NOERR){
		printk("Failed initialize isa!\n");
	}

	// PCIХν
	// ȤꤢĤPCIɥ饤С롢FreeBSDΥɥ饤С줹
	initPci();
	if (initPciNew() != NOERR){
		printk("Failed initialize pci!\n");
	}

	/* init serial. */
	init_com();

	// ֥ååν
	if (BlockCacheInit() != NOERR) {
		printk("Failed BlockCacheInit!\n");
	}

	/* Set COM interrupt. */
	set_com_intr();

	// եåԡɥ饤СȤ߹
	{
		extern int fdc_isaInitDevice();
		extern int fd_fdcInitDevice();
		
		rest = fdc_isaInitDevice();
		if (rest < 0){
			printk("Failed initialize fdc driver!\n");
		}
		else{
			rest = fd_fdcInitDevice();
		}
		if (rest < 0){
			printk("Failed initialize fd driver!\n");
		}
	}

	/* 󥽡ΥǥХϿ */
	if((rest = registConsole())<0){
		panic("Regist console error file=%s line=%d", __FILE__, __LINE__);
	}

	/* NULLǥХϿ */
	if ((rest = registNullDev()) < 0){
		panic("Regist NullDev error file=%s line=%d", __FILE__, __LINE__);
	}

	/* EXT2ե륷ƥν */
	if ((rest = initExt2tFs()) < 0){
		panic("Init Ext2  error file=%s line=%d", __FILE__, __LINE__);
	}

	/* ڡѵΰν */
	if ((rest = initBackupDev(PAGING_BACKUP_DEVICE)) < 0){
		panic("Init backupDev error file=%s line=%d", __FILE__, __LINE__);
	}
	printk("Page backup device : %s\n",PAGING_BACKUP_DEVICE);

	/* mount root filesystem. */
	error = sys_mount(ROOT_DEVICE, "ext2", "/");
	if (error != NOERR) {
		panic("Mount error. error=%d file=%s line=%d", error, __FILE__, __LINE__);
	}
	printk("Root device : %s\nRoot file system : ext2\n",ROOT_DEVICE);

	/* mount device filesystem. */
	if (sys_mount("/dev", DEV_FS_NAME, "/dev") != NOERR) {
		panic("Mount error file=%s line=%d", __FILE__, __LINE__);
	}

	/* Init keyboard driver. */
//	initKeyboard();

	/* ͥåȥν  */
	initNet();

	/* ͥåȥɥ饤Сν */
	rest = initEther();
	if(rest != NOERR){
		panic("Init Ether error file=%s line=%d", __FILE__, __LINE__);
	}

	// initץ¹
	{
		char *program = "/sbin/init";
		char *argv[] = {program, NULL};
		char *envp[] = {NULL};

		rest = startExec(program, argv, envp);
		if (rest < 0){
			panic("Exec init error file=%s line=%d", __FILE__, __LINE__);
		}
	}
	// ˤäƤʤ
}
