/*
 * setupDriver.c
 *
 * Copyright 2009, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գסե롼ȥե륷ƥफɤǤʤɥ饤С̾Υɥ饤С˥ɤ롣
 *
 *ղۥե륷ƥबȤ뤳ȡ
 */

#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <fs/Bootfs.h>
#include <Module/Module.h>
#include <kern/fs.h>
#include <kern/proc.h>

#include <kern/debug.h>

//#define DEBUG_SETUPDRIVER 1
#ifdef DEBUG_SETUPDRIVER
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif

//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * Bootfsˤɥ饤С򥹥Ȥ
 * return : error number
 */
static int startDriver()
{
	int error;
	char name[MODULE_NAME_MAX + 2] = {'/'};
	char *argv[] = {name, NULL};
	char *envp[] = {NULL};
	int fd = sys_opendir("/");

	if (fd < 0) {
		return fd;
	}

	for (error = sys_readdir(fd, &name[1]) ; (error == NOERR) && (name[1] != '\0'); error = sys_readdir(fd, &name[1])) {
		int pid = sys_fork();
		if (0 < pid) {
			// sysSleepModule()ǵ
			sys_wait(pid, NULL, 0);
		}
		else if (0 == pid) {
			error = startExec(name, argv, envp);

			// äƤʤϤ
			return error;
		}
		else if (pid < 0) {
			return pid;
		}
	}
	
	error = sys_close(fd);
	if (error != NOERR) {
		return error;
	}

	return NOERR;
}

//===================================== PUBLIC =====================================================

/*
 * ɥ饤СBootfsɤ
 * return : error number
 */
int setupDriver()
{
	int error;

	// BootfsޥȤ
	error = BootfsInit();
	if (error != NOERR) {
		return error;
	}
	error = sys_mount(NULL, "bootfs", "/");
	if (error != NOERR) {
		return error;
	}

	error = startDriver();
	if (error != NOERR) {
		return error;
	}

	error = sys_umount("/");
	if (error != NOERR) {
		return error;
	}
	
	return NOERR;
}
