/*
 * Thread.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef sys_Thread_h
#define sys_Thread_h


#include <sys/types.h>

#ifdef KERNEL
#include <lib/List.h>
#include <machine/Entry.h>
#include <kern/timer.h>
#include <kern/vm.h>
#include <kern/TaskWait.h>
#include <kern/TaskSignal.h>
#endif

// 
#define TASK_RUNNING		0x01		// ¹Բ
#define TASK_WAIT			0x02		// Ԥ
#define TASK_INTR_WAIT		0x04		// Ԥ
#define TASK_SIGNAL_STOP	0x08		// ʥˤ
#define TASK_TRACE			0x10		// ȥ졼
#define TASK_EXIT			0x20		// Exit
#define TASK_CHILD_WAIT		0x40		// wait callԤ

#ifndef ASM_FILE

#ifdef KERNEL

/*
 * 桼åɥ֥
 *աեϰפƤʤΤǡݥ󥿤ȤƤΤ߻Ѥ뤳
 */
typedef struct {
	char dummy[sizeof(int) * 1];
} ThreadObj;

// 塼
extern void initSchedule(int);
extern void setFirstTask(const int, ThreadObj*);
extern int addToSchedule(ThreadObj*, const int);
extern int addScheduleSoon(ThreadObj*, const int);
extern void delFromSchedule(const int);
extern void changeTask(ThreadObj*);
extern void addScheduleDaemon(ThreadObj*);
extern void *switchTask();
extern void addNewTask(ThreadObj*);
extern ThreadObj *getCurrentTask();

// 
extern int getTaskState(ThreadObj*);
extern VmTaskObj *getVmTask(ThreadObj*);
extern EntryObj *getEntry(ThreadObj*);
extern TaskWaitObj *getTaskWait(ThreadObj*);
extern int getIrqTask(ThreadObj*);
extern ThreadObj *getCallTask(ThreadObj*);
extern ThreadObj *getCallDstTask(ThreadObj*);
extern void setIrqTask(ThreadObj*, const int);
extern void setCallTask(ThreadObj*);
extern void *changeCallTask();
extern void *restoreCallTask();
extern TIMER_OWNER *getTaskTimer(ThreadObj*);
extern TaskSignalObj *TaskGetTaskSignal(ThreadObj*);
extern void incrementNest();
extern void decrementNest();
extern int isNest();
extern void calcTaskUserTime();
extern void calcTaskSysTime();
extern void setTaskCurrentTime();
extern void taskExit();

// å
extern pthread_t threadGetId(ThreadObj*);
extern pthread_t threadGetJoinId(ThreadObj*);
extern List *getProcList(ThreadObj*);
extern void *ThreadGetProc(ThreadObj*);
extern uint64 getUserClocks(ThreadObj*);
extern uint64 getSysClocks(ThreadObj*);
extern int createIdleThread(const int, void*, ThreadObj**);
extern int forkThread(const int, void*, void*, void*, ThreadObj**);
extern void freeThread(ThreadObj*, VmProcObj*);

// ƥॳ
extern int sys_pthread_create();
extern int sys_pthread_join();
extern void sys_pthread_exit();
extern int sys_pthread_self();

#ifdef DEBUG
extern void monitorSchedule(const int);
extern void displaySchedule();
#endif

#endif // KERNEL

#endif // ASM_FILE

#endif // sys_Thread_h
