/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)conf.h	8.5 (Berkeley) 1/9/95
 * $FreeBSD: src/sys/sys/conf.h,v 1.103.2.6 2002/03/11 01:14:55 dd Exp $
 */


#ifndef _SYS_CONF_H_
#define	_SYS_CONF_H_


#include <sys/types.h>
#include <sys/uio.h>
#include <sys/buf.h>
#include <lib/AggregateList.h>


#ifndef ASM_FILE


// ߡ
struct knote{
	void *dummy;
};
typedef struct proc d_thread_t;


/*
 * XXX: This included for when DEVFS resurfaces 
 */
#define	UID_ROOT		0
#define	UID_BIN			3
#define	UID_UUCP		66
#define	GID_WHEEL		0
#define	GID_KMEM		2
#define	GID_OPERATOR	5
#define	GID_BIN			7
#define	GID_GAMES		13
#define	GID_DIALER		68

/*
 * Types for d_flags.
 */
#define	D_TAPE		0x0001
#define	D_DISK		0x0002
#define	D_TTY		0x0004
#define	D_MEM		0x0008
#define	D_TYPEMASK	0xffff

#define NUMCDEVSW 256

/*
 * Note: d_thread_t is provided as a transition aid for those drivers
 * that treat struct proc/struct thread as an opaque data type and
 * exist in substantially the same form in both 4.x and 5.x.  Writers
 * of drivers that dips into the d_thread_t structure should use
 * struct thread or struct proc as appropriate for the version of the
 * OS they are using.  It is provided in lieu of each device driver
 * inventing its own way of doing this.  While it does violate style(9)
 * in a number of ways, this violation is deemed to be less
 * important than the benefits that a uniform API between releases
 * gives.
 *
 * Users of struct thread/struct proc that aren't device drivers should
 * not use d_thread_t.
 */
typedef int d_open_t(dev_t dev, int oflags, int devtype, d_thread_t *p);
typedef int d_close_t(dev_t dev, int fflag, int devtype, d_thread_t *p);
typedef int d_read_t(dev_t dev, struct uio *uio, int ioflag);
typedef int d_write_t(dev_t dev, struct uio *uio, int ioflag);
typedef int d_ioctl_t(dev_t dev, u_long cmd, caddr_t data, int fflag, d_thread_t *p);
typedef int d_poll_t(dev_t dev, int events, d_thread_t *p);
typedef int d_mmap_t(dev_t dev, vm_offset_t offset, int nprot);
typedef void d_strategy_t(struct buf *bp);
typedef int d_dump_t(dev_t dev);
typedef int d_psize_t(dev_t dev);
typedef int d_kqfilter_t(dev_t dev, struct knote *kn);
//typedef int d_parms_t(dev_t dev, struct specinfo *sinfo, int ctl);

#define MAX_DEVICE_NAME	15

/*
 * Character device switch table
 */
struct cdevsw {
	d_open_t		*d_open;
	d_close_t		*d_close;
	d_read_t		*d_read;
	d_write_t		*d_write;
	d_ioctl_t		*d_ioctl;
	d_poll_t		*d_poll;
	d_mmap_t		*d_mmap;
	d_strategy_t	*d_strategy;
	const char		*d_name;		// base device name, e.g. 'vn'
	int				d_maj;			// reserved for lkms - /usr/src/sys/conf/majors
	d_dump_t		*d_dump;
	d_psize_t		*d_psize;
	u_int			d_flags;		// device types
	int				d_bmaj;
	// additions below are not binary compatible with 4.2 and below
	d_kqfilter_t	*d_kqfilter;
};

struct specinfo {
	int 			moduleFlag;		// ⥸塼ǥХʤ飱֤ܰϸ

	List			list;
	u_int			si_flags;
	udev_t			si_udev;
	char			si_name[MAX_DEVICE_NAME + 1];
	void			*si_drv1;
	void			*si_drv2;
	struct cdevsw	*si_devsw;

	uint			partType;		// ѡƥ󥿥

	// ࡼХ֥ǥѤ˥ǥХץˤꤵ
	size_t			beginSector;	// ֥åƬ
	size_t			sectors;		// ֥å
	int				sectSize;		// 
};

#define DEV_MODULE(name, evh, arg) \
int name##InitDevice(struct module *m, int what) \
{ \
	return evh(m, what, arg); \
}

#define BUF_STRATEGY(bp, dummy) (*devsw((bp)->b_dev)->d_strategy)(bp)

extern int cdevsw_add(struct cdevsw *new);
extern int major(const dev_t);
extern int minor(const dev_t);
extern udev_t makeudev(int, int);
extern dev_t make_dev(struct cdevsw *devsw, int minor, uid_t uid, gid_t gid, int perms, const char *fmt, ...);
extern void destroy_dev(dev_t dev);
extern struct cdevsw *devsw(dev_t);
extern d_open_t		noopen;
extern d_close_t	noclose;
extern d_read_t		noread;
extern d_write_t	nowrite;
extern d_ioctl_t	noioctl;
extern d_mmap_t		nommap;
extern d_kqfilter_t	nokqfilter;
extern d_dump_t		nodump;
extern d_open_t		nullopen;
extern d_close_t	nullclose;

#define	nostrategy	((d_strategy_t *)NULL)
#define	nopoll		seltrue
#define	nopsize		((d_psize_t *)NULL)


#endif /* ASM_FILE */


#endif /* !_SYS_CONF_H_ */
